/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.navigation.actions.Bundle;
import org.netbeans.modules.java.navigation.base.Filters;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;

public class NameActions {
    private NameActions() {
        throw new IllegalStateException();
    }

    public static Action createFullyQualifiedNameAction(@NonNull Filters filters) {
        assert (filters != null);
        return new FullyQualifiedNameAction(filters);
    }

    private static final class FullyQualifiedNameAction
    extends AbstractAction
    implements Presenter.Popup {
        private static final String ICON = "org/netbeans/modules/java/navigation/resources/fqn.png";
        private final Filters filters;
        private JRadioButtonMenuItem menuItem;

        public FullyQualifiedNameAction(@NonNull Filters filters) {
            assert (filters != null);
            this.filters = filters;
            this.putValue("Name", Bundle.LBL_FullyQualifiedName());
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)ICON, (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filters.setFqn(!this.filters.isFqn());
            this.updateMenuItem();
        }

        @NonNull
        public final JMenuItem getPopupPresenter() {
            JRadioButtonMenuItem result = this.obtainMenuItem();
            this.updateMenuItem();
            return result;
        }

        private void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(this.filters.isFqn());
        }

        @NonNull
        private JRadioButtonMenuItem obtainMenuItem() {
            if (this.menuItem == null) {
                this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
                this.menuItem.setAction(this);
            }
            return this.menuItem;
        }
    }
}

