/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.files;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.swing.text.Document;

public final class OpenedDocuments {
    private final Map<String, Document> openedDocuments = new ConcurrentHashMap<String, Document>();
    private final List<Consumer<String>> openedConsumers = new ArrayList<Consumer<String>>();

    public Collection<String> getUris() {
        return Collections.unmodifiableSet(this.openedDocuments.keySet());
    }

    public Document getDocument(String uri) {
        return this.openedDocuments.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOpened(String uri, Document doc) {
        this.openedDocuments.put(uri, doc);
        List<Consumer<String>> list = this.openedConsumers;
        synchronized (list) {
            for (Consumer<String> c : this.openedConsumers) {
                c.accept(uri);
            }
        }
    }

    public void notifyClosed(String uri) {
        this.openedDocuments.remove(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOpenedConsumer(Consumer<String> openedConsumer) {
        List<Consumer<String>> list = this.openedConsumers;
        synchronized (list) {
            this.openedConsumers.add(openedConsumer);
        }
        for (String uri : this.getUris()) {
            openedConsumer.accept(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOpenedConsumer(Consumer<String> openedConsumer) {
        List<Consumer<String>> list = this.openedConsumers;
        synchronized (list) {
            this.openedConsumers.remove(openedConsumer);
        }
    }
}

