/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.AlgorithmSuite;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Layout;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Token;
import com.sun.xml.ws.security.policy.MessageLayout;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class SymmetricBinding
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.SymmetricBinding,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    boolean populated = false;
    com.sun.xml.ws.security.policy.Token protectionToken;
    com.sun.xml.ws.security.policy.Token signatureToken;
    com.sun.xml.ws.security.policy.Token encryptionToken;
    MessageLayout layout = MessageLayout.Lax;
    com.sun.xml.ws.security.policy.AlgorithmSuite algSuite;
    boolean includeTimestamp = false;
    boolean disableTimestampSigning = false;
    boolean contentOnly = true;
    String protectionOrder = "SignBeforeEncrypting";
    boolean protectToken = false;
    boolean protectSignature = false;
    private SecurityPolicyVersion spVersion;

    public SymmetricBinding() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public SymmetricBinding(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getEncryptionToken() {
        this.populate();
        return this.encryptionToken;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getSignatureToken() {
        this.populate();
        return this.signatureToken;
    }

    @Override
    public com.sun.xml.ws.security.policy.Token getProtectionToken() {
        this.populate();
        return this.protectionToken;
    }

    public void setAlgorithmSuite(com.sun.xml.ws.security.policy.AlgorithmSuite algSuite) {
        this.algSuite = algSuite;
    }

    @Override
    public com.sun.xml.ws.security.policy.AlgorithmSuite getAlgorithmSuite() {
        this.populate();
        if (this.algSuite == null) {
            this.algSuite = new AlgorithmSuite();
            Constants.logger.log(Level.FINE, "Using Default Algorithm Suite Basic128");
        }
        return this.algSuite;
    }

    public void includeTimeStamp(boolean value) {
        this.includeTimestamp = value;
    }

    @Override
    public boolean isIncludeTimeStamp() {
        this.populate();
        return this.includeTimestamp;
    }

    @Override
    public boolean isDisableTimestampSigning() {
        this.populate();
        return this.disableTimestampSigning;
    }

    public void setLayout(MessageLayout layout) {
        this.layout = layout;
    }

    @Override
    public MessageLayout getLayout() {
        this.populate();
        return this.layout;
    }

    public void setEncryptionToken(com.sun.xml.ws.security.policy.Token token) {
        this.encryptionToken = token;
    }

    public void setSignatureToken(com.sun.xml.ws.security.policy.Token token) {
        this.signatureToken = token;
    }

    public void setProtectionToken(com.sun.xml.ws.security.policy.Token token) {
        this.protectionToken = token;
    }

    @Override
    public boolean isSignContent() {
        this.populate();
        return this.contentOnly;
    }

    public void setSignContent(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public void setProtectionOrder(String order) {
        this.protectionOrder = order;
    }

    @Override
    public String getProtectionOrder() {
        this.populate();
        return this.protectionOrder;
    }

    public void setTokenProtection(boolean value) {
        this.protectToken = value;
    }

    public void setSignatureProtection(boolean value) {
        this.protectSignature = value;
    }

    @Override
    public boolean getTokenProtection() {
        this.populate();
        return this.protectToken;
    }

    @Override
    public boolean getSignatureProtection() {
        this.populate();
        return this.protectSignature;
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (policy == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isSignatureToken(assertion, this.spVersion)) {
                    this.signatureToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isEncryptionToken(assertion, this.spVersion)) {
                    this.encryptionToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isProtectionToken(assertion, this.spVersion)) {
                    this.protectionToken = ((Token)assertion).getToken();
                    continue;
                }
                if (PolicyUtil.isAlgorithmAssertion(assertion, this.spVersion)) {
                    this.algSuite = (com.sun.xml.ws.security.policy.AlgorithmSuite)((Object)assertion);
                    String sigAlgo = assertion.getAttributeValue(new QName("signatureAlgorithm"));
                    this.algSuite.setSignatureAlgorithm(sigAlgo);
                    continue;
                }
                if (PolicyUtil.isIncludeTimestamp(assertion, this.spVersion)) {
                    this.includeTimestamp = true;
                    continue;
                }
                if (PolicyUtil.isEncryptBeforeSign(assertion, this.spVersion)) {
                    this.protectionOrder = "EncryptBeforeSigning";
                    continue;
                }
                if (PolicyUtil.isSignBeforeEncrypt(assertion, this.spVersion)) {
                    this.protectionOrder = "SignBeforeEncrypting";
                    continue;
                }
                if (PolicyUtil.isContentOnlyAssertion(assertion, this.spVersion)) {
                    this.contentOnly = false;
                    continue;
                }
                if (PolicyUtil.isMessageLayout(assertion, this.spVersion)) {
                    this.layout = ((Layout)assertion).getMessageLayout();
                    continue;
                }
                if (PolicyUtil.isProtectTokens(assertion, this.spVersion)) {
                    this.protectToken = true;
                    continue;
                }
                if (PolicyUtil.isEncryptSignature(assertion, this.spVersion)) {
                    this.protectSignature = true;
                    continue;
                }
                if (PolicyUtil.disableTimestampSigning(assertion)) {
                    this.disableTimestampSigning = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "SymmetricBinding");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

