/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.docker.api.Credentials;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public final class DockerConfig {
    private static final String DOCKER_HUB_DOMAIN = "index.docker.io";
    private static final String DOCKER_HUB_REGISTRY = "https://index.docker.io/v1/";
    private static DockerConfig instance;
    private final ConfigListener listener = new ConfigListener();
    private JSONObject auths;
    private Map<String, String> httpHeaders;

    private DockerConfig() {
    }

    public static synchronized DockerConfig getDefault() {
        if (instance == null) {
            instance = new DockerConfig();
            instance.init();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Credentials> getAllCredentials() throws IOException {
        JSONObject currentAuths;
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.loadCache();
            currentAuths = this.auths;
        }
        ArrayList<Credentials> ret = new ArrayList<Credentials>(currentAuths.size());
        for (Map.Entry e : currentAuths.entrySet()) {
            if (!(e.getKey() instanceof String)) continue;
            String registry = (String)e.getKey();
            JSONObject value = (JSONObject)e.getValue();
            if (value == null) continue;
            ret.add(DockerConfig.createCredentials(registry, value));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials(String registry) throws IOException {
        JSONObject currentAuths;
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.loadCache();
            currentAuths = this.auths;
        }
        Set<String> names = DockerConfig.generateRegistryNames(registry);
        JSONObject value = null;
        Iterator<String> it = names.iterator();
        while (value == null && it.hasNext()) {
            value = (JSONObject)currentAuths.get((Object)it.next());
        }
        if (value == null) {
            return null;
        }
        return DockerConfig.createCredentials(registry, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getHttpHeaders() throws IOException {
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.loadCache();
            return new HashMap<String, String>(this.httpHeaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(Credentials credentials) throws IOException {
        StringBuilder sb = new StringBuilder(credentials.getUsername());
        sb.append(':');
        sb.append(credentials.getPassword());
        String auth = Base64.getEncoder().encodeToString(sb.toString().getBytes("UTF-8"));
        JSONObject value = new JSONObject();
        value.put((Object)"auth", (Object)auth);
        value.put((Object)"email", (Object)credentials.getEmail());
        Pair<File, Boolean> fileDesc = DockerConfig.getConfigFile();
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            try (RandomAccessFile f = new RandomAccessFile((File)fileDesc.first(), "rw");
                 FileChannel ch = f.getChannel();){
                try (FileLock lock = ch.lock();){
                    JSONObject current = null;
                    if (f.length() > 0L) {
                        current = (JSONObject)new JSONParser().parse(Channels.newReader((ReadableByteChannel)ch, "UTF-8"));
                    }
                    if (current == null) {
                        current = new JSONObject();
                    }
                    JSONObject currentAuths = current;
                    if (!((Boolean)fileDesc.second()).booleanValue() && (currentAuths = (JSONObject)current.get((Object)"auths")) == null) {
                        currentAuths = new JSONObject();
                        current.put((Object)"auths", (Object)currentAuths);
                    }
                    currentAuths.put((Object)credentials.getRegistry(), (Object)value);
                    ch.truncate(0L);
                    Writer w = Channels.newWriter((WritableByteChannel)ch, "UTF-8");
                    current.writeJSONString(w);
                    w.flush();
                }
                catch (ParseException ex) {
                    throw new IOException(ex);
                }
            }
            finally {
                this.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeCredentials(Credentials credentials) throws IOException {
        Pair<File, Boolean> fileDesc = DockerConfig.getConfigFile();
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            try (RandomAccessFile f = new RandomAccessFile((File)fileDesc.first(), "rw");
                 FileChannel ch = f.getChannel();){
                JSONObject currentAuths;
                JSONObject current;
                FileLock lock;
                block33: {
                    block32: {
                        lock = ch.lock();
                        current = (JSONObject)new JSONParser().parse(Channels.newReader((ReadableByteChannel)ch, "UTF-8"));
                        if (f.length() > 0L) break block32;
                        if (lock == null) return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        lock.close();
                        return;
                    }
                    currentAuths = current;
                    if (((Boolean)fileDesc.second()).booleanValue() || (currentAuths = (JSONObject)current.get((Object)"auths")) != null) break block33;
                    if (lock == null) return;
                    lock.close();
                    return;
                }
                try {
                    currentAuths.remove((Object)credentials.getRegistry());
                    ch.truncate(0L);
                    Writer w = Channels.newWriter((WritableByteChannel)ch, "UTF-8");
                    current.writeJSONString(w);
                    w.flush();
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
            }
            finally {
                this.clearCache();
            }
            return;
        }
    }

    private void init() {
        FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)DockerConfig.getNewConfigFile());
        FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)DockerConfig.getOldConfigFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws IOException {
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            if (this.auths == null || this.httpHeaders == null) {
                Pair<JSONObject, Boolean> parsed = this.parse();
                if (parsed == null) {
                    this.auths = new JSONObject();
                    this.httpHeaders = new JSONObject();
                    return;
                }
                JSONObject currentAuths = (JSONObject)parsed.first();
                if (!((Boolean)parsed.second()).booleanValue()) {
                    currentAuths = (JSONObject)currentAuths.get((Object)"auths");
                }
                if (currentAuths == null) {
                    currentAuths = new JSONObject();
                }
                this.auths = currentAuths;
                JSONObject currentHeaders = null;
                if (!((Boolean)parsed.second()).booleanValue()) {
                    currentHeaders = (JSONObject)((JSONObject)parsed.first()).get((Object)"HttpHeaders");
                }
                if (currentHeaders == null) {
                    currentHeaders = new JSONObject();
                }
                this.httpHeaders = new HashMap<String, String>();
                for (Map.Entry e : currentHeaders.entrySet()) {
                    this.httpHeaders.put((String)e.getKey(), (String)e.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            this.auths = null;
            this.httpHeaders = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Pair<JSONObject, Boolean> parse() throws IOException {
        Pair<File, Boolean> fileDesc = DockerConfig.getConfigFile();
        DockerConfig dockerConfig = this;
        synchronized (dockerConfig) {
            if (((File)fileDesc.first()).isFile()) {
                Pair pair;
                FileLock lock;
                FileInputStream is;
                block22: {
                    JSONObject current;
                    block20: {
                        Pair<JSONObject, Boolean> pair2;
                        block21: {
                            is = new FileInputStream((File)fileDesc.first());
                            lock = is.getChannel().lock(0L, Long.MAX_VALUE, true);
                            InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(is), "UTF-8");
                            current = null;
                            if (((File)fileDesc.first()).length() > 0L) {
                                current = (JSONObject)new JSONParser().parse((Reader)r);
                            }
                            if (current != null) break block20;
                            pair2 = null;
                            if (lock == null) break block21;
                            lock.close();
                        }
                        return pair2;
                    }
                    pair = Pair.of((Object)current, (Object)((Boolean)fileDesc.second()));
                    if (lock == null) break block22;
                    lock.close();
                }
                return pair;
                {
                    catch (Throwable throwable) {
                        try {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ParseException ex) {
                            throw new IOException(ex);
                        }
                    }
                }
                finally {
                    is.close();
                }
            }
            return null;
        }
    }

    private static Credentials createCredentials(String registry, JSONObject value) throws IOException {
        if (value == null) {
            return null;
        }
        byte[] auth = Base64.getDecoder().decode((String)value.get((Object)"auth"));
        CharBuffer chars = Charset.forName("UTF-8").newDecoder().decode(ByteBuffer.wrap(auth));
        int index = -1;
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.get(i) != ':') continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new IOException("Malformed registry authentication record");
        }
        String username = new String(chars.array(), 0, index);
        char[] password = new char[chars.length() - index - 1];
        if (password.length > 0) {
            System.arraycopy(chars.array(), index + 1, password, 0, password.length);
        }
        return new Credentials(registry, username, password, (String)value.get((Object)"email"));
    }

    private static Pair<File, Boolean> getConfigFile() {
        File newFile = DockerConfig.getNewConfigFile();
        boolean oldConfig = false;
        File file = newFile;
        if (!file.isFile()) {
            file = DockerConfig.getOldConfigFile();
            oldConfig = true;
        }
        if (!file.isFile()) {
            file = newFile;
            oldConfig = false;
        }
        return Pair.of((Object)file, (Object)oldConfig);
    }

    private static File getNewConfigFile() {
        String configPath = System.getenv("DOCKER_CONFIG");
        if (configPath == null) {
            configPath = System.getProperty("user.home") + File.separatorChar + ".docker";
        }
        return new File(configPath, "config.json");
    }

    private static File getOldConfigFile() {
        return new File(System.getProperty("user.home"), ".dockercfg");
    }

    private static Set<String> generateRegistryNames(String registry) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (registry == null) {
            result.add(DOCKER_HUB_REGISTRY);
            result.addAll(DockerConfig.generateRegistryNames(DOCKER_HUB_DOMAIN));
            return result;
        }
        result.add(registry);
        DockerConfig.generatePaths(registry, result);
        if (!registry.contains("://")) {
            String https = "https://" + registry;
            result.add(https);
            DockerConfig.generatePaths(https, result);
            String http = "http://" + registry;
            result.add(http);
            DockerConfig.generatePaths(http, result);
        }
        return result;
    }

    private static void generatePaths(String registry, Set<String> result) {
        StringBuilder extended = new StringBuilder(registry);
        if (registry.endsWith("/")) {
            extended.append("v1");
        } else {
            extended.append("/v1");
        }
        result.add(extended.toString());
        extended.append("/");
        result.add(extended.toString());
    }

    private class ConfigListener
    implements FileChangeListener {
        private ConfigListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileChanged(FileEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileDeleted(FileEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileRenamed(FileRenameEvent fe) {
            DockerConfig.this.clearCache();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }
    }
}

