/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.AbstractTransferListener;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferCancelledException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferEvent;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeTransferListener
extends AbstractTransferListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTransferListener.class);
    private final TransferListener listener;

    public static TransferListener wrap(RepositorySystemSession session) {
        TransferListener listener = session.getTransferListener();
        if (listener == null) {
            return null;
        }
        return new SafeTransferListener(listener);
    }

    private SafeTransferListener(TransferListener listener) {
        this.listener = listener;
    }

    private void logError(TransferEvent event, Throwable e) {
        LOGGER.debug("Failed to dispatch transfer event '{}' to {}", event, this.listener.getClass().getCanonicalName(), e);
    }

    @Override
    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferInitiated(event);
            }
            catch (LinkageError | RuntimeException e) {
                this.logError(event, e);
            }
        }
    }

    @Override
    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferStarted(event);
            }
            catch (LinkageError | RuntimeException e) {
                this.logError(event, e);
            }
        }
    }

    @Override
    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferProgressed(event);
            }
            catch (LinkageError | RuntimeException e) {
                this.logError(event, e);
            }
        }
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferCorrupted(event);
            }
            catch (LinkageError | RuntimeException e) {
                this.logError(event, e);
            }
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        if (this.listener != null) {
            try {
                this.listener.transferSucceeded(event);
            }
            catch (LinkageError | RuntimeException e) {
                this.logError(event, e);
            }
        }
    }

    @Override
    public void transferFailed(TransferEvent event) {
        if (this.listener != null) {
            try {
                this.listener.transferFailed(event);
            }
            catch (LinkageError | RuntimeException e) {
                this.logError(event, e);
            }
        }
    }
}

