/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.proxy.reflection;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KVariance;
import kotlin.reflect.KVisibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeParameterState;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/KTypeParameterProxy;", "Lorg/jetbrains/kotlin/ir/interpreter/proxy/reflection/ReflectionProxy;", "Lkotlin/reflect/KTypeParameter;", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeParameterState;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "(Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeParameterState;Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;)V", "getCallInterceptor", "()Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "isReified", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "getState", "()Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeParameterState;", "upperBounds", "", "Lkotlin/reflect/KType;", "getUpperBounds", "()Ljava/util/List;", "variance", "Lkotlin/reflect/KVariance;", "getVariance", "()Lkotlin/reflect/KVariance;", "equals", "other", "", "hashCode", "", "toString", "ir.interpreter"})
public final class KTypeParameterProxy
implements KTypeParameter,
ReflectionProxy {
    @NotNull
    private final KTypeParameterState state;
    @NotNull
    private final CallInterceptor callInterceptor;

    public KTypeParameterProxy(@NotNull KTypeParameterState state, @NotNull CallInterceptor callInterceptor) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(callInterceptor, "callInterceptor");
        this.state = state;
        this.callInterceptor = callInterceptor;
    }

    @Override
    @NotNull
    public KTypeParameterState getState() {
        return this.state;
    }

    @Override
    @NotNull
    public CallInterceptor getCallInterceptor() {
        return this.callInterceptor;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.getState().getIrTypeParameter().getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "state.irTypeParameter.name.asString()");
        return string2;
    }

    @Override
    @NotNull
    public List<KType> getUpperBounds() {
        return this.getState().getUpperBounds(this.getCallInterceptor());
    }

    @Override
    @NotNull
    public KVariance getVariance() {
        KVariance kVariance;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getState().getIrTypeParameter().getVariance().ordinal()]) {
            case 1: {
                kVariance = KVariance.INVARIANT;
                break;
            }
            case 2: {
                kVariance = KVariance.IN;
                break;
            }
            case 3: {
                kVariance = KVariance.OUT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kVariance;
    }

    @Override
    public boolean isReified() {
        return this.getState().getIrTypeParameter().isReified();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KTypeParameterProxy)) {
            return false;
        }
        return Intrinsics.areEqual(this.getState(), ((KTypeParameterProxy)other).getState());
    }

    @Override
    public int hashCode() {
        return this.getState().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getState().toString();
    }

    @Override
    @Nullable
    public KVisibility toKVisibility(@NotNull DescriptorVisibility $this$toKVisibility) {
        return ReflectionProxy.DefaultImpls.toKVisibility(this, $this$toKVisibility);
    }

    @Override
    @NotNull
    public IrInterpreterEnvironment getEnvironment() {
        return ReflectionProxy.DefaultImpls.getEnvironment(this);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

