/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjdoc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.javacc.jjdoc.Generator;
import org.javacc.jjdoc.JJDoc;
import org.javacc.jjdoc.JJDocGlobals;
import org.javacc.jjdoc.JJDocOptions;
import org.javacc.parser.CppCodeProduction;
import org.javacc.parser.Expansion;
import org.javacc.parser.JavaCodeProduction;
import org.javacc.parser.NonTerminal;
import org.javacc.parser.NormalProduction;
import org.javacc.parser.RegularExpression;
import org.javacc.parser.TokenProduction;

public class TextGenerator
implements Generator {
    protected PrintWriter ostr;

    @Override
    public void text(String s) {
        this.print(s);
    }

    @Override
    public void print(String s) {
        this.ostr.print(s);
    }

    @Override
    public void documentStart() {
        this.ostr = this.create_output_stream();
        this.ostr.print("\nDOCUMENT START\n");
    }

    @Override
    public void documentEnd() {
        this.ostr.print("\nDOCUMENT END\n");
        this.ostr.close();
    }

    @Override
    public void specialTokens(String s) {
        this.ostr.print(s);
    }

    @Override
    public void nonterminalsStart() {
        this.text("NON-TERMINALS\n");
    }

    @Override
    public void nonterminalsEnd() {
    }

    @Override
    public void tokensStart() {
        this.text("TOKENS\n");
    }

    @Override
    public void handleTokenProduction(TokenProduction tp) {
        String text = JJDoc.getStandardTokenProductionText(tp);
        this.text(text);
    }

    @Override
    public void tokensEnd() {
    }

    @Override
    public void javacode(JavaCodeProduction jp) {
        this.productionStart(jp);
        this.text("java code");
        this.productionEnd(jp);
    }

    @Override
    public void cppcode(CppCodeProduction cp) {
        this.productionStart(cp);
        this.text("c++ code");
        this.productionEnd(cp);
    }

    @Override
    public void productionStart(NormalProduction np) {
        this.ostr.print("\t" + np.getLhs() + "\t:=\t");
    }

    @Override
    public void productionEnd(NormalProduction np) {
        this.ostr.print("\n");
    }

    @Override
    public void expansionStart(Expansion e, boolean first) {
        if (!first) {
            this.ostr.print("\n\t\t|\t");
        }
    }

    @Override
    public void expansionEnd(Expansion e, boolean first) {
    }

    @Override
    public void nonTerminalStart(NonTerminal nt) {
    }

    @Override
    public void nonTerminalEnd(NonTerminal nt) {
    }

    @Override
    public void reStart(RegularExpression r) {
    }

    @Override
    public void reEnd(RegularExpression r) {
    }

    protected PrintWriter create_output_stream() {
        if (JJDocOptions.getOutputFile().equals("")) {
            String suffix;
            if (JJDocGlobals.input_file.equals("standard input")) {
                return new PrintWriter(new OutputStreamWriter(System.out));
            }
            String ext = ".html";
            if (JJDocOptions.getText()) {
                ext = ".txt";
            } else if (JJDocOptions.getXText()) {
                ext = ".xtext";
            }
            int i = JJDocGlobals.input_file.lastIndexOf(46);
            JJDocGlobals.output_file = i == -1 ? JJDocGlobals.input_file + ext : ((suffix = JJDocGlobals.input_file.substring(i)).equals(ext) ? JJDocGlobals.input_file + ext : JJDocGlobals.input_file.substring(0, i) + ext);
        } else {
            JJDocGlobals.output_file = JJDocOptions.getOutputFile();
        }
        try {
            this.ostr = new PrintWriter(new FileWriter(JJDocGlobals.output_file));
        }
        catch (IOException e) {
            this.error("JJDoc: can't open output stream on file " + JJDocGlobals.output_file + ".  Using standard output.");
            this.ostr = new PrintWriter(new OutputStreamWriter(System.out));
        }
        return this.ostr;
    }

    @Override
    public void debug(String message) {
        System.err.println(message);
    }

    @Override
    public void info(String message) {
        System.err.println(message);
    }

    @Override
    public void warn(String message) {
        System.err.println(message);
    }

    @Override
    public void error(String message) {
        System.err.println(message);
    }
}

