/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUnknownMsSymbol;
import java.util.ArrayList;
import java.util.List;

public class UnknownX1168MsSymbol
extends AbstractUnknownMsSymbol {
    public static final int PDB_ID = 4456;
    private int count;
    private List<RecordNumber> typeRecordNumbers = new ArrayList<RecordNumber>();

    public UnknownX1168MsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.count = reader.parseInt();
        for (int i = 0; i < this.count; ++i) {
            RecordNumber typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
            this.typeRecordNumbers.add(typeRecordNumber);
        }
    }

    @Override
    public int getPdbId() {
        return 4456;
    }

    public List<RecordNumber> getTypeRecordNumbers() {
        return this.typeRecordNumbers;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(": Type List: {");
        DelimiterState ds = new DelimiterState("", ", ");
        for (RecordNumber typeRecordNumber : this.typeRecordNumbers) {
            builder.append(ds.out(true, this.pdb.getTypeRecord(typeRecordNumber).toString()));
        }
        builder.append("}\n");
    }

    @Override
    protected String getSymbolTypeName() {
        return "UNKNOWN_SYMBOL_X1168";
    }
}

