/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDString;
import mdemangler.naming.MDBasicName;
import mdemangler.naming.MDQualification;

public class MDQualifiedBasicName
extends MDParsableItem {
    private MDBasicName basicName;
    private MDQualification qualification;

    public MDQualifiedBasicName(MDMang dmang) {
        super(dmang);
        this.basicName = new MDBasicName(dmang);
        this.qualification = new MDQualification(dmang);
    }

    public boolean isTypeCast() {
        return this.basicName.isTypeCast();
    }

    public boolean isConstructor() {
        return this.basicName.isConstructor();
    }

    public boolean isDestructor() {
        return this.basicName.isDestructor();
    }

    public int getRTTINumber() {
        return this.basicName.getRTTINumber();
    }

    public boolean isString() {
        return this.basicName.isString();
    }

    public MDString getMDString() {
        if (this.isString()) {
            return this.basicName.getMDString();
        }
        return null;
    }

    @Override
    public void insert(StringBuilder builder) {
        this.basicName.insert(builder);
        if (this.qualification.hasContent()) {
            this.dmang.insertString(builder, "::");
            this.qualification.insert(builder);
        }
    }

    public void setCastTypeString(String castTypeString) {
        this.basicName.setCastTypeString(castTypeString);
    }

    public MDBasicName getBasicName() {
        return this.basicName;
    }

    public MDQualification getQualification() {
        return this.qualification;
    }

    public void setNameModifier(String nameModifier) {
        this.basicName.setNameModifier(nameModifier);
    }

    @Override
    protected void parseInternal() throws MDException {
        this.basicName.parse();
        this.qualification.parse();
        if (this.basicName.isConstructor()) {
            StringBuilder builder = new StringBuilder();
            this.qualification.insertHeadQualifier(builder);
            this.basicName.setName(builder.toString());
        } else if (this.basicName.isDestructor()) {
            StringBuilder builder = new StringBuilder();
            this.qualification.insertHeadQualifier(builder);
            this.dmang.insertString(builder, "~");
            this.basicName.setName(builder.toString());
        }
    }
}

