/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.debughost.DebugHostSymbol1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostType1;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostBaseClassImpl;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostModuleInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostSymbolInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostTypeInternal;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostModule1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostSymbol1;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostType1;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DebugHostModuleImpl1
extends DebugHostBaseClassImpl
implements DebugHostModuleInternal {
    private final IDebugHostModule1 jnaData;
    private long fileVersion;
    private long productVersion;

    public DebugHostModuleImpl1(IDebugHostModule1 jnaData) {
        super(jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public String getImageName(boolean allowPath) {
        WinDef.BOOL bAllowPath = new WinDef.BOOL(allowPath);
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetImageName(bAllowPath, bref));
        WTypes.BSTR bstr = bref.getValue();
        String imageName = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return imageName;
    }

    @Override
    public DbgModelNative.LOCATION getBaseLocation() {
        DbgModelNative.LOCATION.ByReference pLocation = new DbgModelNative.LOCATION.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetBaseLocation(pLocation));
        return new DbgModelNative.LOCATION(pLocation);
    }

    @Override
    public void getVersion() {
        WinDef.ULONGLONGByReference pulFileVersion = new WinDef.ULONGLONGByReference();
        WinDef.ULONGLONGByReference pulProductVersion = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetVersion(pulFileVersion, pulProductVersion));
        this.fileVersion = pulFileVersion.getValue().longValue();
        this.productVersion = pulProductVersion.getValue().longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 findTypeByName(String typeName) {
        PointerByReference ppType = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.FindTypeByName(new WString(typeName), ppType);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL) || hr.equals((Object)COMUtilsExtra.E_BOUNDS)) {
            System.out.println(typeName + " NOT FOUND");
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(ppType.getValue());
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostSymbol1 findSymbolByRVA(long rva) {
        WinDef.ULONGLONG ulRva = new WinDef.ULONGLONG(rva);
        PointerByReference ppSymbol = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.FindSymbolByRVA(ulRva, ppSymbol);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            System.out.println(rva + " NOT FOUND");
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIDebugHostSymbol1 wrap = new WrapIDebugHostSymbol1(ppSymbol.getValue());
        try {
            DebugHostSymbolInternal debugHostSymbolInternal = DebugHostSymbolInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostSymbolInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostSymbol1 findSymbolByName(String symbolName) {
        PointerByReference ppSymbol = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.FindSymbolByName(new WString(symbolName), ppSymbol);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            System.out.println(symbolName + " NOT FOUND");
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        WrapIDebugHostSymbol1 wrap = new WrapIDebugHostSymbol1(ppSymbol.getValue());
        try {
            DebugHostSymbolInternal debugHostSymbolInternal = DebugHostSymbolInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostSymbolInternal;
        }
        finally {
            wrap.Release();
        }
    }

    public long getFileVersion() {
        return this.fileVersion;
    }

    public long getProductVersion() {
        return this.productVersion;
    }

    @Override
    public DebugHostSymbol1 asSymbol() {
        return DebugHostSymbolInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((IDebugHostModule1)this.jnaData).QueryInterface(arg_0, arg_1));
    }
}

