/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.decmpfs;

import java.io.IOException;
import mobiledevices.dmg.ghidra.GBinaryReader;
import mobiledevices.dmg.ghidra.GStringUtilities;

public class DecmpfsHeader {
    private int compression_magic;
    private int compression_type;
    private long uncompressed_size;
    private byte[] attr_bytes;

    public DecmpfsHeader(GBinaryReader reader, int size) throws IOException {
        long nElements;
        long index = reader.getPointerIndex();
        this.compression_magic = reader.readNextInt();
        boolean originalEndian = reader.isLittleEndian();
        reader.setLittleEndian(true);
        this.compression_type = reader.readNextInt();
        this.uncompressed_size = reader.readNextLong();
        reader.setLittleEndian(originalEndian);
        long endIndex = index + (long)size + 1L;
        if (endIndex % 2L != 0L) {
            --endIndex;
        }
        if ((nElements = endIndex - reader.getPointerIndex()) % 2L != 0L) {
            ++nElements;
        } else if (nElements < 0L) {
            System.err.println("here");
        }
        this.attr_bytes = reader.readNextByteArray((int)nElements);
    }

    public String getCompressionMagic() {
        return GStringUtilities.toString(this.compression_magic);
    }

    public int getCompressionType() {
        return this.compression_type;
    }

    public long getUncompressedSize() {
        return this.uncompressed_size;
    }

    public byte[] getAttrBytes() {
        return this.attr_bytes;
    }
}

