/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.annotations.AnnotatingGraphMousePlugin;
import org.jungrapht.visualization.control.DefaultGraphMouse;
import org.jungrapht.visualization.control.EditingGraphMousePlugin;
import org.jungrapht.visualization.control.EditingPopupGraphMousePlugin;
import org.jungrapht.visualization.control.LabelEditingGraphMousePlugin;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.modal.Modal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditingDefaultGraphMouse<V, E>
extends DefaultGraphMouse<V, E>
implements ModalGraphMouse {
    private static final Logger log = LoggerFactory.getLogger(EditingDefaultGraphMouse.class);
    protected Supplier<V> vertexFactory;
    protected Supplier<E> edgeFactory;
    protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
    protected Map<V, String> vertexLabelMap;
    protected Map<E, String> edgeLabelMap;
    protected EditingGraphMousePlugin<V, E> editingPlugin;
    protected LabelEditingGraphMousePlugin<V, E> labelEditingPlugin;
    protected EditingPopupGraphMousePlugin<V, E> popupEditingPlugin;
    protected AnnotatingGraphMousePlugin<V, E> annotatingPlugin;
    protected MultiLayerTransformer basicTransformer;
    protected RenderContext<V, E> rc;
    protected Modal.Mode mode;
    protected KeyListener modeKeyListener;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public EditingDefaultGraphMouse(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.vertexFactory = builder.vertexFactory;
        this.edgeFactory = builder.edgeFactory;
        this.multiLayerTransformerSupplier = builder.multiLayerTransformerSupplier;
        this.vertexLabelMap = builder.vertexLabelMapSupplier.get();
        this.edgeLabelMap = builder.edgeLabelMapSupplier.get();
        this.basicTransformer = builder.multiLayerTransformerSupplier.get();
        this.rc = builder.renderContextSupplier.get();
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    public void loadPlugins() {
        super.loadPlugins();
        this.editingPlugin = EditingGraphMousePlugin.builder(this.vertexFactory, this.edgeFactory).build();
        this.labelEditingPlugin = new LabelEditingGraphMousePlugin<V, E>(this.vertexLabelMap, this.edgeLabelMap);
        this.annotatingPlugin = new AnnotatingGraphMousePlugin<V, E>(this.rc);
        this.popupEditingPlugin = new EditingPopupGraphMousePlugin<V, E>(this.vertexFactory, this.edgeFactory);
        this.setMode(this.mode);
    }

    @Override
    public void setMode(Modal.Mode mode) {
        this.mode = mode;
        if (mode == Modal.Mode.DEFAULT) {
            this.setDefaultMode();
        } else if (mode == Modal.Mode.EDITING) {
            this.setEditingMode();
        } else if (mode == Modal.Mode.ANNOTATING) {
            this.setAnnotatingMode();
        }
    }

    protected void setDefaultMode() {
        this.clear();
        this.add(this.selectingPlugin);
        this.add(this.regionSelectingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.scalingPlugin);
    }

    protected void setEditingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.labelEditingPlugin);
        this.add(this.editingPlugin);
        this.add(this.popupEditingPlugin);
    }

    protected void setAnnotatingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.annotatingPlugin);
    }

    public AnnotatingGraphMousePlugin<V, E> getAnnotatingPlugin() {
        return this.annotatingPlugin;
    }

    public EditingGraphMousePlugin<V, E> getEditingPlugin() {
        return this.editingPlugin;
    }

    public LabelEditingGraphMousePlugin<V, E> getLabelEditingPlugin() {
        return this.labelEditingPlugin;
    }

    public EditingPopupGraphMousePlugin<V, E> getPopupEditingPlugin() {
        return this.popupEditingPlugin;
    }

    @Override
    public Modal.Mode getMode() {
        return this.mode;
    }

    @Override
    public KeyListener getModeKeyListener() {
        return this.modeKeyListener;
    }

    public void setModeKeyListener(KeyListener modeKeyListener) {
        this.modeKeyListener = modeKeyListener;
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char d = (char)100;
        private char e = (char)101;
        private char a = (char)97;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char d, char e, char a, ModalGraphMouse graphMouse) {
            this.d = d;
            this.e = e;
            this.a = a;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.d) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(Modal.Mode.DEFAULT);
            } else if (keyChar == this.e) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(Modal.Mode.EDITING);
            } else if (keyChar == this.a) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(Modal.Mode.ANNOTATING);
            }
        }
    }

    public static class Builder<V, E, T extends EditingDefaultGraphMouse<V, E>, B extends Builder<V, E, T, B>>
    extends DefaultGraphMouse.Builder<V, E, T, B> {
        protected Supplier<V> vertexFactory;
        protected Supplier<E> edgeFactory;
        protected Supplier<Map<V, String>> vertexLabelMapSupplier = HashMap::new;
        protected Supplier<Map<E, String>> edgeLabelMapSupplier = HashMap::new;
        protected Supplier<MultiLayerTransformer> multiLayerTransformerSupplier;
        protected Supplier<RenderContext<V, E>> renderContextSupplier;

        public B vertexFactory(Supplier<V> vertexFactory) {
            this.vertexFactory = vertexFactory;
            return (B)((Builder)this.self());
        }

        public B edgeFactory(Supplier<E> edgeFactory) {
            this.edgeFactory = edgeFactory;
            return (B)((Builder)this.self());
        }

        public B vertexLabelMapSupplier(Supplier<Map<V, String>> vertexLabelMapSupplier) {
            this.vertexLabelMapSupplier = vertexLabelMapSupplier;
            return (B)((Builder)this.self());
        }

        public B edgeLabelMapSupplier(Supplier<Map<E, String>> edgeLabelMapSupplier) {
            this.edgeLabelMapSupplier = edgeLabelMapSupplier;
            return (B)((Builder)this.self());
        }

        public B multiLayerTransformerSupplier(Supplier<MultiLayerTransformer> multiLayerTransformerSupplier) {
            this.multiLayerTransformerSupplier = multiLayerTransformerSupplier;
            return (B)((Builder)this.self());
        }

        public B renderContextSupplier(Supplier<RenderContext<V, E>> renderContextSupplier) {
            this.renderContextSupplier = renderContextSupplier;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new EditingDefaultGraphMouse(this);
        }
    }
}

