/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;

public enum ByteArrayUtils {


    public static AddressSet computeDiffsAddressSet(Address start, byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be the same length");
        }
        Address end = start.add((long)(a.length - 1));
        AddressSet result = new AddressSet();
        Address diffStart = null;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) {
                if (diffStart == null) continue;
                result.add(diffStart, start.add((long)(i - 1)));
                continue;
            }
            if (diffStart != null) continue;
            diffStart = start.add((long)i);
        }
        if (diffStart != null) {
            result.add(diffStart, end);
        }
        return result;
    }
}

