/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugControlReentrant;
import agent.dbgeng.dbgeng.DebugEventInformation;
import agent.dbgeng.dbgeng.DebugExceptionFilterInformation;
import agent.dbgeng.dbgeng.DebugFilterInformation;
import agent.dbgeng.dbgeng.DebugSpecificFilterInformation;
import agent.dbgeng.dbgeng.DebugStackInformation;
import agent.dbgeng.dbgeng.DebugValue;
import com.sun.jna.platform.win32.COM.COMException;
import ghidra.comm.util.BitmaskSet;
import ghidra.comm.util.BitmaskUniverse;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public interface DebugControl
extends DebugControlReentrant {
    public static final BitmaskSet<DebugOutputControl> SET_ALL_CLIENTS = BitmaskSet.of((Enum[])new DebugOutputControl[]{DebugOutputControl.ALL_CLIENTS});
    public static final BitmaskSet<DebugExecute> SET_DEFAULT = BitmaskSet.of((Enum[])new DebugExecute[]{DebugExecute.DEFAULT});

    public boolean getInterrupt();

    public int getInterruptTimeout();

    public void setInterruptTimeout(int var1);

    public void print(BitmaskSet<DebugOutputLevel> var1, String var2);

    public void println(BitmaskSet<DebugOutputLevel> var1, String var2);

    default public void print(DebugOutputLevel level, String message) {
        this.print((BitmaskSet<DebugOutputLevel>)BitmaskSet.of((Enum[])new DebugOutputLevel[]{level}), message);
    }

    default public void println(DebugOutputLevel level, String message) {
        this.println((BitmaskSet<DebugOutputLevel>)BitmaskSet.of((Enum[])new DebugOutputLevel[]{level}), message);
    }

    default public void out(String message) {
        this.print(DebugOutputLevel.NORMAL, message);
    }

    default public void outln(String message) {
        this.println(DebugOutputLevel.NORMAL, message);
    }

    default public void warn(String message) {
        this.print(DebugOutputLevel.WARNING, message);
    }

    default public void warnln(String message) {
        this.println(DebugOutputLevel.WARNING, message);
    }

    default public void err(String message) {
        this.print(DebugOutputLevel.ERROR, message);
    }

    default public void errln(String message) {
        this.println(DebugOutputLevel.ERROR, message);
    }

    default public void verb(String message) {
        this.print(DebugOutputLevel.VERBOSE, message);
    }

    default public void verbln(String message) {
        this.println(DebugOutputLevel.VERBOSE, message);
    }

    public <T extends DebugValue> T evaluate(Class<T> var1, String var2);

    public void execute(BitmaskSet<DebugOutputControl> var1, String var2, BitmaskSet<DebugExecute> var3);

    default public void execute(String str) {
        this.execute(SET_ALL_CLIENTS, str, SET_DEFAULT);
    }

    public void prompt(BitmaskSet<DebugOutputControl> var1, String var2);

    public String getPromptText();

    public void returnInput(String var1);

    public DebugClient.DebugStatus getExecutionStatus();

    public void setExecutionStatus(DebugClient.DebugStatus var1);

    public int getNumberBreakpoints();

    public DebugBreakpoint getBreakpointByIndex(int var1);

    default public List<DebugBreakpoint> getBreakpoints() {
        int count = this.getNumberBreakpoints();
        ArrayList<DebugBreakpoint> result = new ArrayList<DebugBreakpoint>(count);
        for (int i = 0; i < count; ++i) {
            try {
                result.add(this.getBreakpointByIndex(i));
                continue;
            }
            catch (COMException e) {
                if (!COMUtilsExtra.isE_NOINTERFACE(e)) {
                    throw e;
                }
                Msg.trace((Object)this, (Object)("Discarding private breakpoint at index " + i));
            }
        }
        return result;
    }

    public DebugBreakpoint getBreakpointById(int var1);

    public DebugBreakpoint addBreakpoint(DebugBreakpoint.BreakType var1, int var2);

    public DebugBreakpoint addBreakpoint(DebugBreakpoint.BreakType var1);

    public DebugBreakpoint addBreakpoint2(DebugBreakpoint.BreakType var1, int var2);

    public DebugBreakpoint addBreakpoint2(DebugBreakpoint.BreakType var1);

    public void waitForEvent(int var1);

    public DebugEventInformation getLastEventInformation();

    public DebugStackInformation getStackTrace(long var1, long var3, long var5);

    default public void waitForEvent() {
        this.waitForEvent(-1);
    }

    public int getActualProcessorType();

    public int getEffectiveProcessorType();

    public int getExecutingProcessorType();

    public int getDebuggeeType();

    public DebugFilterInformation getNumberEventFilters();

    public String getEventFilterText(int var1, int var2);

    public String getEventFilterCommand(int var1, int var2);

    public void setEventFilterCommand(int var1, String var2);

    public DebugSpecificFilterInformation getSpecificFilterParameters(int var1, int var2);

    public void setSpecificFilterParameters(int var1, int var2, DebugSpecificFilterInformation var3);

    public String getSpecificFilterArgument(int var1, int var2);

    public void setSpecificFilterArgument(int var1, String var2);

    public DebugExceptionFilterInformation getExceptionFilterParameters(int var1, int[] var2, int var3);

    public void setExceptionFilterParameters(int var1, DebugExceptionFilterInformation var2);

    public String getExceptionFilterSecondCommand(int var1, int var2);

    public void setExceptionFilterSecondCommand(int var1, String var2);

    public static enum DebugFilterContinuationOption {
        DEBUG_FILTER_GO_HANDLED(0, "Handled"),
        DEBUG_FILTER_GO_NOT_HANDLED(1, "Not Handled");

        public final int val;
        public final String description;

        public static DebugFilterContinuationOption getByNumber(int val) {
            for (DebugFilterContinuationOption m : DebugFilterContinuationOption.values()) {
                if (m.val != val) continue;
                return m;
            }
            return null;
        }

        private DebugFilterContinuationOption(int val, String description) {
            this.val = val;
            this.description = description;
        }
    }

    public static enum DebugFilterExecutionOption {
        DEBUG_FILTER_BREAK(0, "Break"),
        DEBUG_FILTER_SECOND_CHANCE_BREAK(1, "Second-chance Break"),
        DEBUG_FILTER_OUTPUT(2, "Output-only"),
        DEBUG_FILTER_IGNORE(3, "Ignore"),
        DEBUG_FILTER_REMOVE(4, "Remove");

        public final int val;
        public final String description;

        public static DebugFilterExecutionOption getByNumber(int val) {
            for (DebugFilterExecutionOption m : DebugFilterExecutionOption.values()) {
                if (m.val != val) continue;
                return m;
            }
            return null;
        }

        private DebugFilterExecutionOption(int val, String description) {
            this.val = val;
            this.description = description;
        }
    }

    public static enum DebugFilterOrdinals {
        DEBUG_FILTER_CREATE_THREAD,
        DEBUG_FILTER_EXIT_THREAD,
        DEBUG_FILTER_CREATE_PROCESS,
        DEBUG_FILTER_EXIT_PROCESS,
        DEBUG_FILTER_LOAD_MODULE,
        DEBUG_FILTER_UNLOAD_MODULE,
        DEBUG_FILTER_SYSTEM_ERROR,
        DEBUG_FILTER_INITIAL_BREAKPOINT,
        DEBUG_FILTER_INITIAL_MODULE_LOAD,
        DEBUG_FILTER_DEBUGGEE_OUTPUT;

    }

    public static enum DebugInterrupt {
        ACTIVE,
        PASSIVE,
        EXIT;

    }

    public static enum DebugExecute implements BitmaskUniverse
    {
        DEFAULT(0),
        ECHO(1),
        NOT_LOGGED(2),
        NO_REPEAT(4);

        private final int mask;

        private DebugExecute(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum DebugOutputControl implements BitmaskUniverse
    {
        THIS_CLIENT(0),
        ALL_CLIENTS(1),
        ALL_OTHER_CLIENTS(2),
        IGNORE(3),
        LOG_ONLY(4),
        SEND_MASK(7),
        NOT_LOGGED(8),
        OVERRIDE_MASK(16),
        DML(32),
        AMBIENT_DML(-2),
        AMBIENT_TEXT(-1),
        AMBIENT(-1);

        private final int mask;

        private DebugOutputControl(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum DebugOutputLevel implements BitmaskUniverse
    {
        NORMAL(1),
        ERROR(2),
        WARNING(4),
        VERBOSE(8),
        PROMPT(16),
        PROMPT_REGISTERS(32),
        EXTENSION_WARNING(64),
        OUTPUT_DEBUGEE(128),
        OUTPUT_DEBUGEE_PROMPT(256),
        OUTPUT_SYMBOLS(512),
        OUTPUT_STATUS(1024);

        private final int mask;

        private DebugOutputLevel(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }
}

