/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DisplayableEol;
import ghidra.app.util.exporter.AbstractLineDispenser;
import ghidra.app.util.exporter.CommentLineDispenser;
import ghidra.app.util.exporter.ProgramTextOptions;
import ghidra.app.util.exporter.ReferenceLineDispenser;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.CodeUnitFormatOptions;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

class ProgramTextWriter {
    private static final String BEGIN_ANCHOR = "<A NAME=\"";
    private static final String END_ANCHOR = "\"></A>";
    private static final String BYTES_DELIM = "";
    private static final String STRUCT_PREFIX = "|_";
    private static final int INDENT_SPACES = 3;
    private ProgramTextOptions options;
    private StringBuilder buffy = new StringBuilder();
    private PrintWriter writer;
    private Program program;
    private Listing listing;
    private Memory memory;
    private AddressSetView addressSet;
    private ReferenceManager referenceManager;
    private SymbolTable symbolTable;
    private Function currentFunction;

    ProgramTextWriter(File file, Program program, AddressSetView addrSet, TaskMonitor monitor, ProgramTextOptions options, ServiceProvider provider) throws FileNotFoundException {
        long startTime;
        this.options = options;
        int len = options.getAddrWidth() + options.getBytesWidth() + options.getPreMnemonicWidth() + options.getMnemonicWidth() + options.getOperandWidth() + options.getEolWidth();
        this.program = program;
        this.listing = program.getListing();
        this.memory = program.getMemory();
        this.referenceManager = program.getReferenceManager();
        this.symbolTable = program.getSymbolTable();
        long time = startTime = System.currentTimeMillis();
        this.writer = new PrintWriter(new FileOutputStream(file));
        this.addressSet = addrSet == null ? program.getMemory() : addrSet.intersect((AddressSetView)this.memory);
        CodeUnitIterator cuIterator = this.listing.getCodeUnits(this.addressSet, true);
        if (options.isHTML()) {
            this.writer.print("<HTML><BODY BGCOLOR=#ffffe0>");
            this.writer.println("<FONT FACE=COURIER SIZE=3><STRONG><PRE>");
        }
        CodeUnitFormatOptions formatOptions = new CodeUnitFormatOptions(options.isShowBlockNameInOperands() ? CodeUnitFormatOptions.ShowBlockName.NON_LOCAL : CodeUnitFormatOptions.ShowBlockName.NEVER, CodeUnitFormatOptions.ShowNamespace.NON_LOCAL, null, true, true, true, true, true, true, true);
        CodeUnitFormat cuFormat = new CodeUnitFormat(formatOptions);
        Address bytesRemovedRangeStart = null;
        Address bytesRemovedRangeEnd = null;
        Address nextAddressExpected = null;
        while (cuIterator.hasNext() && !monitor.isCancelled()) {
            String[] post;
            DisplayableEol displayableEol;
            String[] eol;
            String[] pre;
            String[] params;
            CodeUnit currentCodeUnit = cuIterator.next();
            Address currentAddress = currentCodeUnit.getMinAddress();
            if (!this.addressSet.contains(currentAddress)) continue;
            long currTime = System.currentTimeMillis();
            if (currTime > time + 1000L) {
                monitor.setMessage("Processing ... " + currentAddress);
                time = currTime;
            }
            if (!options.isShowUndefinedData() && currentCodeUnit instanceof Data && !((Data)currentCodeUnit).isDefined()) {
                if (bytesRemovedRangeStart == null) {
                    bytesRemovedRangeStart = currentAddress;
                } else if (!nextAddressExpected.equals((Object)currentAddress)) {
                    this.insertUndefinedBytesRemovedMarker(bytesRemovedRangeStart, bytesRemovedRangeEnd);
                    bytesRemovedRangeStart = currentAddress;
                }
                bytesRemovedRangeEnd = currentCodeUnit.getMaxAddress();
                nextAddressExpected = bytesRemovedRangeEnd.addWrap(1L);
                if (!options.isHTML() || !currentCodeUnit.getReferenceIteratorTo().hasNext()) continue;
                this.writer.print(BEGIN_ANCHOR + this.toHREF(currentAddress) + END_ANCHOR);
                continue;
            }
            if (bytesRemovedRangeStart != null) {
                this.insertUndefinedBytesRemovedMarker(bytesRemovedRangeStart, bytesRemovedRangeEnd);
                bytesRemovedRangeStart = null;
            }
            if (options.isHTML()) {
                this.writer.print(BEGIN_ANCHOR + this.toHREF(currentAddress) + END_ANCHOR);
            }
            this.currentFunction = this.listing.getFunctionContaining(currentAddress);
            boolean isFunctionEntryPoint = this.currentFunction != null && this.currentFunction.getEntryPoint().equals((Object)currentAddress);
            boolean cuHasPlate = false;
            if (options.isShowProperties()) {
                String[] plate = currentCodeUnit.getCommentAsArray(3);
                boolean bl = cuHasPlate = plate != null && plate.length > 0;
                if (cuHasPlate) {
                    this.processPlate(currentCodeUnit, plate);
                } else if (isFunctionEntryPoint) {
                    this.processPlate(currentCodeUnit, new String[]{"FUNCTION"});
                }
            }
            if (isFunctionEntryPoint) {
                Variable[] locals;
                String fill = this.genFill(options.getAddrWidth() + options.getBytesWidth());
                String repeatableComment = this.currentFunction.getRepeatableComment();
                if (repeatableComment != null) {
                    this.writer.println(fill + options.getCommentPrefix() + repeatableComment);
                }
                this.writer.println(fill + options.getCommentPrefix() + this.currentFunction.getPrototypeString(false, false));
                for (String param : params = this.currentFunction.getParameters()) {
                    this.processVariable((Variable)param);
                }
                for (Variable local : locals = this.currentFunction.getLocalVariables()) {
                    this.processVariable(local);
                }
            }
            if (options.isShowComments() && (pre = currentCodeUnit.getCommentAsArray(1)) != null && pre.length > 0) {
                String fill = this.genFill(options.getAddrWidth() + options.getBytesWidth());
                params = pre;
                int locals = params.length;
                for (int i = 0; i < locals; ++i) {
                    String element = params[i];
                    this.writeComments(element, fill);
                }
            }
            ArrayList<String> symbolLines = new ArrayList<String>();
            if (options.getLabelWidth() > 0 && (!isFunctionEntryPoint || isFunctionEntryPoint && options.isShowFunctionLabel())) {
                Symbol[] symbols = currentCodeUnit.getSymbols();
                if (symbols.length > 0) {
                    this.makePrimaryLastItem(symbols);
                    params = symbols;
                    int locals = params.length;
                    for (int i = 0; i < locals; ++i) {
                        String symbol2 = params[i];
                        String symbol = symbol2.getName() + options.getLabelSuffix();
                        symbolLines.add(this.clip(symbol, options.getLabelWidth(), true, true));
                    }
                } else {
                    SymbolIterator it;
                    Symbol s;
                    Address nextAddr = currentAddress.next();
                    if (nextAddr != null && (s = (it = this.symbolTable.getSymbolIterator(nextAddr, true)).next()) != null && s.getAddress().compareTo((Object)currentCodeUnit.getMaxAddress()) <= 0) {
                        String symbol = SymbolUtilities.getDynamicOffcutName((Address)currentAddress) + options.getLabelSuffix();
                        symbolLines.add(this.clip(symbol, options.getLabelWidth(), true, true));
                    }
                }
            }
            ReferenceLineDispenser backRLD = options.isShowBackReferences() ? new ReferenceLineDispenser(false, currentCodeUnit, program, options) : new ReferenceLineDispenser();
            ReferenceLineDispenser fwdRLD = options.isShowForwardReferences() ? new ReferenceLineDispenser(true, currentCodeUnit, program, options) : new ReferenceLineDispenser();
            String emptySymbolLine = this.genFill(options.getLabelWidth());
            int preSymbolWidth = options.getAddrWidth() + options.getBytesWidth();
            int backRefEmptyFlag = 0;
            while (!symbolLines.isEmpty() || backRLD.hasMoreLines() || fwdRLD.hasMoreLines()) {
                this.buffy = new StringBuilder();
                this.buffy.append(this.genFill(preSymbolWidth));
                if (symbolLines.isEmpty()) {
                    this.buffy.append(emptySymbolLine);
                } else {
                    this.buffy.append((String)symbolLines.remove(0));
                }
                if (backRLD.hasMoreLines()) {
                    this.buffy.append(backRLD.getNextLine());
                } else {
                    ++backRefEmptyFlag;
                }
                if (backRefEmptyFlag > 0 && fwdRLD.hasMoreLines()) {
                    this.buffy.append(fwdRLD.getNextLine());
                }
                this.writer.println(this.buffy.toString());
            }
            backRLD.dispose();
            fwdRLD.dispose();
            this.buffy = new StringBuilder();
            this.processAddress(currentCodeUnit.getMinAddress(), null);
            this.processBytes(currentCodeUnit);
            this.processMnemonic(currentCodeUnit);
            this.processOperand(currentCodeUnit, cuFormat);
            if (options.isShowComments() && (eol = (displayableEol = new DisplayableEol(currentCodeUnit, false, false, false, true, 6, true, true)).getComments()) != null && eol.length > 0) {
                len = options.getAddrWidth() + options.getBytesWidth() + options.getPreMnemonicWidth() + options.getMnemonicWidth() + options.getOperandWidth();
                String fill = this.genFill(len);
                for (int i = 0; i < eol.length; ++i) {
                    Object eolcmt;
                    if (i > 0) {
                        this.buffy.append(fill);
                    }
                    if (((String)(eolcmt = options.getCommentPrefix() + eol[i])).length() > options.getEolWidth()) {
                        eolcmt = this.clip((String)eolcmt, options.getEolWidth(), true, true);
                    }
                    this.buffy.append((String)eolcmt);
                    this.writer.println(this.buffy.toString());
                    this.buffy = new StringBuilder();
                }
            }
            if (this.buffy.length() > 0) {
                this.writer.println(this.buffy.toString());
            }
            this.buffy = new StringBuilder();
            if (options.isShowComments() && (post = currentCodeUnit.getCommentAsArray(2)) != null) {
                String fill = this.genFill(options.getAddrWidth() + options.getBytesWidth());
                for (String element : post) {
                    this.writeComments(element, fill);
                }
            }
            if (currentCodeUnit instanceof Data && options.isShowStructures()) {
                Data data = (Data)currentCodeUnit;
                this.processSubData(data, 1, cuFormat);
            }
            if (!options.isShowProperties() || !currentCodeUnit.hasProperty("Space")) continue;
            try {
                this.processSpace(currentCodeUnit.getIntProperty("Space"));
            }
            catch (NoValueException noValueException) {}
        }
        if (bytesRemovedRangeStart != null) {
            this.insertUndefinedBytesRemovedMarker(bytesRemovedRangeStart, bytesRemovedRangeEnd);
        }
        if (options.isHTML()) {
            this.writer.println("</PRE></STRONG></FONT></BODY></HTML>");
        }
        this.writer.close();
    }

    private void insertUndefinedBytesRemovedMarker(Address bytesRemovedRangeStart, Address bytesRemovedRangeEnd) {
        this.writer.println();
        this.buffy = new StringBuilder();
        if (this.options.isHTML()) {
            this.writer.print("<FONT COLOR=#ff0000>");
        }
        this.processAddress(bytesRemovedRangeStart, null);
        this.buffy.append(" -> ");
        this.processAddress(bytesRemovedRangeEnd, null);
        this.buffy.append(" [UNDEFINED BYTES REMOVED]");
        this.writer.print(this.buffy.toString());
        if (this.options.isHTML()) {
            this.writer.print("</FONT>");
        }
        this.writer.println();
        this.writer.println();
    }

    private String toHREF(Address addr) {
        return AbstractLineDispenser.getUniqueAddressString(addr);
    }

    private String toHREF(Variable var) {
        return var.getFunction().getName() + "_" + var.getName();
    }

    private String genFill(int length) {
        return AbstractLineDispenser.getFill(length);
    }

    private String clip(String s, int len, boolean padIfShorter, boolean leftJustify) {
        return AbstractLineDispenser.clip(s, len, padIfShorter, leftJustify);
    }

    private void processVariable(Variable var) {
        int offset;
        this.buffy = new StringBuilder();
        this.buffy.append(this.genFill(this.options.getStackVarPreNameWidth()));
        if (this.options.isHTML()) {
            this.buffy.append(BEGIN_ANCHOR + this.toHREF(var) + END_ANCHOR);
        }
        String clipName = this.clip(this.options.getCommentPrefix() + var.getName(), this.options.getStackVarNameWidth() - 1, true, true);
        this.buffy.append(clipName);
        this.buffy.append(this.genFill(this.options.getStackVarNameWidth() - clipName.length()));
        String clipDataTypeName = this.clip(var.getDataType().getDisplayName(), this.options.getStackVarDataTypeWidth() - 1, true, true);
        this.buffy.append(clipDataTypeName);
        this.buffy.append(this.genFill(this.options.getStackVarDataTypeWidth() - clipDataTypeName.length()));
        Object offsetStr = BYTES_DELIM;
        offsetStr = var.isStackVariable() ? ((offset = var.getStackOffset()) >= 0 ? Integer.toHexString(offset) : "-" + Integer.toHexString(-offset)) : (var.isRegisterVariable() ? var.getRegister().getName() : var.getVariableStorage().toString());
        String clipOffset = this.clip((String)offsetStr, this.options.getStackVarOffsetWidth() - 1, true, false);
        this.buffy.append(clipOffset);
        this.buffy.append(this.genFill(this.options.getStackVarOffsetWidth() - clipOffset.length()));
        CommentLineDispenser cld = new CommentLineDispenser(var, this.options.getStackVarCommentWidth(), this.options.getStackVarPreNameWidth() + this.options.getStackVarNameWidth() + this.options.getStackVarDataTypeWidth() + this.options.getStackVarOffsetWidth(), this.options.getCommentPrefix());
        ReferenceLineDispenser xld = new ReferenceLineDispenser(var, this.program, this.options);
        if (cld.hasMoreLines()) {
            this.buffy.append(cld.getNextLine());
        } else {
            this.buffy.append(AbstractLineDispenser.getFill(cld.width));
        }
        this.buffy.append(" ");
        if (xld.hasMoreLines()) {
            this.buffy.append(xld.getNextLine());
        }
        this.writer.println(this.buffy.toString());
        while (cld.hasMoreLines() || xld.hasMoreLines()) {
            this.buffy = new StringBuilder();
            this.buffy.append(cld.getFill());
            if (cld.hasMoreLines()) {
                this.buffy.append(cld.getNextLine());
            }
            this.buffy.append(" ");
            if (xld.hasMoreLines()) {
                this.buffy.append(xld.getNextLine());
            }
            this.writer.println(this.buffy.toString());
        }
        cld.dispose();
        xld.dispose();
    }

    private void processAddress(Address cuAddress, String prefix) {
        MemoryBlock block;
        int width;
        if (prefix != null) {
            this.buffy.append(prefix);
        }
        if ((width = this.options.getAddrWidth()) < 1) {
            return;
        }
        Object addrstr = cuAddress.toString();
        if (this.options.isShowBlockName() && (block = this.memory.getBlock(cuAddress)) != null) {
            addrstr = block.getName() + ":" + (String)addrstr;
        }
        this.buffy.append(this.clip((String)addrstr, width, true, true));
    }

    private void addReferenceLinkedText(Reference ref, String text, boolean checkForVariable) {
        Variable var = null;
        if (ref != null && this.options.isHTML()) {
            var = this.referenceManager.getReferencedVariable(ref);
        }
        if (var == null) {
            Address toAddr = ref != null ? ref.getToAddress() : null;
            this.addAddressLinkedText(toAddr, text);
            return;
        }
        this.buffy.append("<A HREF=\"#");
        this.buffy.append(this.toHREF(var));
        this.buffy.append("\">");
        this.buffy.append(text);
        this.buffy.append("</A>");
    }

    private void addAddressLinkedText(Address toAddr, String text) {
        boolean includeLink = false;
        if (toAddr != null && this.options.isHTML()) {
            boolean bl = includeLink = toAddr.isMemoryAddress() && this.addressSet.contains(toAddr);
        }
        if (includeLink) {
            this.buffy.append("<A HREF=\"#");
            this.buffy.append(this.toHREF(toAddr));
            this.buffy.append("\">");
        }
        this.buffy.append(text);
        if (includeLink) {
            this.buffy.append("</A>");
        }
    }

    private void processMnemonic(CodeUnit cu) {
        int width = this.options.getMnemonicWidth();
        if (width < 1) {
            return;
        }
        this.buffy.append(this.genFill(this.options.getPreMnemonicWidth()));
        String mnemonic = cu.getMnemonicString();
        String mnemonicText = this.clip(mnemonic, width - 1, false, true);
        if (this.options.isHTML()) {
            Reference primRef = this.referenceManager.getPrimaryReferenceFrom(cu.getAddress(), -1);
            this.addReferenceLinkedText(primRef, mnemonicText, true);
        } else {
            this.buffy.append(mnemonicText);
        }
        this.buffy.append(this.clip(BYTES_DELIM, width - mnemonic.length(), true, true));
    }

    private void processBytes(CodeUnit cu) {
        int width = this.options.getBytesWidth();
        if (width < 1) {
            return;
        }
        try {
            byte[] bytes = cu.getBytes();
            StringBuffer bytesbuf = new StringBuffer();
            for (int i = 0; i < bytes.length; ++i) {
                if (i > 0) {
                    bytesbuf.append(BYTES_DELIM);
                }
                if (bytes[i] >= 0 && bytes[i] <= 15) {
                    bytesbuf.append("0");
                }
                bytesbuf.append(Integer.toHexString(bytes[i] & 0xFF));
            }
            this.buffy.append(this.clip(bytesbuf.toString(), width, true, true));
        }
        catch (MemoryAccessException mae) {
            this.buffy.append(this.clip(BYTES_DELIM, width, true, true));
        }
    }

    private void processOperand(CodeUnit cu, CodeUnitFormat cuFormat) {
        int width = this.options.getOperandWidth();
        if (width < 1) {
            return;
        }
        Address cuAddress = cu.getMinAddress();
        if (cu instanceof Instruction) {
            Instruction inst = (Instruction)cu;
            int opCnt = inst.getNumOperands();
            int opLens = opCnt - 1;
            if (opCnt > 0) {
                String[] opReps = new String[opCnt];
                for (int i = 0; i < opCnt; ++i) {
                    opReps[i] = cuFormat.getOperandRepresentationString(cu, i);
                    opLens += opReps[i].length();
                }
                boolean clipRequired = opLens > width;
                opLens = opCnt - 1;
                for (int i = 0; i < opCnt; ++i) {
                    if (i > 0) {
                        this.buffy.append(",");
                    }
                    if (clipRequired) {
                        opReps[i] = this.clip(opReps[i], (width - opLens) / (opCnt - i), false, true);
                    }
                    opLens += opReps[i].length();
                    if (this.options.isHTML()) {
                        Reference ref = cu.getProgram().getReferenceManager().getPrimaryReferenceFrom(cuAddress, i);
                        this.addReferenceLinkedText(ref, opReps[i], true);
                        continue;
                    }
                    this.buffy.append(opReps[i]);
                }
            }
            String fill = this.genFill(width - opLens);
            this.buffy.append(fill);
        } else if (cu instanceof Data) {
            Data data = (Data)cu;
            String opRep = cuFormat.getDataValueRepresentationString(data);
            String opData = this.clip(opRep, width, false, true);
            String fill = this.genFill(width - opData.length());
            Reference mr = this.referenceManager.getPrimaryReferenceFrom(cuAddress, 0);
            this.addReferenceLinkedText(mr, opData, false);
            this.buffy.append(fill);
        }
    }

    private void processSubData(Data data, int indentLevel, CodeUnitFormat cuFormat) {
        int componentCount = data.getNumComponents();
        for (int i = 0; i < componentCount; ++i) {
            Data component = data.getComponent(i);
            if (component == null) {
                return;
            }
            String fill = this.genFill(indentLevel * 3);
            this.buffy = new StringBuilder();
            if (this.options.isHTML()) {
                this.buffy.append(BEGIN_ANCHOR + this.toHREF(component.getMinAddress()) + END_ANCHOR);
            }
            this.processAddress(component.getMinAddress(), fill + STRUCT_PREFIX);
            this.processDataFieldName(component);
            this.processMnemonic((CodeUnit)component);
            this.processOperand((CodeUnit)component, cuFormat);
            this.writer.println(this.buffy.toString());
            this.processSubData(component, indentLevel + 1, cuFormat);
        }
    }

    private void processDataFieldName(Data data) {
        int width = this.options.getDataFieldNameWidth();
        if (width < 1) {
            return;
        }
        String str = this.clip(data.getFieldName(), width, true, true);
        this.buffy.append(str);
    }

    private void makePrimaryLastItem(Symbol[] symbols) {
        for (int i = 0; i < symbols.length - 1; ++i) {
            if (!symbols[i].isPrimary()) continue;
            Symbol primary = symbols[i];
            System.arraycopy(symbols, i + 1, symbols, i, symbols.length - i - 1);
            symbols[symbols.length - 1] = primary;
            break;
        }
    }

    private void processPlate(CodeUnit cu, String[] plate) {
        if (cu == null) {
            return;
        }
        if (plate == null || plate.length == 0) {
            return;
        }
        int x = 0;
        int before = 2;
        int after = 0;
        int len = 0;
        int width = this.options.getPreMnemonicWidth() + this.options.getMnemonicWidth() + this.options.getOperandWidth() + this.options.getEolWidth();
        if (width == 0) {
            return;
        }
        String fill = this.genFill(this.options.getAddrWidth() + this.options.getBytesWidth());
        StringBuffer stars = new StringBuffer();
        for (x = 0; x < width; ++x) {
            stars.append("*");
        }
        if (this.options.isHTML()) {
            this.writeComments(stars.toString(), fill);
        } else {
            this.writeComments(stars.toString(), fill);
        }
        for (String element : plate) {
            String s = this.clip(element, width, false, true);
            len = s.length();
            if (plate.length == 1) {
                before = (width - 2 - len) / 2;
            }
            after = width - 2 - len - before;
            String pre = this.genFill(before);
            String post = this.genFill(after);
            this.writeComments("*" + pre + s + post + "*", fill);
        }
        this.writeComments(stars.toString(), fill);
    }

    private void processSpace(int type) {
        for (int x = 0; x < type; ++x) {
            this.buffy = new StringBuilder();
            this.writer.println(this.buffy.toString());
        }
    }

    private void writeComments(String what, String fill) {
        this.buffy = new StringBuilder();
        if (fill != null) {
            this.buffy.append(fill);
        }
        this.buffy.append(this.options.getCommentPrefix());
        this.buffy.append(what);
        this.writer.println(this.buffy.toString());
    }
}

