/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.exporter;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.exporter.Exporter;
import ghidra.app.util.exporter.ExporterException;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class BinaryExporter
extends Exporter {
    public BinaryExporter() {
        super("Binary", "bin", new HelpLocation("ExporterPlugin", "binary"));
    }

    @Override
    public boolean export(File file, DomainObject domainObj, AddressSetView addrSet, TaskMonitor monitor) throws IOException, ExporterException {
        if (!(domainObj instanceof Program)) {
            this.log.appendMsg("Unsupported type: " + domainObj.getClass().getName());
            return false;
        }
        Program program = (Program)domainObj;
        Memory memory = program.getMemory();
        if (addrSet == null) {
            addrSet = memory;
        }
        FileOutputStream fos = new FileOutputStream(file);
        AddressSet set = new AddressSet(addrSet);
        MemoryBlock[] blocks = memory.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i].isInitialized()) continue;
            set.delete((AddressRange)new AddressRangeImpl(blocks[i].getStart(), blocks[i].getEnd()));
        }
        try {
            AddressRangeIterator iter = set.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                byte[] mem = new byte[(int)range.getLength()];
                int numBytes = memory.getBytes(range.getMinAddress(), mem);
                fos.write(mem, 0, numBytes);
            }
        }
        catch (MemoryAccessException e) {
            throw new ExporterException((Exception)((Object)e));
        }
        finally {
            fos.close();
        }
        return true;
    }

    @Override
    public List<Option> getOptions(DomainObjectService domainObjectService) {
        return EMPTY_OPTIONS;
    }

    @Override
    public void setOptions(List<Option> options) {
    }
}

