/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.encoding;

import java.util.HashMap;
import java.util.Map;

public enum DWARFInline {
    DW_INL_not_inlined(0),
    DW_INL_inlined(1),
    DW_INL_declared_not_inlined(2),
    DW_INL_declared_inlined(3);

    private final int value;
    private static final Map<Integer, DWARFInline> valueMap;

    private DWARFInline(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DWARFInline find(Number key) {
        DWARFInline access = valueMap.get(key.intValue());
        if (access != null) {
            return access;
        }
        throw new IllegalArgumentException("Invalid Integer value: " + key.toString());
    }

    static {
        valueMap = new HashMap<Integer, DWARFInline>();
        for (DWARFInline access : DWARFInline.values()) {
            valueMap.put(access.getValue(), access);
        }
    }
}

