/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.progmgr.AbstractProgramNameSwitchingAction;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;

public class CloseProgramAction
extends AbstractProgramNameSwitchingAction {
    public CloseProgramAction(ProgramManagerPlugin plugin, String group, int subGroup) {
        super(plugin, "Close File");
        MenuData menuData = new MenuData(new String[]{"&File", "&Close"});
        menuData.setMenuGroup(group);
        menuData.setMenuSubGroup(Integer.toString(subGroup));
        this.setMenuBarData(menuData);
        this.setKeyBindingData(new KeyBindingData("ctrl o"));
    }

    @Override
    protected void programChanged(Program program) {
        if (program == null) {
            this.getMenuBarData().setMenuItemName("&Close");
            this.setDescription("Close Program");
        } else {
            String programName = "'" + program.getDomainFile().getName() + "'";
            this.getMenuBarData().setMenuItemName("&Close " + programName);
            this.setDescription("<html>Close " + HTMLUtilities.escapeHTML((String)programName));
        }
    }

    @Override
    public void actionPerformed(Program program) {
        this.plugin.closeProgram(program, false);
    }
}

