/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Jar;
import generic.io.NullPrintWriter;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BuildError;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.GhidraBundle;
import ghidra.app.plugin.core.osgi.GhidraBundleActivator;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import ghidra.app.plugin.core.osgi.OSGiException;
import ghidra.app.plugin.core.osgi.OSGiUtils;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ResourceFileJavaFileManager;
import ghidra.app.script.ResourceFileJavaFileObject;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWiring;
import org.phidias.compile.BundleJavaManager;
import utilities.util.FileUtilities;

public class GhidraSourceBundle
extends GhidraBundle {
    private static final String GENERATED_ACTIVATOR_CLASSNAME = "GeneratedActivator";
    private static final String GENERATED_VERSION = "1.0";
    private static final Predicate<String> IS_CLASS_FILE = Pattern.compile("(\\$.*)?\\.class", 2).asMatchPredicate();
    private final String symbolicName;
    private final Path binaryDir;
    private final String bundleLoc;
    private final List<ResourceFile> newSources = new ArrayList<ResourceFile>();
    private final List<Path> oldBinaries = new ArrayList<Path>();
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final Map<ResourceFile, BuildError> buildErrors = new HashMap<ResourceFile, BuildError>();
    private final Map<ResourceFile, List<BundleRequirement>> sourceFileToRequirements = new HashMap<ResourceFile, List<BundleRequirement>>();
    private final Map<String, List<ResourceFile>> requirementToSourceFileMap = new HashMap<String, List<ResourceFile>>();
    private final Set<String> importPackageValues = new HashSet<String>();
    private Set<String> missedRequirements = new HashSet<String>();
    private long lastCompileAttempt;

    public GhidraSourceBundle(BundleHost bundleHost, ResourceFile sourceDirectory, boolean enabled, boolean systemBundle) {
        super(bundleHost, sourceDirectory, enabled, systemBundle);
        this.symbolicName = GhidraSourceBundle.sourceDirHash(this.getSourceDirectory());
        this.binaryDir = GhidraSourceBundle.getCompiledBundlesDir().resolve(this.symbolicName);
        this.bundleLoc = "reference:file://" + this.binaryDir.toAbsolutePath().normalize().toString();
    }

    protected final ResourceFile getSourceDirectory() {
        return this.file;
    }

    public static Path getCompiledBundlesDir() {
        return BundleHost.getOsgiDir().resolve("compiled-bundles");
    }

    public static String sourceDirHash(ResourceFile sourceDir) {
        return Integer.toHexString(sourceDir.getAbsolutePath().hashCode());
    }

    public static Path getBindirFromScriptFile(ResourceFile sourceFile) {
        ResourceFile tmpSourceDir = sourceFile.getParentFile();
        String tmpSymbolicName = GhidraSourceBundle.sourceDirHash(tmpSourceDir);
        return GhidraSourceBundle.getCompiledBundlesDir().resolve(tmpSymbolicName);
    }

    public String classNameForScript(ResourceFile sourceFile) throws ClassNotFoundException {
        String relativePath = FileUtilities.relativizePath((ResourceFile)this.getSourceDirectory(), (ResourceFile)sourceFile);
        if (relativePath == null) {
            throw new ClassNotFoundException(String.format("Failed to find script file '%s' in source directory '%s'", sourceFile, this.getSourceDirectory()));
        }
        relativePath = relativePath.substring(0, relativePath.length() - 5);
        return relativePath.replace(File.separatorChar, '.');
    }

    void clearBuildErrors(ResourceFile sourceFile) {
        this.buildErrors.remove(sourceFile);
    }

    protected void buildError(ResourceFile sourceFile, String err) {
        BuildError error = this.buildErrors.computeIfAbsent(sourceFile, BuildError::new);
        error.append(err);
    }

    public BuildError getErrors(ResourceFile sourceFile) {
        return this.buildErrors.get(sourceFile);
    }

    public Map<ResourceFile, BuildError> getAllErrors() {
        return Collections.unmodifiableMap(this.buildErrors);
    }

    private String getPreviousBuildErrors() {
        return this.buildErrors.values().stream().map(BuildError::getMessage).collect(Collectors.joining());
    }

    private String parseImportPackageMetadata(ResourceFile javaSource) {
        return GhidraScriptUtil.newScriptInfo(javaSource).getImportPackage();
    }

    private void updateRequirementsFromMetadata() throws GhidraBundleException {
        this.sourceFileToRequirements.clear();
        this.requirementToSourceFileMap.clear();
        this.importPackageValues.clear();
        for (ResourceFile rootSourceFile : this.getSourceDirectory().listFiles()) {
            List<BundleRequirement> requirements;
            String importPackage;
            if (!rootSourceFile.getName().endsWith(".java") || (importPackage = this.parseImportPackageMetadata(rootSourceFile)) == null || importPackage.isEmpty()) continue;
            this.importPackageValues.addAll(ManifestParser.parseDelimitedString((String)importPackage.strip(), (String)","));
            try {
                requirements = OSGiUtils.parseImportPackage(importPackage);
            }
            catch (BundleException e) {
                throw new GhidraBundleException(this.getLocationIdentifier(), "@importpackage error", e);
            }
            this.sourceFileToRequirements.put(rootSourceFile, requirements);
            for (BundleRequirement requirement : requirements) {
                this.requirementToSourceFileMap.computeIfAbsent(requirement.toString(), x -> new ArrayList()).add(rootSourceFile);
            }
        }
    }

    private Map<String, BundleRequirement> getComputedReqs() {
        HashMap<String, BundleRequirement> dedupedReqs = new HashMap<String, BundleRequirement>();
        this.sourceFileToRequirements.values().stream().flatMap(Collection::stream).forEach(r -> dedupedReqs.putIfAbsent(r.toString(), (BundleRequirement)r));
        return dedupedReqs;
    }

    protected ManifestParser createSourceManifestParser() {
        ResourceFile manifestFile = this.getSourceManifestFile();
        if (manifestFile.exists()) {
            ManifestParser manifestParser;
            block9: {
                InputStream manifestInputStream = manifestFile.getInputStream();
                try {
                    Manifest manifest = new Manifest(manifestInputStream);
                    Attributes mainAttributes = manifest.getMainAttributes();
                    Map<String, Object> headerMap = mainAttributes.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
                    manifestParser = new ManifestParser(null, null, null, headerMap);
                    if (manifestInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (manifestInputStream != null) {
                            try {
                                manifestInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | BundleException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                manifestInputStream.close();
            }
            return manifestParser;
        }
        return null;
    }

    @Override
    public List<BundleRequirement> getAllRequirements() throws GhidraBundleException {
        ManifestParser manifestParser = this.createSourceManifestParser();
        if (manifestParser != null) {
            return manifestParser.getRequirements();
        }
        this.updateRequirementsFromMetadata();
        Map<String, BundleRequirement> reqs = this.getComputedReqs();
        return new ArrayList<BundleRequirement>(reqs.values());
    }

    protected static void findPackageDirs(List<String> packages, ResourceFile directory) {
        for (ResourceFile file : directory.listFiles(f -> f.isDirectory() || f.getName().endsWith(".java"))) {
            if (file.getName().matches("internal|private")) continue;
            boolean added = false;
            if (file.isDirectory()) {
                GhidraSourceBundle.findPackageDirs(packages, file);
                continue;
            }
            if (added) continue;
            added = true;
            packages.add(directory.getAbsolutePath());
        }
    }

    @Override
    public List<BundleCapability> getAllCapabilities() throws GhidraBundleException {
        ManifestParser manifestParser = this.createSourceManifestParser();
        if (manifestParser != null) {
            return manifestParser.getCapabilities();
        }
        int sourceDirLength = this.getSourceDirectory().getAbsolutePath().length() + 1;
        ArrayList<String> packageDirs = new ArrayList<String>();
        GhidraSourceBundle.findPackageDirs(packageDirs, this.getSourceDirectory());
        StringBuilder sb = new StringBuilder();
        for (String packageDir : packageDirs) {
            if (packageDir.length() <= sourceDirLength) continue;
            String packageName = packageDir.substring(sourceDirLength).replace(File.separatorChar, '.');
            sb.append(',');
            sb.append(packageName);
            sb.append(";version=\"1.0\"");
        }
        try {
            if (sb.length() == 0) {
                return Collections.emptyList();
            }
            return OSGiUtils.parseExportPackage(sb.substring(1));
        }
        catch (BundleException e) {
            throw new GhidraBundleException(this.getLocationIdentifier(), "exports error", e);
        }
    }

    void updateFromFilesystem(PrintWriter writer) throws IOException, OSGiException {
        this.newSources.clear();
        this.oldBinaries.clear();
        this.visitDiscrepancies((sourceFile, classFiles) -> {
            if (sourceFile != null) {
                this.newSources.add(sourceFile);
            }
            if (classFiles != null) {
                this.oldBinaries.addAll(classFiles);
            }
        });
        Iterator<ResourceFile> newSourceIterator = this.newSources.iterator();
        while (newSourceIterator.hasNext()) {
            ResourceFile newSourceFile = newSourceIterator.next();
            if (this.stillHasErrors(newSourceFile)) {
                newSourceIterator.remove();
                continue;
            }
            this.buildErrors.remove(newSourceFile);
        }
    }

    private boolean stillHasErrors(ResourceFile newSourceFile) {
        BuildError error = this.buildErrors.get(newSourceFile);
        return error != null && error.getLastModified() == newSourceFile.lastModified();
    }

    private void deleteOldBinaries() throws IOException {
        this.oldBinaries.sort(null);
        Iterable paths = () -> this.oldBinaries.stream().distinct().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).iterator();
        for (Path path : paths) {
            Files.delete(path);
        }
    }

    int getBuildErrorCount() {
        return this.buildErrors.size();
    }

    int getNewSourcesCount() {
        return this.newSources.size();
    }

    public List<ResourceFile> getNewSources() {
        return this.newSources;
    }

    void compileAttempted() {
        this.lastCompileAttempt = System.currentTimeMillis();
    }

    long getLastCompileAttempt() {
        return this.lastCompileAttempt;
    }

    @Override
    public String getLocationIdentifier() {
        return this.bundleLoc;
    }

    ResourceFile getSourceManifestFile() {
        return new ResourceFile(this.getSourceDirectory(), "META-INF" + File.separator + "MANIFEST.MF");
    }

    private Path getBinaryManifestPath() {
        return this.binaryDir.resolve("META-INF").resolve("MANIFEST.MF");
    }

    boolean hasSourceManifest() {
        return this.getSourceManifestFile().exists();
    }

    boolean hasNewManifest() {
        ResourceFile sourceManifest = this.getSourceManifestFile();
        Path binaryManifest = this.getBinaryManifestPath();
        return sourceManifest.exists() && (Files.notExists(binaryManifest, new LinkOption[0]) || sourceManifest.lastModified() > binaryManifest.toFile().lastModified());
    }

    protected static boolean wipeContents(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            boolean anythingDeleted = false;
            try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
                for (Path p : walk.sorted(Comparator.reverseOrder())::iterator) {
                    anythingDeleted |= Files.deleteIfExists(p);
                }
            }
            return anythingDeleted;
        }
        return false;
    }

    private boolean wipeBinDir() throws IOException {
        return GhidraSourceBundle.wipeContents(this.binaryDir);
    }

    private void addSourcesIfResolutionWillPass() {
        for (ResourceFile sourceFile : this.buildErrors.keySet()) {
            List<BundleRequirement> requirements = this.sourceFileToRequirements.get(sourceFile);
            if (requirements == null || requirements.isEmpty() || !this.bundleHost.canResolveAll(requirements)) continue;
            if (!this.newSources.contains(sourceFile)) {
                this.newSources.add(sourceFile);
            }
            for (ResourceFile oldbin : this.correspondingBinaries(sourceFile)) {
                oldbin.delete();
            }
        }
    }

    void addSourcesIfResolutionWillFail() {
        for (Map.Entry<ResourceFile, List<BundleRequirement>> e : this.sourceFileToRequirements.entrySet()) {
            ResourceFile sourceFile = e.getKey();
            List<BundleRequirement> requirements = e.getValue();
            if (requirements == null || requirements.isEmpty() || this.buildErrors.containsKey(sourceFile) || this.bundleHost.canResolveAll(requirements)) continue;
            if (!this.newSources.contains(sourceFile)) {
                this.newSources.add(sourceFile);
            }
            Arrays.stream(this.correspondingBinaries(sourceFile)).map(rf -> rf.getFile(false).toPath()).forEach(this.oldBinaries::add);
        }
    }

    @Override
    public boolean build(PrintWriter writer) throws Exception {
        if (writer == null) {
            writer = new NullPrintWriter();
        }
        boolean needsCompile = false;
        if (this.hasSourceManifest()) {
            this.sourceFileToRequirements.clear();
            this.requirementToSourceFileMap.clear();
            ArrayList<BundleRequirement> reqs = new ArrayList<BundleRequirement>(this.getAllRequirements());
            this.bundleHost.resolve(reqs);
            HashSet<String> newMissedRequirements = new HashSet<String>();
            for (BundleRequirement req : reqs) {
                newMissedRequirements.add(req.toString());
            }
            if (this.hasNewManifest() || !newMissedRequirements.equals(this.missedRequirements)) {
                this.missedRequirements = newMissedRequirements;
                this.wipeBinDir();
                this.buildErrors.clear();
            }
            this.updateFromFilesystem(writer);
        } else {
            this.updateFromFilesystem(writer);
            this.updateRequirementsFromMetadata();
            this.addSourcesIfResolutionWillPass();
            this.addSourcesIfResolutionWillFail();
        }
        int buildErrorsLastTime = this.getBuildErrorCount();
        int newSourceCount = this.getNewSourcesCount();
        if (newSourceCount == 0) {
            if (buildErrorsLastTime > 0) {
                writer.printf("%s hasn't changed, with %d file%s failing in previous build(s):\n", this.getSourceDirectory().toString(), buildErrorsLastTime, buildErrorsLastTime > 1 ? "s" : "");
                writer.printf("%s\n", this.getPreviousBuildErrors());
                writer.flush();
            }
        } else {
            needsCompile = true;
        }
        if (!this.binaryDir.toFile().exists()) {
            needsCompile = true;
        }
        if (needsCompile) {
            Bundle osgiBundle = this.bundleHost.getOSGiBundle(this.getLocationIdentifier());
            if (osgiBundle != null) {
                this.bundleHost.deactivateSynchronously(osgiBundle);
            }
            this.deleteOldBinaries();
            String summary = this.compileToExplodedBundle(writer);
            this.bundleHost.notifyBundleBuilt(this, summary);
            return true;
        }
        this.bundleHost.notifyBundleBuilt(this, null);
        return false;
    }

    @Override
    public boolean clean() {
        boolean anythingChanged = false;
        if (!this.buildErrors.isEmpty()) {
            this.buildErrors.clear();
            anythingChanged |= true;
        }
        try {
            Bundle bundle = this.getOSGiBundle();
            if (bundle != null) {
                this.bundleHost.deactivateSynchronously(bundle);
            }
            return anythingChanged | this.wipeBinDir();
        }
        catch (GhidraBundleException | IOException e) {
            Msg.showError((Object)this, null, (String)"Source bundle clean error", (Object)"While attempting to delete the compiled directory, an exception was thrown", (Throwable)e);
            return anythingChanged;
        }
    }

    private ResourceFile[] correspondingBinaries(ResourceFile source) {
        String parentPath = source.getParentFile().getAbsolutePath();
        String relPath = parentPath.substring(this.getSourceDirectory().getAbsolutePath().length());
        if (relPath.startsWith(File.separator)) {
            relPath = relPath.substring(1);
        }
        String className0 = source.getName();
        String className = className0.substring(0, className0.length() - 5);
        ResourceFile binarySubdir = new ResourceFile(this.binaryDir.resolve(relPath).toFile());
        if (!binarySubdir.exists() || !binarySubdir.isDirectory()) {
            return new ResourceFile[0];
        }
        return binarySubdir.listFiles(f -> {
            String fileName = f.getName();
            return fileName.startsWith(className) && IS_CLASS_FILE.test(fileName.substring(className.length()));
        });
    }

    protected void visitDiscrepancies(DiscrepencyCallback callback) {
        try {
            ArrayDeque<ResourceFile> stack = new ArrayDeque<ResourceFile>();
            stack.add(this.getSourceDirectory());
            while (!stack.isEmpty()) {
                ResourceFile sourceSubdir = (ResourceFile)stack.pop();
                String relPath = sourceSubdir.getAbsolutePath().substring(this.getSourceDirectory().getAbsolutePath().length());
                if (relPath.startsWith(File.separator)) {
                    relPath = relPath.substring(1);
                }
                Path binarySubdir = this.binaryDir.resolve(relPath);
                ClassMapper mapper = new ClassMapper(binarySubdir);
                for (ResourceFile sourceFile : sourceSubdir.listFiles()) {
                    if (sourceFile.isDirectory()) {
                        stack.push(sourceFile);
                        continue;
                    }
                    List<Path> classFiles = mapper.findAndRemove(sourceFile);
                    if (classFiles == null) continue;
                    callback.found(sourceFile, classFiles);
                }
                if (!mapper.hasExtraClassFiles()) continue;
                callback.found(null, mapper.extraClassFiles());
            }
        }
        catch (Throwable e) {
            Msg.error((Object)this, (Object)"Exception while searching for file system discrepancies ", (Throwable)e);
        }
    }

    private boolean resolveInternally(List<BundleRequirement> requirements) throws GhidraBundleException {
        if (requirements.isEmpty()) {
            return true;
        }
        List<BundleCapability> capabilities = this.getAllCapabilities();
        Iterator<BundleRequirement> requirementIterator = requirements.iterator();
        boolean anyMissing = false;
        while (requirementIterator.hasNext()) {
            BundleRequirement requirement = requirementIterator.next();
            if (capabilities.stream().anyMatch(arg_0 -> ((BundleRequirement)requirement).matches(arg_0))) {
                requirementIterator.remove();
                continue;
            }
            anyMissing = true;
        }
        return !anyMissing;
    }

    private BundleJavaManager createBundleJavaManager(PrintWriter writer, Summary summary, List<String> options) throws IOException, GhidraBundleException {
        ResourceFileJavaFileManager resourceFileJavaManager = new ResourceFileJavaFileManager(Collections.singletonList(this.getSourceDirectory()), this.buildErrors.keySet());
        MyBundleJavaManager bundleJavaManager = new MyBundleJavaManager((Bundle)this.bundleHost.getHostFramework(), resourceFileJavaManager, options);
        List<BundleRequirement> requirements = this.getAllRequirements();
        List<BundleWiring> bundleWirings = this.bundleHost.resolve(requirements);
        if (!this.resolveInternally(requirements)) {
            writer.printf("%d import requirement%s remain%s unresolved:\n", requirements.size(), requirements.size() > 1 ? "s" : "", requirements.size() > 1 ? "" : "s");
            for (BundleRequirement requirement : requirements) {
                List<ResourceFile> requiringFiles = this.requirementToSourceFileMap.get(requirement.toString());
                if (requiringFiles != null && requiringFiles.size() > 0) {
                    writer.printf("  %s, from %s\n", requirement.toString(), requiringFiles.stream().map(generic.util.Path::toPathString).collect(Collectors.joining(",")));
                    for (ResourceFile sourceFile : requiringFiles) {
                        this.buildError(sourceFile, generic.util.Path.toPathString((ResourceFile)sourceFile) + " : failed import " + OSGiUtils.extractPackageNamesFromFailedResolution(requirement.toString()));
                    }
                    continue;
                }
                writer.printf("  %s\n", requirement.toString());
            }
            summary.printf("%d missing package import%s:%s", requirements.size(), requirements.size() > 1 ? "s" : "", requirements.stream().flatMap(r -> OSGiUtils.extractPackageNamesFromFailedResolution(r.toString()).stream()).distinct().collect(Collectors.joining(",")));
        }
        bundleWirings.forEach(arg_0 -> ((BundleJavaManager)bundleJavaManager).addBundleWiring(arg_0));
        return bundleJavaManager;
    }

    private boolean tryBuild(PrintWriter writer, BundleJavaManager bundleJavaManager, List<ResourceFileJavaFileObject> sourceFiles, List<String> options) throws IOException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(writer, (JavaFileManager)bundleJavaManager, diagnostics, options, null, sourceFiles);
        Boolean successfulCompilation = task.call();
        if (successfulCompilation.booleanValue()) {
            return true;
        }
        HashSet<ResourceFileJavaFileObject> filesWithErrors = new HashSet<ResourceFileJavaFileObject>();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            String error = diagnostic.toString() + "\n";
            writer.write(error);
            ResourceFileJavaFileObject sourceFileObject = (ResourceFileJavaFileObject)diagnostic.getSource();
            ResourceFile sourceFile = sourceFileObject.getFile();
            this.buildError(sourceFile, error);
            filesWithErrors.add(sourceFileObject);
        }
        for (ResourceFileJavaFileObject sourceFileObject : filesWithErrors) {
            if (sourceFiles.remove(sourceFileObject)) {
                writer.printf("skipping %s\n", sourceFileObject.getFile().toString());
                continue;
            }
            throw new IOException("compilation error loop condition for " + sourceFileObject.getFile().toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateManifest(PrintWriter writer, Summary summary, Path binaryManifest) throws OSGiException, IOException {
        Analyzer analyzer = new Analyzer();
        analyzer.setJar(new Jar(this.binaryDir.toFile()));
        analyzer.setProperty("Bundle-SymbolicName", GhidraSourceBundle.sourceDirHash(this.getSourceDirectory()));
        analyzer.setProperty("Bundle-Version", GENERATED_VERSION);
        if (!this.importPackageValues.isEmpty()) {
            analyzer.setProperty("Import-Package", this.importPackageValues.stream().collect(Collectors.joining(",")) + ",*");
        } else {
            analyzer.setProperty("Import-Package", "*");
        }
        analyzer.setProperty("Export-Package", "!*.private.*,!*.internal.*,*");
        try {
            Manifest manifest;
            try {
                manifest = analyzer.calcManifest();
            }
            catch (Exception e) {
                summary.print("bad manifest");
                throw new OSGiException("failed to calculate manifest by analyzing code", e);
            }
            String activatorClassName = null;
            try {
                for (Object clazz : analyzer.getClassspace().values()) {
                    if (!clazz.is(Clazz.QUERY.IMPLEMENTS, new Instruction("org.osgi.framework.BundleActivator"), analyzer)) continue;
                    System.err.printf("found BundleActivator class %s\n", clazz);
                    activatorClassName = clazz.toString();
                }
            }
            catch (Exception e) {
                summary.print("failed bnd analysis");
                throw new OSGiException("failed to query classes while searching for activator", e);
            }
            Attributes manifestAttributes = manifest.getMainAttributes();
            if (activatorClassName == null) {
                activatorClassName = GENERATED_ACTIVATOR_CLASSNAME;
                if (!this.buildDefaultActivator(this.binaryDir, activatorClassName, writer)) {
                    Object clazz;
                    summary.print("failed to build generated activator");
                    clazz = summary.getValue();
                    return clazz;
                }
                String imps = manifestAttributes.getValue("Import-Package");
                if (imps == null) {
                    manifestAttributes.putValue("Import-Package", GhidraBundleActivator.class.getPackageName());
                } else {
                    manifestAttributes.putValue("Import-Package", imps + "," + GhidraBundleActivator.class.getPackageName());
                }
            }
            manifestAttributes.putValue("Bundle-Activator", activatorClassName);
            Files.createDirectories(binaryManifest.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(binaryManifest, new OpenOption[0]);){
                manifest.write(out);
            }
        }
        finally {
            analyzer.close();
        }
        return summary.getValue();
    }

    private boolean buildDefaultActivator(Path bindir, String activatorClassName, Writer writer) throws IOException {
        Path activatorSourceFileName = bindir.resolve(activatorClassName + ".java");
        try (PrintWriter activatorWriter = new PrintWriter(Files.newBufferedWriter(activatorSourceFileName, Charset.forName("UTF-8"), new OpenOption[0]));){
            activatorWriter.println("import " + GhidraBundleActivator.class.getName() + ";");
            activatorWriter.println("import org.osgi.framework.BundleActivator;");
            activatorWriter.println("import org.osgi.framework.BundleContext;");
            activatorWriter.println("public class GeneratedActivator extends GhidraBundleActivator {");
            activatorWriter.println("  protected void start(BundleContext bc, Object api) {");
            activatorWriter.println("    // TODO: stuff to do on bundle start");
            activatorWriter.println("  }");
            activatorWriter.println("  protected void stop(BundleContext bc, Object api) {");
            activatorWriter.println("    // TODO: stuff to do on bundle stop");
            activatorWriter.println("  }");
            activatorWriter.println();
            activatorWriter.println("}");
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add("-g");
        options.add("-d");
        options.add(bindir.toString());
        options.add("-sourcepath");
        options.add(bindir.toString());
        options.add("-classpath");
        options.add(System.getProperty("java.class.path"));
        options.add("-proc:none");
        try (StandardJavaFileManager javaFileManager = this.compiler.getStandardFileManager(null, null, null);){
            MyBundleJavaManager bundleJavaManager;
            block20: {
                boolean bl;
                bundleJavaManager = new MyBundleJavaManager((Bundle)this.bundleHost.getHostFramework(), javaFileManager, options);
                try {
                    Iterable<? extends JavaFileObject> sourceFiles = javaFileManager.getJavaFileObjectsFromPaths((Iterable<? extends Path>)List.of(activatorSourceFileName));
                    DiagnosticCollector diagnostics = new DiagnosticCollector();
                    JavaCompiler.CompilationTask task = this.compiler.getTask(writer, (JavaFileManager)((Object)bundleJavaManager), diagnostics, options, null, sourceFiles);
                    if (task.call().booleanValue()) break block20;
                    for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                        writer.write(((JavaFileObject)diagnostic.getSource()).toString() + ": " + diagnostic.getMessage(null) + "\n");
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        bundleJavaManager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                bundleJavaManager.close();
                return bl;
            }
            boolean bl = true;
            bundleJavaManager.close();
            return bl;
        }
    }

    private String compileToExplodedBundle(PrintWriter writer) throws IOException, OSGiException {
        this.compileAttempted();
        Files.createDirectories(this.binaryDir, new FileAttribute[0]);
        Summary summary = new Summary();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-g");
        options.add("-d");
        options.add(this.binaryDir.toString());
        options.add("-sourcepath");
        options.add(this.getSourceDirectory().toString());
        options.add("-classpath");
        options.add(System.getProperty("java.class.path") + File.pathSeparator + this.binaryDir.toString());
        options.add("-proc:none");
        for (ResourceFile sourceFile : this.newSources) {
            this.clearBuildErrors(sourceFile);
        }
        try (BundleJavaManager bundleJavaManager = this.createBundleJavaManager(writer, summary, options);){
            ResourceFile sourceManifest;
            List<ResourceFileJavaFileObject> sourceFiles = this.newSources.stream().map(sf -> new ResourceFileJavaFileObject(sf.getParentFile(), (ResourceFile)sf, JavaFileObject.Kind.SOURCE)).collect(Collectors.toList());
            Path binaryManifest = this.getBinaryManifestPath();
            if (Files.exists(binaryManifest, new LinkOption[0])) {
                Files.delete(binaryManifest);
            }
            while (!sourceFiles.isEmpty() && !this.tryBuild(writer, bundleJavaManager, sourceFiles, options)) {
            }
            if (this.getBuildErrorCount() > 0) {
                int count = this.getBuildErrorCount();
                summary.printf("%d source file%s with errors", count, count > 1 ? "s" : "");
            }
            if ((sourceManifest = this.getSourceManifestFile()).exists()) {
                Files.createDirectories(binaryManifest.getParent(), new FileAttribute[0]);
                try (InputStream inStream = sourceManifest.getInputStream();){
                    Files.copy(inStream, binaryManifest, StandardCopyOption.REPLACE_EXISTING);
                }
                String string = summary.getValue();
                return string;
            }
            String string = this.generateManifest(writer, summary, binaryManifest);
            return string;
        }
    }

    private static class ClassMapper {
        final Map<String, List<Path>> classToClassFilesMap;

        ClassMapper(Path directory) throws IOException {
            if (!Files.exists(directory, new LinkOption[0])) {
                this.classToClassFilesMap = Collections.emptyMap();
                return;
            }
            try (Stream<Path> paths = Files.list(directory);){
                this.classToClassFilesMap = paths.filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".class")).collect(Collectors.groupingBy(this::getClassName));
            }
        }

        private String getClassName(Path p) {
            String fileName = p.getFileName().toString();
            int money = fileName.indexOf(36);
            if (money >= 0) {
                return fileName.substring(0, money);
            }
            return fileName.substring(0, fileName.length() - 6);
        }

        List<Path> findAndRemove(ResourceFile sourceFile) {
            long lastModifiedClassFile;
            String className = sourceFile.getName();
            if (!className.endsWith(".java")) {
                return null;
            }
            className = className.substring(0, className.length() - 5);
            long lastModifiedSource = sourceFile.lastModified();
            List<Path> classFiles = this.classToClassFilesMap.remove(className);
            if (classFiles == null) {
                classFiles = Collections.emptyList();
            }
            long l = lastModifiedClassFile = classFiles.isEmpty() ? -1L : classFiles.stream().mapToLong(p -> p.toFile().lastModified()).min().getAsLong();
            if (lastModifiedSource > lastModifiedClassFile) {
                return classFiles;
            }
            return null;
        }

        public boolean hasExtraClassFiles() {
            return !this.classToClassFilesMap.isEmpty();
        }

        public Collection<Path> extraClassFiles() {
            return this.classToClassFilesMap.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
        }
    }

    private static class Summary {
        static String SEPERATOR = ", ";
        final StringWriter stringWriter = new StringWriter();
        final PrintWriter printWriter = new PrintWriter((Writer)this.stringWriter, true);

        private Summary() {
        }

        void printf(String format, Object ... args) {
            if (this.stringWriter.getBuffer().length() > 0) {
                this.printWriter.write(SEPERATOR);
            }
            this.printWriter.printf(format, args);
        }

        void print(String arg) {
            this.printWriter.print(arg);
        }

        String getValue() {
            this.printWriter.flush();
            return this.stringWriter.getBuffer().toString();
        }
    }

    private static class MyBundleJavaManager
    extends BundleJavaManager {
        static URL[] EMPTY_URL_ARRAY = new URL[0];

        MyBundleJavaManager(Bundle bundle, JavaFileManager javaFileManager, List<String> options) throws IOException {
            super(bundle, javaFileManager, options);
        }

        public ClassLoader getClassLoader() {
            return new URLClassLoader(EMPTY_URL_ARRAY, super.getClassLoader());
        }
    }

    protected static interface DiscrepencyCallback {
        public void found(ResourceFile var1, Collection<Path> var2) throws Throwable;
    }
}

