/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class NextPreviousDifferentByteAction
extends AbstractNextPreviousAction {
    public NextPreviousDifferentByteAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Different Byte Value", owner, subGroup);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Different Byte Value";
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.loadImage((String)"images/V_slash.png");
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(86, 640);
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        return this.getNextPreviousAddress(monitor, program, address, true);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        return this.getNextPreviousAddress(monitor, program, address, false);
    }

    protected Address getNextPreviousAddress(TaskMonitor monitor, Program program, Address address, boolean forward) throws CancelledException {
        byte value = 0;
        try {
            value = program.getMemory().getByte(address);
        }
        catch (MemoryAccessException e) {
            CodeUnit codeUnit = this.getNextPreviousCodeUnit(program, address, forward);
            return codeUnit == null ? null : codeUnit.getAddress();
        }
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        if (cu != null) {
            address = forward ? cu.getMaxAddress() : cu.getMinAddress();
        }
        AddressSetView initialized = program.getMemory().getAllInitializedAddressSet();
        AddressIterator iterator = initialized.getAddresses(address, forward);
        iterator.next();
        Memory memory = program.getMemory();
        while (iterator.hasNext()) {
            monitor.checkCanceled();
            Address addr = (Address)iterator.next();
            try {
                byte testByte = memory.getByte(addr);
                if (testByte == value) continue;
                return addr;
            }
            catch (MemoryAccessException e) {
                throw new AssertException("Got MemoryAccessException when iterating over intialized memeory!");
            }
        }
        return null;
    }

    private CodeUnit getNextPreviousCodeUnit(Program program, Address address, boolean forward) {
        if (forward) {
            return program.getListing().getDefinedCodeUnitAfter(address);
        }
        return program.getListing().getDefinedCodeUnitBefore(address);
    }
}

