/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.actions.PopupActionProvider;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.plugin.core.functioncompare.FunctionComparison;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonModelListener;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.services.FunctionComparisonModel;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FunctionComparisonProvider
extends ComponentProviderAdapter
implements PopupActionProvider,
FunctionComparisonModelListener {
    protected static final String HELP_TOPIC = "FunctionComparison";
    protected FunctionComparisonPanel functionComparisonPanel;
    protected Plugin plugin;
    protected FunctionComparisonModel model;

    public FunctionComparisonProvider(Plugin plugin, String name, String owner) {
        this(plugin, name, owner, null);
    }

    public FunctionComparisonProvider(Plugin plugin, String name, String owner, Class<?> contextType) {
        super(plugin.getTool(), name, owner, contextType);
        this.plugin = plugin;
        this.model = new FunctionComparisonModel();
        this.model.addFunctionComparisonModelListener(this);
        this.functionComparisonPanel = this.getComponent();
        this.initFunctionComparisonPanel();
    }

    public FunctionComparisonPanel getComponent() {
        if (this.functionComparisonPanel == null) {
            this.functionComparisonPanel = new FunctionComparisonPanel(this, this.tool, null, null);
        }
        return this.functionComparisonPanel;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("FunctionComparisonProvider\n");
        buff.append("Name: ");
        buff.append(this.getName() + "\n");
        buff.append("Tab Text: ");
        buff.append(this.getTabText() + "\n");
        Function leftFunction = this.functionComparisonPanel.getLeftFunction();
        String leftName = leftFunction != null ? leftFunction.getName() : "No Function";
        buff.append("Function 1: " + leftName + "\n");
        Function rightFunction = this.functionComparisonPanel.getRightFunction();
        String rightName = rightFunction != null ? rightFunction.getName() : "No Function";
        buff.append("Function 2: " + rightName + "\n");
        buff.append("tool = " + this.tool + "\n");
        return buff.toString();
    }

    public ActionContext getActionContext(MouseEvent event) {
        CodeComparisonPanel<? extends FieldPanelCoordinator> currentComponent = this.functionComparisonPanel.getCurrentComponent();
        return currentComponent.getActionContext((ComponentProvider)this, event);
    }

    public void removeFromTool() {
        this.tool.removePopupActionProvider((PopupActionProvider)this);
        super.removeFromTool();
    }

    @Override
    public void modelChanged(List<FunctionComparison> data) {
        this.model.setComparisons(data);
        this.functionComparisonPanel.reload();
        this.setTabText(this.functionComparisonPanel.getDescription());
        this.closeIfEmpty();
    }

    public List<DockingActionIf> getPopupActions(Tool t, ActionContext context) {
        ListingCodeComparisonPanel dualListingPanel;
        if (context.getComponentProvider() == this && (dualListingPanel = this.functionComparisonPanel.getDualListingPanel()) != null) {
            ListingPanel leftPanel = dualListingPanel.getLeftPanel();
            return leftPanel.getHeaderActions(this.getName());
        }
        return new ArrayList<DockingActionIf>();
    }

    public FunctionComparisonModel getModel() {
        return this.model;
    }

    public void setModel(FunctionComparisonModel model) {
        this.model = model;
    }

    public void programClosed(Program program) {
        this.model.removeFunctions(program);
        this.closeIfEmpty();
    }

    public void removeFunctions(Program program) {
        this.model.removeFunctions(program);
        this.closeIfEmpty();
    }

    public void removeFunctions(Set<Function> functions) {
        functions.stream().forEach(f -> this.model.removeFunction((Function)f));
        this.closeIfEmpty();
    }

    public void programRestored(Program program) {
        CodeComparisonPanel<? extends FieldPanelCoordinator> comparePanel = this.functionComparisonPanel.getCurrentComponent();
        comparePanel.programRestored(program);
    }

    public void readConfigState(SaveState saveState) {
        this.functionComparisonPanel.readConfigState(this.getName(), saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.functionComparisonPanel.writeConfigState(this.getName(), saveState);
    }

    protected void initFunctionComparisonPanel() {
        this.setTransient();
        this.setTabText(this.functionComparisonPanel.getDescription());
        this.addSpecificCodeComparisonActions();
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.setHelpLocation(new HelpLocation(HELP_TOPIC, "Function Comparison"));
    }

    boolean isEmpty() {
        return this.functionComparisonPanel.isEmpty();
    }

    void closeIfEmpty() {
        if (this.isEmpty()) {
            this.closeComponent();
        }
    }

    private void addSpecificCodeComparisonActions() {
        DockingAction[] actions;
        for (DockingAction dockingAction : actions = this.functionComparisonPanel.getCodeComparisonActions()) {
            this.addLocalAction((DockingActionIf)dockingAction);
        }
    }
}

