/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.memory;

import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.memory.MemoryMergePanel;
import ghidra.framework.store.LockException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class MemoryMergeManager
implements MergeResolver {
    private static String[] MEMORY_PHASE = new String[]{"Memory"};
    private static final int RESULT = 0;
    private static final int ORIGINAL = 3;
    private static final int LATEST = 1;
    private static final int MY = 2;
    static final int CANCELED = -2;
    static final int ASK_USER = -1;
    static final int OPTION_LATEST = 0;
    static final int OPTION_MY = 1;
    static final int OPTION_ORIGINAL = 2;
    private Program[] programs = new Program[4];
    private Memory[] mems = new Memory[4];
    private MemoryBlock[] myBlocks;
    private MemoryBlock[] latestBlocks;
    private MemoryBlock[] origBlocks;
    private MemoryBlock[] resultBlocks;
    private ProgramMultiUserMergeManager mergeManager;
    private TaskMonitor currentMonitor;
    private int conflictOption;
    private ArrayList<ConflictInfo> conflictList;
    private int currentConflictIndex;
    private int conflictCount;
    private MemoryMergePanel mergePanel;
    private int progressIndex;
    private int memoryDetailChoice = -1;

    public MemoryMergeManager(ProgramMultiUserMergeManager mergeManager, Program resultProgram, Program myProgram, Program originalProgram, Program latestProgram) {
        this.mergeManager = mergeManager;
        this.programs[0] = resultProgram;
        this.programs[3] = originalProgram;
        this.programs[1] = latestProgram;
        this.programs[2] = myProgram;
        this.mems[0] = resultProgram.getMemory();
        this.mems[3] = originalProgram.getMemory();
        this.mems[1] = latestProgram.getMemory();
        this.mems[2] = myProgram.getMemory();
        this.setupConflicts();
        this.conflictOption = -1;
    }

    @Override
    public String getName() {
        return "Memory Block Merger";
    }

    @Override
    public String getDescription() {
        return "Merge Memory Blocks";
    }

    @Override
    public void apply() {
        this.conflictOption = this.mergePanel.getSelectedOption();
        if (this.mergePanel.getUseForAll()) {
            this.memoryDetailChoice = this.conflictOption;
        }
    }

    @Override
    public void cancel() {
        this.conflictOption = -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) {
        this.mergeManager.setInProgress(MEMORY_PHASE);
        this.currentMonitor = monitor;
        int transactionID = this.programs[0].startTransaction("Merge Memory");
        boolean commit = false;
        try {
            int numBlocks = this.mems[2].getBlocks().length;
            monitor.initialize((long)numBlocks);
            for (int i = 0; i < this.myBlocks.length; ++i) {
                this.mergeManager.updateProgress((int)((float)(100 / numBlocks) * (float)i), "Merging memory block: " + this.myBlocks[i].getName());
                this.processBlockChanges(i);
            }
            this.mergeManager.updateProgress(100, "Merging Memory...");
            this.processConflicts();
            commit = true;
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            this.programs[0].endTransaction(transactionID, commit);
        }
        this.mergeManager.setCompleted(MEMORY_PHASE);
    }

    private void setupConflicts() {
        this.conflictList = new ArrayList();
        this.resultBlocks = this.mems[0].getBlocks();
        this.myBlocks = this.mems[2].getBlocks();
        this.latestBlocks = this.mems[1].getBlocks();
        this.origBlocks = this.mems[3].getBlocks();
        if (this.myBlocks.length != this.latestBlocks.length) {
            throw new AssertException("Memory maps have different sizes!");
        }
        for (int i = 0; i < this.myBlocks.length; ++i) {
            if (this.myBlocks[i].getSize() != this.latestBlocks[i].getSize()) {
                throw new AssertException("Memory blocks have different lengths!");
            }
            if (this.isNameConflict(i)) {
                this.conflictList.add(new ConflictInfo(i, true, false, false));
            }
            if (this.isPermissionConflict(i)) {
                this.conflictList.add(new ConflictInfo(i, false, true, false));
            }
            if (!this.isCommentConflict(i)) continue;
            this.conflictList.add(new ConflictInfo(i, false, false, true));
        }
        this.conflictCount = this.conflictList.size();
    }

    private boolean isNameConflict(int index) {
        String origName;
        String latestName = this.latestBlocks[index].getName();
        String myName = this.myBlocks[index].getName();
        return !myName.equals(origName = this.origBlocks[index].getName()) && !latestName.equals(origName) && !myName.equals(latestName);
    }

    private boolean isPermissionConflict(int index) {
        int origPermissions;
        int latestPermissions = this.latestBlocks[index].getPermissions();
        int myPermissions = this.myBlocks[index].getPermissions();
        return myPermissions != (origPermissions = this.origBlocks[index].getPermissions()) && latestPermissions != origPermissions && myPermissions != latestPermissions;
    }

    private boolean isCommentConflict(int index) {
        String latestComments = this.latestBlocks[index].getComment();
        String myComments = this.myBlocks[index].getComment();
        String origComments = this.origBlocks[index].getComment();
        if (!(myComments == null || myComments.equals(origComments) || latestComments == null || latestComments.equals(origComments) || myComments.equals(latestComments))) {
            return true;
        }
        return myComments == null && origComments != null && latestComments != null && !latestComments.equals(origComments);
    }

    private void processConflicts() throws CancelledException {
        int currentBlockIndex = -1;
        for (ConflictInfo info : this.conflictList) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            if (currentBlockIndex != info.index) {
                this.currentMonitor.setProgress((long)(++this.progressIndex));
            }
            currentBlockIndex = info.index;
            ++this.currentConflictIndex;
            this.handleConflict(info);
            this.conflictOption = -1;
        }
    }

    private String getUniqueBlockName(String name) {
        Object uniqueName = name;
        int cnt = 1;
        while (this.programs[1].getMemory().getBlock((String)uniqueName) != null) {
            uniqueName = name + "_" + cnt;
        }
        return uniqueName;
    }

    private void handleConflict(ConflictInfo info) throws CancelledException {
        Object latestStr = null;
        Object myStr = null;
        Object origStr = null;
        Object title = null;
        String panelID = MemoryMergePanel.CONFLICT_PANEL_ID;
        if (info.nameConflict) {
            title = "Resolve Name Conflict";
            latestStr = "Use Block name '" + this.latestBlocks[info.index].getName() + "'  (Latest)";
            myStr = "Use Block name '" + this.getUniqueBlockName(this.myBlocks[info.index].getName()) + "'  (Checked Out)";
            origStr = "Use Block name '" + this.origBlocks[info.index].getName() + "'  (Original)";
        } else if (info.permissionConflict) {
            title = "Resolve Permissions Conflict";
            latestStr = "Use '" + this.getPermissionString(this.latestBlocks[info.index]) + "'  (Latest)";
            myStr = "Use '" + this.getPermissionString(this.myBlocks[info.index]) + "'  (Checked Out)";
            origStr = "Use '" + this.getPermissionString(this.origBlocks[info.index]) + "'  (Original)";
        } else {
            title = "Resolve Comment Conflict";
            panelID = MemoryMergePanel.COMMENT_PANEL_ID;
            latestStr = this.latestBlocks[info.index].getComment();
            myStr = this.myBlocks[info.index].getComment();
            origStr = this.origBlocks[info.index].getComment();
        }
        if (this.memoryDetailChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            title = (String)title + " (Block index " + info.index + ")";
            this.showMergePanel(panelID, (String)title, (String)latestStr, (String)myStr, (String)origStr);
        }
        int optionToUse = this.memoryDetailChoice == -1 ? this.conflictOption : this.memoryDetailChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                this.updateBlock(info, this.myBlocks[info.index]);
                break;
            }
            case 2: {
                this.updateBlock(info, this.origBlocks[info.index]);
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
    }

    private void updateBlock(ConflictInfo info, MemoryBlock sourceBlock) {
        if (info.nameConflict) {
            try {
                this.resultBlocks[info.index].setName(this.getUniqueBlockName(sourceBlock.getName()));
            }
            catch (LockException e) {
                throw new AssertException();
            }
        } else if (info.permissionConflict) {
            this.resultBlocks[info.index].setRead(sourceBlock.isRead());
            this.resultBlocks[info.index].setWrite(sourceBlock.isWrite());
            this.resultBlocks[info.index].setExecute(sourceBlock.isExecute());
            this.resultBlocks[info.index].setVolatile(sourceBlock.isVolatile());
        } else {
            this.resultBlocks[info.index].setComment(sourceBlock.getComment());
        }
    }

    private void showMergePanel(final String panelID, final String title, final String latestStr, final String myStr, final String origStr) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (MemoryMergeManager.this.mergePanel == null) {
                        MemoryMergeManager.this.mergePanel = new MemoryMergePanel(MemoryMergeManager.this.mergeManager, MemoryMergeManager.this.conflictCount);
                    }
                    MemoryMergeManager.this.mergePanel.setConflictInfo(MemoryMergeManager.this.currentConflictIndex, panelID, title, latestStr, myStr, origStr);
                }
            });
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        this.mergeManager.setApplyEnabled(false);
        this.mergeManager.showComponent(this.mergePanel, "MemoryMerge", new HelpLocation("Repository", "MemoryConflict"));
    }

    private String getPermissionString(MemoryBlock block) {
        StringBuffer sb = new StringBuffer();
        sb.append("Read = ");
        sb.append(block.isExecute());
        sb.append(", ");
        sb.append("Write = ");
        sb.append(block.isWrite());
        sb.append(", ");
        sb.append("Execute = ");
        sb.append(block.isExecute());
        sb.append(", ");
        sb.append("Volatile = ");
        sb.append(block.isVolatile());
        return sb.toString();
    }

    private void processBlockChanges(int index) throws CancelledException {
        String myComment;
        String myName;
        if (this.currentMonitor.isCancelled()) {
            throw new CancelledException();
        }
        boolean progressUpdated = false;
        if (!this.isNameConflict(index) && !(myName = this.myBlocks[index].getName()).equals(this.origBlocks[index].getName())) {
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            progressUpdated = true;
            try {
                this.resultBlocks[index].setName(this.getUniqueBlockName(myName));
            }
            catch (LockException e) {
                throw new AssertException();
            }
        }
        if (!this.isPermissionConflict(index)) {
            boolean permission = this.myBlocks[index].isRead();
            if (permission != this.origBlocks[index].isRead()) {
                this.resultBlocks[index].setRead(permission);
                if (!progressUpdated) {
                    this.currentMonitor.setProgress((long)(++this.progressIndex));
                    progressUpdated = true;
                }
            }
            if ((permission = this.myBlocks[index].isWrite()) != this.origBlocks[index].isWrite()) {
                this.resultBlocks[index].setWrite(permission);
                if (!progressUpdated) {
                    this.currentMonitor.setProgress((long)(++this.progressIndex));
                    progressUpdated = true;
                }
            }
            if ((permission = this.myBlocks[index].isExecute()) != this.origBlocks[index].isExecute()) {
                this.resultBlocks[index].setExecute(permission);
                if (!progressUpdated) {
                    this.currentMonitor.setProgress((long)(++this.progressIndex));
                    progressUpdated = true;
                }
            }
            if ((permission = this.myBlocks[index].isVolatile()) != this.origBlocks[index].isVolatile()) {
                this.resultBlocks[index].setVolatile(permission);
                if (!progressUpdated) {
                    this.currentMonitor.setProgress((long)(++this.progressIndex));
                    progressUpdated = true;
                }
            }
        }
        if (!this.isCommentConflict(index) && ((myComment = this.myBlocks[index].getComment()) != null && !myComment.equals(this.origBlocks[index].getComment()) || myComment == null)) {
            this.resultBlocks[index].setComment(myComment);
            if (!progressUpdated) {
                this.currentMonitor.setProgress((long)(++this.progressIndex));
                progressUpdated = true;
            }
        }
        if (!progressUpdated && !this.hasConflict(index)) {
            this.currentMonitor.setProgress((long)(++this.progressIndex));
        }
    }

    private boolean hasConflict(int index) {
        for (ConflictInfo info : this.conflictList) {
            if (index != info.index) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{MEMORY_PHASE};
    }

    private class ConflictInfo {
        int index;
        boolean permissionConflict;
        boolean nameConflict;
        boolean commentConflict;

        ConflictInfo(int index, boolean nameConflict, boolean permissionConflict, boolean commentConflict) {
            this.index = index;
            this.nameConflict = nameConflict;
            this.permissionConflict = permissionConflict;
            this.commentConflict = commentConflict;
        }
    }
}

