/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.BigRefListV0;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.ReferenceDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import java.io.IOException;

abstract class RefList
extends DatabaseObject {
    static volatile int BIG_REFLIST_THRESHOLD = 1700;
    protected static DataConverter converter = BigEndianDataConverter.INSTANCE;
    protected Address address;
    protected RecordAdapter adapter;
    protected AddressMap addrMap;
    protected ProgramDB program;
    protected boolean isFrom;

    RefList(long key, Address address, RecordAdapter adapter, AddressMap addrMap, ProgramDB program, DBObjectCache<RefList> cache, boolean isFrom) {
        super(cache, key);
        this.address = addrMap.decodeAddress(key);
        this.adapter = adapter;
        this.addrMap = addrMap;
        this.program = program;
        this.isFrom = isFrom;
    }

    abstract void addRef(Address var1, Address var2, RefType var3, int var4, long var5, boolean var7, SourceType var8, boolean var9, boolean var10, long var11) throws IOException;

    abstract void updateRefType(Address var1, int var2, RefType var3) throws IOException;

    abstract ReferenceDB getRef(Address var1, int var2) throws IOException;

    abstract boolean removeRef(Address var1, int var2) throws IOException;

    abstract boolean isEmpty();

    abstract boolean setPrimary(Reference var1, boolean var2) throws IOException;

    abstract ReferenceIterator getRefs() throws IOException;

    abstract Reference[] getAllRefs() throws IOException;

    abstract int getNumRefs();

    abstract Reference getPrimaryRef(int var1) throws IOException;

    abstract void removeAll() throws IOException;

    abstract boolean setSymbolID(Reference var1, long var2) throws IOException;

    abstract boolean hasReference(int var1) throws IOException;

    abstract byte getReferenceLevel();

    public RefList checkRefListSize(DBObjectCache<RefList> cache, int newSpaceRequired) throws IOException {
        if (this.adapter != null && this.getNumRefs() + newSpaceRequired >= BIG_REFLIST_THRESHOLD) {
            cache.delete(this.getKey());
            BigRefListV0 refList = new BigRefListV0(this.address, this.adapter, this.addrMap, this.program, cache, this.isFrom);
            refList.addRefs(this.getRefs());
            return refList;
        }
        return this;
    }
}

