/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.gui.thread.ThreadState;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.database.UndoableTransaction;

public class ThreadRow {
    private final DebuggerModelService service;
    private final TraceThread thread;

    public ThreadRow(DebuggerModelService service, TraceThread thread) {
        this.service = service;
        this.thread = thread;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public Trace getTrace() {
        return this.thread.getTrace();
    }

    public void setName(String name) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.thread.getTrace(), (String)"Renamed thread", (boolean)true);){
            this.thread.setName(name);
        }
    }

    public String getName() {
        return this.thread.getName();
    }

    public long getCreationSnap() {
        return this.thread.getCreationSnap();
    }

    public String getDestructionSnap() {
        long snap = this.thread.getDestructionSnap();
        return snap == Long.MAX_VALUE ? "" : Long.toString(snap);
    }

    public Range<Long> getLifespan() {
        return this.thread.getLifespan();
    }

    public void setComment(String comment) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.thread.getTrace(), (String)"Renamed thread", (boolean)true);){
            this.thread.setComment(comment);
        }
    }

    public String getComment() {
        return this.thread.getComment();
    }

    public ThreadState getState() {
        if (!this.thread.isAlive()) {
            return ThreadState.TERMINATED;
        }
        if (this.service == null) {
            return ThreadState.ALIVE;
        }
        TraceRecorder recorder = this.service.getRecorder(this.thread.getTrace());
        if (recorder == null) {
            return ThreadState.ALIVE;
        }
        TargetExecutionStateful.TargetExecutionState targetState = recorder.getTargetThreadState(this.thread);
        if (targetState == null) {
            return ThreadState.UNKNOWN;
        }
        switch (targetState) {
            case ALIVE: {
                return ThreadState.ALIVE;
            }
            case INACTIVE: {
                return ThreadState.UNKNOWN;
            }
            case RUNNING: {
                return ThreadState.RUNNING;
            }
            case STOPPED: {
                return ThreadState.STOPPED;
            }
            case TERMINATED: {
                return ThreadState.TERMINATED;
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return this.getName();
    }
}

