/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.AttributedString;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;

public class CompositeAttributedString
extends AttributedString {
    private String fullText;
    protected AttributedString[] attributedStrings;
    private int heightAbove = -1;
    private int heightBelow = -1;

    public CompositeAttributedString(List<AttributedString> stringList) {
        this(stringList.toArray(new AttributedString[stringList.size()]));
    }

    public CompositeAttributedString(AttributedString ... attributedStrings) {
        this.attributedStrings = attributedStrings;
    }

    private IndexedOffset getIndexedOffsetForCharPosition(int charPosition) {
        int n = 0;
        for (int i = 0; i < this.attributedStrings.length; ++i) {
            int len = this.attributedStrings[i].getText().length();
            if (charPosition < n + len) {
                return new IndexedOffset(i, charPosition - n);
            }
            n += len;
        }
        return new IndexedOffset(this.attributedStrings.length - 1, this.attributedStrings[this.attributedStrings.length - 1].getText().length());
    }

    @Override
    public int getCharPosition(int x) {
        int remainingWidth = x;
        int totalCharacters = 0;
        for (AttributedString attributedString : this.attributedStrings) {
            int nextWidth = attributedString.getStringWidth();
            if (nextWidth >= remainingWidth) {
                totalCharacters += attributedString.getCharPosition(remainingWidth);
                break;
            }
            remainingWidth -= nextWidth;
            totalCharacters += attributedString.length();
        }
        return totalCharacters;
    }

    @Override
    public Color getColor(int index) {
        IndexedOffset pos = this.getIndexedOffsetForCharPosition(index);
        return this.attributedStrings[pos.index].getColor(pos.offset);
    }

    @Override
    public FontMetrics getFontMetrics(int charIndex) {
        IndexedOffset pos = this.getIndexedOffsetForCharPosition(charIndex);
        return this.attributedStrings[pos.index].getFontMetrics(pos.offset);
    }

    @Override
    public int getHeightAbove() {
        if (this.heightAbove < 0) {
            this.heightAbove = 0;
            for (AttributedString attributedString : this.attributedStrings) {
                this.heightAbove = Math.max(this.heightAbove, attributedString.getHeightAbove());
            }
        }
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        if (this.heightBelow < 0) {
            this.heightBelow = 0;
            for (AttributedString attributedString : this.attributedStrings) {
                this.heightBelow = Math.max(this.heightBelow, attributedString.getHeightBelow());
            }
        }
        return this.heightBelow;
    }

    @Override
    public int getStringWidth() {
        if (this.textWidth == -1) {
            this.textWidth = 0;
            for (AttributedString attributedString : this.attributedStrings) {
                this.textWidth += attributedString.getStringWidth();
            }
        }
        return this.textWidth;
    }

    @Override
    public String getText() {
        if (this.fullText == null) {
            StringBuffer buffer = new StringBuffer();
            for (AttributedString attributedString : this.attributedStrings) {
                buffer.append(attributedString.getText());
            }
            this.fullText = buffer.toString();
        }
        return this.fullText;
    }

    @Override
    public void paint(JComponent c, Graphics g, int x, int y) {
        int xPos = x;
        for (AttributedString attributedString : this.attributedStrings) {
            attributedString.paint(c, g, xPos, y);
            xPos += attributedString.getStringWidth();
        }
    }

    @Override
    public AttributedString replaceAll(char[] targets, char repacement) {
        AttributedString[] newStrings = new AttributedString[this.attributedStrings.length];
        for (int i = 0; i < this.attributedStrings.length; ++i) {
            newStrings[i] = this.attributedStrings[i].replaceAll(targets, repacement);
        }
        return new CompositeAttributedString(newStrings);
    }

    @Override
    public AttributedString substring(int start) {
        return this.substring(start, this.getText().length());
    }

    @Override
    public AttributedString substring(int start, int end) {
        IndexedOffset startPos = this.getIndexedOffsetForCharPosition(start);
        IndexedOffset endPos = this.getIndexedOffsetForCharPosition(end);
        if (startPos.index == endPos.index) {
            AttributedString asStart = this.attributedStrings[startPos.index];
            return asStart.substring(startPos.offset, endPos.offset);
        }
        AttributedString asStart = this.attributedStrings[startPos.index];
        AttributedString newStart = asStart.substring(startPos.offset);
        AttributedString asEnd = this.attributedStrings[endPos.index];
        AttributedString newEnd = asEnd.substring(0, endPos.offset);
        AttributedString[] newStrings = new AttributedString[endPos.index - startPos.index + 1];
        System.arraycopy(this.attributedStrings, startPos.index + 1, newStrings, 1, newStrings.length - 1);
        newStrings[0] = newStart;
        newStrings[newStrings.length - 1] = newEnd;
        return new CompositeAttributedString(newStrings);
    }

    private static class IndexedOffset {
        int index;
        int offset;

        IndexedOffset(int index, int offset) {
            this.index = index;
            this.offset = offset;
        }
    }
}

