/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableRowMapper;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.table.MappedProgramLocationTableColumn;
import ghidra.util.table.ProgramLocationTableRowMapper;
import ghidra.util.table.ProgramMappedTableColumn;
import ghidra.util.table.field.ProgramLocationTableColumn;

public class VTMarkupItemDestinationAddressToAddressTableRowMapper
extends ProgramLocationTableRowMapper<VTMarkupItem, Address> {
    public <COLUMN_TYPE> DynamicTableColumn<VTMarkupItem, COLUMN_TYPE, Program> createMappedTableColumn(DynamicTableColumn<Address, COLUMN_TYPE, Program> destinationColumn) {
        if (destinationColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programColumn = (ProgramLocationTableColumn)destinationColumn;
            return new VTMarkupItemDestinationWrappedMappedProgramLocationTableColumn(this, programColumn);
        }
        return new VTMarkupItemDestinationWrappedMappedTableColumn<COLUMN_TYPE>((TableRowMapper<VTMarkupItem, Address, Program>)this, destinationColumn);
    }

    public Address map(VTMarkupItem rowObject, Program program, ServiceProvider serviceProvider) {
        return rowObject.getDestinationAddress();
    }

    private class VTMarkupItemDestinationWrappedMappedTableColumn<COLUMN_TYPE>
    extends ProgramMappedTableColumn<VTMarkupItem, Address, COLUMN_TYPE> {
        public VTMarkupItemDestinationWrappedMappedTableColumn(TableRowMapper<VTMarkupItem, Address, Program> mapper, DynamicTableColumn<Address, COLUMN_TYPE, Program> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemDestination." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Dest " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's destination address)";
        }

        public String getColumnName() {
            return "Dest " + super.getColumnName();
        }
    }

    private class VTMarkupItemDestinationWrappedMappedProgramLocationTableColumn<COLUMN_TYPE>
    extends MappedProgramLocationTableColumn<VTMarkupItem, Address, COLUMN_TYPE> {
        public VTMarkupItemDestinationWrappedMappedProgramLocationTableColumn(ProgramLocationTableRowMapper<VTMarkupItem, Address> mapper, ProgramLocationTableColumn<Address, COLUMN_TYPE> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemDestination." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Dest " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's destination address)";
        }

        public String getColumnName() {
            return "Dest " + super.getColumnName();
        }
    }
}

