/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.util.AddressCorrelation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class UnapplyMarkupItemTask
extends VtTask {
    protected final List<VTMarkupItem> markupItems;
    private final AddressCorrelation correlation;

    public UnapplyMarkupItemTask(VTSession session, AddressCorrelation correlation, List<VTMarkupItem> markupItems) {
        super("Reset Markup Items", session);
        this.correlation = correlation;
        this.markupItems = markupItems;
        if (!(session instanceof VTSessionDB)) {
            throw new IllegalArgumentException("Unexpected condition - VTSession is not a DB object!");
        }
    }

    @Override
    protected boolean shouldSuspendSessionEvents() {
        return this.markupItems.size() > 20;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        monitor.initialize((long)this.markupItems.size());
        for (VTMarkupItem markupItem : this.markupItems) {
            monitor.checkCanceled();
            try {
                this.maybeUnapply(markupItem);
                this.maybeClearStatus(markupItem);
                this.maybeResetDestinationAddressToDefault(markupItem, monitor);
            }
            catch (VersionTrackingApplyException e) {
                this.reportError(e);
            }
            monitor.incrementProgress(1L);
        }
        return true;
    }

    private void maybeUnapply(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        if (markupItem.canUnapply()) {
            markupItem.unapply();
        }
    }

    private void maybeClearStatus(VTMarkupItem markupItem) {
        VTMarkupItemStatus status = markupItem.getStatus();
        if (!status.isDefault() && !status.isUnappliable()) {
            markupItem.setConsidered(VTMarkupItemConsideredStatus.UNCONSIDERED);
        }
    }

    private void maybeResetDestinationAddressToDefault(VTMarkupItem markupItem, TaskMonitor monitor) throws CancelledException {
        AddressRange range;
        Address destinationAddress = null;
        String source = null;
        if (this.correlation != null && (range = this.correlation.getCorrelatedDestinationRange(markupItem.getSourceAddress(), monitor)) != null) {
            destinationAddress = range.getMinAddress();
            source = this.correlation.getName();
        }
        markupItem.setDefaultDestinationAddress(destinationAddress, source);
    }
}

