/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class DirUsage
implements Serializable {
    private static final long serialVersionUID = 9250L;
    long total = 0L;
    long files = 0L;
    long subdirs = 0L;
    long symlinks = 0L;
    long chrdevs = 0L;
    long blkdevs = 0L;
    long sockets = 0L;
    long diskUsage = 0L;

    public native void gather(Sigar var1, String var2) throws SigarException;

    static DirUsage fetch(Sigar sigar, String name) throws SigarException {
        DirUsage dirUsage = new DirUsage();
        dirUsage.gather(sigar, name);
        return dirUsage;
    }

    public long getTotal() {
        return this.total;
    }

    public long getFiles() {
        return this.files;
    }

    public long getSubdirs() {
        return this.subdirs;
    }

    public long getSymlinks() {
        return this.symlinks;
    }

    public long getChrdevs() {
        return this.chrdevs;
    }

    public long getBlkdevs() {
        return this.blkdevs;
    }

    public long getSockets() {
        return this.sockets;
    }

    public long getDiskUsage() {
        return this.diskUsage;
    }

    void copyTo(DirUsage copy) {
        copy.total = this.total;
        copy.files = this.files;
        copy.subdirs = this.subdirs;
        copy.symlinks = this.symlinks;
        copy.chrdevs = this.chrdevs;
        copy.blkdevs = this.blkdevs;
        copy.sockets = this.sockets;
        copy.diskUsage = this.diskUsage;
    }

    public Map toMap() {
        String strdiskUsage;
        String strsockets;
        String strblkdevs;
        String strchrdevs;
        String strsymlinks;
        String strsubdirs;
        String strfiles;
        HashMap<String, String> map = new HashMap<String, String>();
        String strtotal = String.valueOf(this.total);
        if (!"-1".equals(strtotal)) {
            map.put("Total", strtotal);
        }
        if (!"-1".equals(strfiles = String.valueOf(this.files))) {
            map.put("Files", strfiles);
        }
        if (!"-1".equals(strsubdirs = String.valueOf(this.subdirs))) {
            map.put("Subdirs", strsubdirs);
        }
        if (!"-1".equals(strsymlinks = String.valueOf(this.symlinks))) {
            map.put("Symlinks", strsymlinks);
        }
        if (!"-1".equals(strchrdevs = String.valueOf(this.chrdevs))) {
            map.put("Chrdevs", strchrdevs);
        }
        if (!"-1".equals(strblkdevs = String.valueOf(this.blkdevs))) {
            map.put("Blkdevs", strblkdevs);
        }
        if (!"-1".equals(strsockets = String.valueOf(this.sockets))) {
            map.put("Sockets", strsockets);
        }
        if (!"-1".equals(strdiskUsage = String.valueOf(this.diskUsage))) {
            map.put("DiskUsage", strdiskUsage);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

