/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sequence.editor;

import com.informagen.sequence.editor.Model;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

class View
extends JComponent
implements MouseMotionListener,
AdjustmentListener,
ClipboardOwner,
KeyListener {
    public final int NOACTION = 0;
    private final int EDGE = 10;
    private JScrollBar mScrollbar;
    private Model model;
    private Font defaultFont;
    private boolean dirty;
    private boolean mouseDown;
    private boolean editable = false;
    private int sy;
    private int ny;
    private int line;
    private int column;
    private int pix;
    private int clickedLine;
    private int clickedColumn;
    private int clickedHorizontalPixel;
    private boolean rangeClicked;
    private boolean hiliteActive;
    private int widest;
    private int wpix;
    private int oldlines;
    private Font font;
    private FontMetrics fontMetrics;
    private int fontHeight;
    private int fontDescent;
    private int mShortcutKey;
    private CursorThread cursorThread;
    private Dimension dimension;
    private Vector lines = new Vector();
    private int mNumLines;
    private int thePosition;
    private int theWidth;
    private int nearest;
    private ScrollerThread scrollerThread = null;
    private boolean gotFocus = false;
    private Clipboard mClipboard = null;
    View This = this;
    private int oldPixel;
    private int oldEndPixel;
    private int oldLine;
    private int oldEndLine;
    private int oldColumn;
    private int oldEndColumn;
    private int hiliteStartPixel;
    private int hiliteStartLine;
    private int hiliteStartColumn;
    private int hiliteEndPixel;
    private int hiliteEndLine;
    private int hiliteEndColumn;
    private int lastx;
    private int lasty;
    private final int myMask = 14;

    public View(JScrollBar jScrollBar, Model model) {
        this.mScrollbar = jScrollBar;
        this.mScrollbar.addAdjustmentListener(this);
        this.mScrollbar.addKeyListener(this);
        this.mNumLines = 0;
        this.model = model;
        this.thePosition = 0;
        this.theWidth = 50;
        this.nearest = 10;
        this.addKeyListener(this);
        this.clear();
        this.requestFocus();
        this.validate();
        this.cursorThread = new CursorThread();
        this.cursorThread.start();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                View.this.doMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                View.this.doMouseReleased(mouseEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                View.this.redoControls(View.this.mScrollbar.getValue(), true);
                View.this.calculateWidth();
                View.this.shuffle(0);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                View.this.gotFocus = true;
                View.this.resumeCursor();
            }

            public void focusLost(FocusEvent focusEvent) {
                View.this.suspendCursor();
                View.this.gotFocus = false;
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.font = this.defaultFont = new Font("Monospaced", 0, 12);
        this.fontMetrics = this.getFontMetrics(this.font);
        this.mShortcutKey = this.getToolkit().getMenuShortcutKeyMask();
    }

    public Dimension getMinimumSize() {
        int n = this.fontMetrics.charWidth('m') * 20 + 2;
        return new Dimension(n + 16, this.fontMetrics.getHeight() * 6 + 2);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = this.getFontMetrics(this.font);
        super.setFont(font);
    }

    void setEditable(boolean bl) {
        this.editable = bl;
        if (this.editable) {
            this.resumeCursor();
        } else {
            this.suspendCursor();
        }
    }

    boolean getEditable() {
        return true;
    }

    private void suspendCursor() {
        if (this.cursorThread != null && !this.rangeClicked && this.gotFocus) {
            this.cursorThread.pause_cursor(true);
        }
    }

    private void resumeCursor() {
        if (this.cursorThread != null && !this.rangeClicked && this.gotFocus) {
            this.cursorThread.resume_cursor(true);
        }
    }

    void clear() {
        this.clearCanvas(null);
        this.dirty = false;
        this.rangeClicked = false;
        this.hiliteActive = false;
        this.sy = 0;
        this.column = 0;
        this.line = 0;
        this.widest = 0;
        this.wpix = 0;
        this.oldlines = 0;
        this.pix = 10;
        this.mScrollbar.setValue(0);
        this.lines.removeAllElements();
        this.model.clear();
    }

    void setFontSize(int n) {
        this.font = new Font("monospaced", 0, n);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.clearCanvas(graphics);
            this.updateFonts(graphics);
            this.resizeLines();
            this.redoCanvas();
            this.repaint();
            graphics.dispose();
        } else {
            this.fontMetrics = null;
        }
    }

    public void calculateWidth() {
        int n = this.dimension.width;
        this.theWidth = (n - 10 - this.stringLength(" 99999")) / this.stringLength("m");
        this.theWidth = this.theWidth / this.nearest * this.nearest;
        this.theWidth = this.theWidth <= 10 ? 10 : this.theWidth;
        char[] cArray = new char[this.theWidth];
        for (int i = 0; i < this.theWidth; ++i) {
            cArray[i] = 109;
        }
        this.wpix = 10 + this.stringLength(new String(cArray));
    }

    private void clearCanvas(Graphics graphics) {
        boolean bl = false;
        this.suspendCursor();
        if (this.dimension == null) {
            return;
        }
        if (graphics == null) {
            graphics = this.getGraphics();
            bl = true;
        }
        if (graphics != null) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.dimension.width, this.dimension.height);
        }
        if (bl && graphics != null) {
            graphics.dispose();
        }
    }

    public void undo(boolean bl) {
    }

    public void updateUndoItems(boolean bl, boolean bl2) {
    }

    private void updateFonts(Graphics graphics) {
        boolean bl = false;
        if (graphics == null) {
            graphics = this.getGraphics();
            bl = true;
        }
        if (graphics != null) {
            graphics.setFont(this.font);
            this.fontMetrics = graphics.getFontMetrics(this.font);
            this.fontHeight = this.fontMetrics.getHeight();
            this.fontDescent = this.fontMetrics.getDescent();
            if (bl) {
                graphics.dispose();
            }
        }
    }

    public synchronized void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            rectangle.grow(-1, -1);
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.updateFonts(graphics);
        if (mouseEvent != null) {
            this.lastx = mouseEvent.getX();
            this.lasty = mouseEvent.getY();
        }
        this.clickPosition(this.lastx, this.lasty);
        boolean bl = this.rangeClicked = this.clickedLine != this.line || this.clickedColumn != this.column;
        if (this.rangeClicked || this.hiliteActive) {
            if (this.clickedLine < this.sy || this.clickedLine >= this.sy + this.ny) {
                if (this.scrollerThread == null) {
                    this.scrollerThread = new ScrollerThread(this);
                    this.scrollerThread.start();
                }
                this.shiftVert(this.clickedLine);
                this.newHilite();
                this.rememberHilite();
                for (int i = 0; i < this.ny; ++i) {
                    this.drawLine(graphics, this.sy + i);
                }
            } else {
                this.newHilite();
                if (this.scrollerThread != null) {
                    this.scrollerThread.interrupt();
                    this.scrollerThread = null;
                }
                if (this.hiliteActive) {
                    if (this.hiliteStartLine < this.oldLine || this.hiliteStartLine == this.oldLine && this.hiliteStartPixel < this.oldPixel) {
                        this.redrawLines(graphics, this.hiliteStartLine, this.oldLine);
                    }
                    if (this.hiliteStartLine > this.oldLine || this.hiliteStartLine == this.oldLine && this.hiliteStartPixel > this.oldPixel) {
                        this.redrawLines(graphics, this.oldLine, this.hiliteStartLine);
                    }
                    if (this.hiliteEndLine < this.oldEndLine || this.hiliteEndLine == this.oldEndLine && this.hiliteEndPixel < this.oldEndPixel) {
                        this.redrawLines(graphics, this.hiliteEndLine, this.oldEndLine);
                    }
                    if (this.hiliteEndLine > this.oldEndLine || this.hiliteEndLine == this.oldEndLine && this.hiliteEndPixel > this.oldEndPixel) {
                        this.redrawLines(graphics, this.oldEndLine, this.hiliteEndLine);
                    }
                } else {
                    this.hiliteActive = this.rangeClicked;
                    this.redrawLines(graphics, this.hiliteStartLine, this.hiliteEndLine);
                }
                this.rememberHilite();
            }
        }
        graphics.dispose();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    void clickPosition(int n, int n2) {
        this.clickedLine = n2 / this.fontHeight + this.sy;
        if (this.clickedLine < 0 || this.lines.size() == 0) {
            this.clickedColumn = 0;
            this.clickedLine = 0;
            this.clickedHorizontalPixel = 10;
            return;
        }
        if (this.clickedLine >= this.lines.size()) {
            this.clickedLine = this.lines.size() - 1;
            String string = (String)this.lines.elementAt(this.clickedLine);
            this.clickedColumn = string.length();
            this.clickedHorizontalPixel = this.stringLength(string) + 10;
            return;
        }
        this.clickedColumn = 0;
        this.clickedHorizontalPixel = 10;
        if (n > 10) {
            String string = (String)this.lines.elementAt(this.clickedLine);
            this.clickedColumn = string.length();
            if (this.clickedColumn > 0 && n < (this.clickedHorizontalPixel = this.stringLength(string) + 10)) {
                if (this.clickedColumn > 10) {
                    String string2;
                    int n3 = this.clickedColumn / 5;
                    do {
                        this.clickedColumn -= n3;
                        if (this.clickedColumn < 0) {
                            this.clickedColumn = 0;
                            string2 = null;
                            continue;
                        }
                        string2 = string.substring(0, this.clickedColumn);
                    } while (this.clickedColumn >= 0 && n <= (this.clickedHorizontalPixel = this.stringLength(string2) + 10));
                    this.clickedColumn += n3;
                }
                while (this.clickedColumn >= 0 && n <= (this.clickedHorizontalPixel = this.stringLength(string) + 10)) {
                    string = string.substring(0, --this.clickedColumn);
                }
            }
        }
    }

    private void redrawLines(Graphics graphics, int n, int n2) {
        this.mNumLines = this.lines.size();
        for (int i = n; i <= n2; ++i) {
            this.drawLine(graphics, i);
        }
    }

    private void newHilite() {
        if (this.line < this.clickedLine || this.line == this.clickedLine && this.column <= this.clickedColumn) {
            this.hiliteStartLine = this.line;
            this.hiliteStartColumn = this.column;
            this.hiliteStartPixel = this.pix;
            this.hiliteEndLine = this.clickedLine;
            this.hiliteEndColumn = this.clickedColumn;
            this.hiliteEndPixel = this.clickedHorizontalPixel;
        } else {
            this.hiliteStartLine = this.clickedLine;
            this.hiliteStartColumn = this.clickedColumn;
            this.hiliteStartPixel = this.clickedHorizontalPixel;
            this.hiliteEndLine = this.line;
            this.hiliteEndColumn = this.column;
            this.hiliteEndPixel = this.pix;
        }
        this.model.setSelection(this.hiliteStartLine * this.theWidth + this.hiliteStartColumn, this.hiliteEndLine * this.theWidth + this.hiliteEndColumn);
    }

    private void rememberHilite() {
        this.oldLine = this.hiliteStartLine;
        this.oldColumn = this.hiliteStartColumn;
        this.oldPixel = this.hiliteStartPixel;
        this.oldEndLine = this.hiliteEndLine;
        this.oldEndColumn = this.hiliteEndColumn;
        this.oldEndPixel = this.hiliteEndPixel;
    }

    public void select(int n, int n2) {
        n = n < 0 ? 0 : n;
        n2 = n2 > this.model.getLength() ? this.model.getLength() : n2;
        this.line = n / this.theWidth;
        this.column = n % this.theWidth;
        this.pix = this.pix_at(this.line, this.column);
        this.clickedLine = n2 / this.theWidth;
        this.clickedColumn = n2 % this.theWidth;
        this.clickedHorizontalPixel = this.pix_at(this.clickedLine, this.clickedColumn);
        this.hiliteActive = true;
        this.newHilite();
        this.repaint();
    }

    public synchronized void doMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.mouseDown) {
            return;
        }
        this.mouseDown = true;
        this.suspendCursor();
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            rectangle.grow(-1, -1);
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.updateFonts(graphics);
        this.clickPosition(mouseEvent.getX(), mouseEvent.getY());
        if (this.clickedLine < 0 || this.clickedLine >= this.lines.size()) {
            return;
        }
        int n = mouseEvent.getClickCount();
        if (n == 3) {
            this.line = this.clickedLine;
            this.column = 0;
            this.pix = 10;
            String string = (String)this.lines.elementAt(this.clickedLine);
            this.clickedColumn = string.length();
            this.clickedHorizontalPixel = this.stringLength(string) + 10;
            this.rangeClicked = true;
            this.newHilite();
            this.rememberHilite();
            this.repaint();
        } else if (n == 2) {
            this.clickedLine = this.line = this.clickedLine;
            this.clickedColumn = this.column = this.clickedColumn;
            String string = (String)this.lines.elementAt(this.clickedLine);
            while (this.column != 0 && Character.isLetterOrDigit(string.charAt(this.column - 1))) {
                --this.column;
            }
            this.pix = this.stringLength(string.substring(0, this.column)) + 10;
            int n2 = string.length();
            while (this.clickedColumn < n2 && Character.isLetterOrDigit(string.charAt(this.clickedColumn))) {
                ++this.clickedColumn;
            }
            this.clickedHorizontalPixel = this.stringLength(string.substring(0, this.clickedColumn)) + 10;
            this.rangeClicked = true;
            this.newHilite();
            this.rememberHilite();
            this.repaint();
        } else if (mouseEvent.isShiftDown()) {
            boolean bl = this.rangeClicked = this.clickedLine != this.line || this.clickedColumn != this.column;
            if (this.rangeClicked) {
                this.newHilite();
                this.rememberHilite();
                this.hiliteActive = this.rangeClicked;
                this.repaint();
            }
            this.addMouseMotionListener(this);
        } else {
            this.rangeClicked = false;
            if (this.hiliteActive) {
                this.hiliteActive = false;
                this.redrawLines(graphics, this.hiliteStartLine, this.hiliteEndLine);
            }
            this.line = this.clickedLine;
            this.column = this.clickedColumn;
            this.pix = this.clickedHorizontalPixel;
            this.model.setPosition(this.line * this.theWidth + this.column);
            this.addMouseMotionListener(this);
        }
        graphics.dispose();
    }

    public synchronized void doMouseReleased(MouseEvent mouseEvent) {
        if (!this.mouseDown) {
            return;
        }
        this.mouseDown = false;
        if (this.scrollerThread != null) {
            this.scrollerThread.interrupt();
            this.scrollerThread = null;
        }
        this.removeMouseMotionListener(this);
        this.rangeClicked = this.clickedLine != this.line || this.clickedColumn != this.column;
        this.resumeCursor();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!this.gotFocus) {
            return;
        }
        if (!this.editable) {
            return;
        }
        if ((keyEvent.getModifiers() & this.mShortcutKey) != 0) {
            switch (n) {
                case 67: {
                    this.copy();
                    break;
                }
                case 88: {
                    this.cut();
                    break;
                }
                case 86: {
                    this.paste();
                }
            }
        }
        if ((keyEvent.getModifiers() & 0xE) != 0) {
            return;
        }
        if (n == 38 && this.line == 0) {
            return;
        }
        if (n == 40 && this.line == this.mNumLines - 1) {
            return;
        }
        this.suspendCursor();
        switch (n) {
            case 38: {
                int n2 = this.model.getPosition();
                this.model.setPosition(n2 -= this.theWidth);
                this.placeCursor();
                this.cursorAdjust();
                break;
            }
            case 40: {
                int n3 = this.model.getPosition();
                this.model.setPosition(n3 += this.theWidth);
                this.placeCursor();
                this.cursorAdjust();
                break;
            }
            case 39: {
                int n4 = this.model.getPosition();
                this.model.setPosition(++n4);
                this.placeCursor();
                this.cursorAdjust();
                break;
            }
            case 37: {
                int n5 = this.model.getPosition();
                this.model.setPosition(--n5);
                this.placeCursor();
                this.cursorAdjust();
                return;
            }
            default: {
                char c = keyEvent.getKeyChar();
                if (c == '\uffff') break;
                if (n == 8) {
                    if (this.hiliteActive) {
                        this.cut();
                    } else {
                        this.model.delete_prev_char();
                    }
                    this.shuffle(this.line);
                    break;
                }
                if (n == 127) {
                    this.model.delete_next_char();
                    this.shuffle(this.line);
                    this.placeCursor();
                    break;
                }
                if (!this.model.isValid(c)) break;
                if (this.hiliteActive) {
                    this.cut();
                }
                this.model.insert(c);
                this.shuffle(this.line);
            }
        }
        this.resumeCursor();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    void placeCursor() {
        int n = this.model.getPosition();
        this.line = n / this.theWidth;
        this.column = n % this.theWidth;
        this.pix = this.pix_at(this.line, this.column);
        if (this.shiftVert(this.line)) {
            this.repaint();
        }
    }

    void shuffle(int n) {
        int n2;
        int n3;
        if (n == 0) {
            this.lines.removeAllElements();
        } else {
            for (n3 = this.mNumLines - 1; n3 >= n; --n3) {
                this.lines.removeElementAt(n3);
            }
        }
        n3 = n;
        int n4 = this.model.getLength();
        for (int i = n3 * this.theWidth; i < n4; i += n2) {
            n2 = i + this.theWidth < n4 ? this.theWidth : n4 - i;
            this.lines.insertElementAt(new String(this.model.getChars(i, n2)), n3++);
        }
        this.mNumLines = this.lines.size();
        this.placeCursor();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null) {
                rectangle.grow(-1, -1);
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.updateFonts(graphics);
            this.redrawLines(graphics, n, this.mNumLines);
            graphics.dispose();
        }
    }

    int pix_at(int n, int n2) {
        int n3 = 10;
        if (n2 > 0 && n < this.lines.size()) {
            String string = (String)this.lines.elementAt(n);
            n3 = this.stringLength(string.substring(0, n2)) + 10;
        }
        return n3;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    void toClipboard(String string) {
        if (string == null) {
            return;
        }
        this.mClipboard = this.getToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        this.mClipboard.setContents(stringSelection, this);
    }

    public String fromClipboard() {
        this.mClipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = this.mClipboard.getContents(this);
        String string = null;
        if (transferable != null) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return string;
    }

    void cut() {
        if (!this.hiliteActive) {
            return;
        }
        this.copy();
        this.rangeClicked = false;
        this.hiliteActive = false;
        this.model.deleteSelection();
        this.shuffle(this.line);
        this.shiftVert(this.line);
        this.resumeCursor();
    }

    String copy() {
        if (!this.hiliteActive) {
            return null;
        }
        String string = this.model.getSelection();
        this.toClipboard(string);
        return string;
    }

    void paste() {
        this.suspendCursor();
        String string = this.fromClipboard();
        if (string != null) {
            this.model.insert(string);
            this.shuffle(this.line);
            this.placeCursor();
        }
        this.resumeCursor();
    }

    private void cursorAdjust() {
        int n;
        boolean bl = false;
        if (this.hiliteActive) {
            bl = true;
            this.rangeClicked = false;
            this.hiliteActive = false;
        }
        if (this.line < 0) {
            this.line = 0;
        } else {
            n = this.lines.size();
            if (this.line >= n) {
                this.line = n - 1;
            }
        }
        if (this.column < 0) {
            this.column = 0;
        } else {
            n = ((String)this.lines.elementAt(this.line)).length();
            if (this.column > n) {
                this.column = n;
            }
        }
        if (this.shiftVert(this.line)) {
            bl = true;
        }
        if (bl) {
            this.repaint();
        } else {
            this.resumeCursor();
        }
    }

    private boolean shiftVert(int n) {
        if (n < this.sy) {
            this.sy = n;
            if (this.sy < 0) {
                this.sy = 0;
            }
            this.mScrollbar.setValue(this.sy);
            return true;
        }
        if (n >= this.sy + this.ny) {
            this.sy = n - this.ny + 1;
            this.mScrollbar.setValue(this.sy);
            return true;
        }
        return false;
    }

    private void redoLine(int n, int n2) {
        String string = (String)this.lines.elementAt(n);
        this.dirty = true;
        this.updateFonts(null);
        int n3 = this.fontHeight;
        int n4 = (n - this.sy) * n3;
        String string2 = string.substring(0, n2 - 1);
        int n5 = this.stringLength(string2) + 10;
        int n6 = this.dimension.width - (n5 -= 10);
        this.repaint(10L, n5, n4, n6, n3);
    }

    void redoCanvas() {
        this.shuffle(0);
        this.redoControls(this.mScrollbar.getValue(), false);
    }

    private void redoControls(int n, boolean bl) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.updateFonts(graphics);
        if (graphics != null) {
            int n2;
            int n3;
            int n4;
            this.dimension = this.getSize();
            if (bl) {
                this.clearCanvas(graphics);
            }
            if ((n4 = this.dimension.width) > (n3 = this.wpix)) {
                n3 = n4;
            }
            if (n3 > 0) {
                n3 += 12;
            }
            if ((n2 = this.lines.size()) <= 0) {
                n2 = 10;
            }
            if ((n4 = (this.ny = this.dimension.height / this.fontHeight)) > n2) {
                n4 = n2;
            }
            if (n > n2) {
                n = n2;
            }
            this.mScrollbar.setValues(n, n4, 0, n2);
            this.repaint();
            graphics.dispose();
        }
    }

    private void appendLine(String string) {
        this.model.insert(string);
        this.shuffle(this.line);
    }

    private void resizeLines() {
        int n;
        if (this.widest < this.lines.size() && (n = this.stringLength((String)this.lines.elementAt(this.widest))) > this.wpix) {
            this.wpix = n;
            this.redoControls(this.mScrollbar.getValue(), false);
        }
        if (this.hiliteStartLine >= 0 && this.hiliteStartLine < this.lines.size()) {
            this.oldPixel = this.hiliteStartPixel = this.pix_at(this.hiliteStartLine, this.hiliteStartColumn);
        }
        if (this.hiliteEndLine >= 0 && this.hiliteEndLine < this.lines.size()) {
            this.oldEndPixel = this.hiliteEndPixel = this.pix_at(this.hiliteEndLine, this.hiliteEndColumn);
        }
    }

    private int stringLength(String string) {
        if (this.fontMetrics == null) {
            return -1;
        }
        return this.fontMetrics.stringWidth(string);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void getCursorPos(Graphics graphics, Rectangle rectangle) {
        this.updateFonts(graphics);
        rectangle.width = 2;
        rectangle.height = this.fontHeight;
        rectangle.y = (this.line - this.sy) * rectangle.height;
        if (this.column > 0) {
            String string = ((String)this.lines.elementAt(this.line)).substring(0, this.column);
            rectangle.x = this.stringLength(string) + 10;
        } else {
            rectangle.x = 10;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.suspendCursor();
        if (adjustmentEvent.getSource() == this.mScrollbar) {
            this.sy = adjustmentEvent.getValue();
            this.mScrollbar.setValue(this.sy);
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.mNumLines = this.lines.size();
        Rectangle rectangle = new Rectangle();
        this.suspendCursor();
        graphics.setPaintMode();
        this.updateFonts(graphics);
        int n = this.mNumLines;
        if (this.oldlines != n) {
            this.oldlines = n;
            this.redoControls(this.mScrollbar.getValue(), true);
        }
        if (this.dimension == null) {
            this.dimension = this.getSize();
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        n = rectangle2.y / this.fontHeight;
        if (rectangle2.height / this.fontHeight == 1) {
            this.drawLine(graphics, this.sy + n);
        } else {
            for (n = 0; n < this.ny; ++n) {
                this.drawLine(graphics, this.sy + n);
            }
        }
        this.resumeCursor();
    }

    private synchronized void drawLine(Graphics graphics, int n) {
        int n2;
        if (graphics == null || this.dimension == null) {
            return;
        }
        int n3 = (n - this.sy + 1) * this.fontHeight;
        graphics.setPaintMode();
        graphics.setColor(Color.white);
        graphics.fillRect(0, n3 - this.fontHeight, this.dimension.width, this.fontHeight);
        if (n >= this.mNumLines) {
            return;
        }
        String string = (String)this.lines.elementAt(n);
        graphics.setColor(SystemColor.textText);
        graphics.drawString(string, 10, n3 - this.fontDescent);
        if (this.hiliteActive) {
            n2 = this.stringLength(string);
            if (n > this.hiliteStartLine && n < this.hiliteEndLine) {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(10, n3 - this.fontHeight, this.wpix - 10, this.fontHeight);
                graphics.setColor(SystemColor.textHighlightText);
                graphics.drawString(string, 10, n3 - this.fontDescent);
            } else if (n == this.hiliteStartLine && n == this.hiliteEndLine) {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(this.hiliteStartPixel, n3 - this.fontHeight, this.hiliteEndPixel - this.hiliteStartPixel, this.fontHeight);
                graphics.setColor(SystemColor.textHighlightText);
                String string2 = string.substring(this.hiliteStartColumn, this.hiliteEndColumn);
                graphics.drawString(string2, this.hiliteStartPixel, n3 - this.fontDescent);
            } else if (n == this.hiliteEndLine) {
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(10, n3 - this.fontHeight, this.hiliteEndPixel - 10, this.fontHeight);
                graphics.setColor(SystemColor.textHighlightText);
                String string3 = string.substring(0, this.hiliteEndColumn);
                graphics.drawString(string3, 10, n3 - this.fontDescent);
            } else if (n == this.hiliteStartLine) {
                int n4 = n2 + 10 - this.hiliteStartPixel;
                graphics.setColor(SystemColor.textHighlight);
                graphics.fillRect(this.hiliteStartPixel, n3 - this.fontHeight, n4, this.fontHeight);
                graphics.setColor(SystemColor.textHighlightText);
                String string4 = string.substring(this.hiliteStartColumn);
                graphics.drawString(string4, this.hiliteStartPixel, n3 - this.fontDescent);
            }
        }
        n2 = n * this.theWidth + string.length();
        string = "" + n2;
        int n5 = this.stringLength(string);
        graphics.setColor(Color.red);
        graphics.drawString(string, this.dimension.width - n5 - 10, n3 - this.fontDescent);
        graphics.drawString(string, this.dimension.width - n5 - 10 + 1, n3 - this.fontDescent);
        if (n == this.mNumLines - 1) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, n3, this.dimension.width, this.dimension.height - n3);
        }
    }

    private void notify(String string, int n) {
    }

    class ScrollerThread
    extends Thread {
        private View view;

        public ScrollerThread(View view2) {
            this.view = view2;
        }

        public void run() {
            while (true) {
                try {
                    ScrollerThread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.view.mouseDragged(null);
            }
        }
    }

    class CursorThread
    extends Thread {
        private boolean flash;
        private boolean undraw;
        private Rectangle r = new Rectangle();

        public void run() {
            while (true) {
                try {
                    CursorThread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.sync_draw();
            }
        }

        private synchronized void sync_draw() {
            if (this.flash) {
                this.draw_or_undraw();
            }
        }

        public boolean getUndraw() {
            return this.undraw;
        }

        public synchronized void pause_cursor(boolean bl) {
            if (this.undraw) {
                this.draw_or_undraw();
            }
            this.flash = false;
        }

        public synchronized void resume_cursor(boolean bl) {
            if (!this.undraw) {
                this.draw_or_undraw();
            }
            this.flash = true;
        }

        private boolean draw_or_undraw() {
            Graphics graphics = View.this.This.getGraphics();
            if (graphics != null) {
                Rectangle rectangle = graphics.getClipBounds();
                if (rectangle != null) {
                    rectangle.grow(-1, -1);
                    graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (!this.undraw) {
                    View.this.This.getCursorPos(graphics, this.r);
                }
                graphics.setXORMode(Color.white);
                graphics.drawLine(this.r.x, this.r.y, this.r.x, this.r.y + this.r.height);
                this.undraw = !this.undraw;
                graphics.dispose();
            }
            return this.undraw;
        }
    }
}

