/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.structure;

import com.informagen.sa.structure.GraphCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GraphPanel
extends JPanel
implements PropertyChangeListener {
    GraphCanvas mGraphCanvas;
    JLabel mPanelLabel;
    JLabel mPosition;
    JLabel mValue;

    public GraphPanel(String string) {
        this.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.weightx = 80.0;
        gridBagConstraints.fill = 2;
        this.mPanelLabel = new JLabel(string, 2);
        gridBagLayout.setConstraints(this.mPanelLabel, gridBagConstraints);
        this.add(this.mPanelLabel);
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        this.mPosition = new JLabel("---", 4);
        gridBagLayout.setConstraints(this.mPosition, gridBagConstraints);
        this.add(this.mPosition);
        gridBagConstraints.gridwidth = 0;
        this.mValue = new JLabel("---", 4);
        gridBagLayout.setConstraints(this.mValue, gridBagConstraints);
        this.add(this.mValue);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.mGraphCanvas = new GraphCanvas();
        gridBagLayout.setConstraints(this.mGraphCanvas, gridBagConstraints);
        this.add(this.mGraphCanvas);
        this.mGraphCanvas.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                GraphPanel.this.mPosition.setText("---");
                GraphPanel.this.mValue.setText("---");
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.mGraphCanvas.propertyChange(propertyChangeEvent);
    }

    public void selectionChanged(int n, int n2) {
        this.mGraphCanvas.setNewSelection(n, n2);
    }

    public void setName(String string) {
        this.mPanelLabel.setText(string);
    }

    public void setGraphParameters(double d, double d2, double d3) {
        this.mGraphCanvas.setCutoff(d3);
        this.mGraphCanvas.setGraphMax(d2);
        this.mGraphCanvas.setGraphMin(d);
    }

    public void setGraphData(double[] dArray) {
        if (this.mGraphCanvas != null) {
            this.mGraphCanvas.setGraphData(dArray);
        }
    }

    public void reportPosition(int n, double d) {
        this.mPosition.setText(Integer.toString(n));
        String string = Double.toString(d);
        string = string.concat(string.indexOf(46) == -1 ? ".00" : "00");
        string = string.substring(0, string.indexOf(46) + 3);
        this.mValue.setText(string);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.white);
        graphics.fillRect(1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        super.paint(graphics);
    }
}

