/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.giv.GIVPanel;
import com.informagen.giv.MapView;
import com.informagen.sa.ImagePrinter;
import com.informagen.sa.digest.CutSite;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestAnalysisPanel;
import com.informagen.sa.digest.DigestParser;
import com.informagen.sa.digest.EnzymeCuts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GraphicDigestPanel
extends JPanel
implements DigestAnalysisPanel {
    private final GIVPanel givPanel = new GIVPanel(true, true, true);
    private final JLabel reporterLabel = new JLabel("");
    Digest digest = null;
    private Vector tiles;
    private Vector glyphs;
    private boolean threadIsRunning = false;
    int[] selection = null;

    public GraphicDigestPanel() {
        this.buildUI();
    }

    public void selectionChanged(int[] nArray) {
        this.selection = nArray;
        this.digestChanged(this.digest);
    }

    void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.givPanel, "Center");
        this.add((Component)this.reporterLabel, "South");
    }

    public void digestChanged(Digest digest) {
        this.digest = digest;
        if (this.threadIsRunning) {
            return;
        }
        if (digest == null) {
            return;
        }
        Iterator iterator = digest.getAllCutters().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        int n = digest.getSeqLength();
        int n2 = 0;
        int n3 = 0;
        if (this.selection != null) {
            n2 = this.selection[0];
            n3 = this.selection[1];
        }
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>");
        stringBuffer.append("<digest length=\"").append(n).append("\">");
        while (iterator.hasNext()) {
            EnzymeCuts enzymeCuts = (EnzymeCuts)iterator.next();
            stringBuffer.append("<enzyme label=\"");
            stringBuffer.append(enzymeCuts.getEnzymeName());
            stringBuffer.append("\">");
            if (this.selection != null) {
                stringBuffer.append("<selection from=\"").append(n2).append("\" ");
                stringBuffer.append("to=\"").append(n3).append("\"/>");
            }
            Iterator iterator2 = enzymeCuts.getCutSites().iterator();
            while (iterator2.hasNext()) {
                CutSite cutSite = (CutSite)iterator2.next();
                int n4 = cutSite.getCutPosition();
                int n5 = enzymeCuts.getCutCount();
                if (this.selection != null && n4 >= n2 && n4 <= n3) {
                    stringBuffer.append("<selection-cut at=\"").append(n4).append("\"/>");
                    continue;
                }
                if (n5 == 1) {
                    stringBuffer.append("<unique-cut at=\"").append(n4).append("\"/>");
                    continue;
                }
                stringBuffer.append("<cut at=\"").append(n4).append("\"/>");
            }
            stringBuffer.append("</enzyme>");
        }
        stringBuffer.append("</digest>");
        this.buildGraphic(stringBuffer.toString());
        this.initialZoom();
        this.invalidate();
        this.repaint();
    }

    public void initialZoom() {
        this.givPanel.initialZoom();
    }

    boolean buildGraphic(String string) {
        StringReader stringReader = new StringReader(string);
        MapView mapView = null;
        DigestParser digestParser = new DigestParser(stringReader);
        try {
            mapView = digestParser.parseXML();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage());
        }
        if (mapView == null) {
            return false;
        }
        this.installMapView(mapView);
        return true;
    }

    void installMapView(MapView mapView) {
        if (mapView == null) {
            return;
        }
        this.givPanel.installMapView(mapView);
        this.glyphs = this.givPanel.getGlyphs();
        this.tiles = this.givPanel.getTiles();
    }

    public void printPanel() {
        ImagePrinter imagePrinter = new ImagePrinter();
        int n = this.givPanel.getSize().width;
        int n2 = this.givPanel.getSize().height;
        Image image = this.givPanel.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.givPanel.paintAll(graphics);
        graphics.dispose();
        imagePrinter.setImage(image);
        imagePrinter.print();
    }

    public void savePanel() {
    }
}

