/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa;

import com.informagen.Sequence;
import com.informagen.sa.SWProteinTable;

public abstract class ComparisonTable {
    String mName;
    String mSymbols;
    float[] mTable;
    int[] mRow;
    double mOffset = 0.0;
    int mSign = 1;

    abstract double getThreshold();

    public String getName() {
        return this.mName;
    }

    public void setOffset(double d) {
        this.mOffset = d;
    }

    public void setFlipSign(boolean bl) {
        this.mSign = bl ? -1 : 1;
    }

    public double getHighest() {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.mTable.length; ++i) {
            if (!((double)this.mTable[i] > d)) continue;
            d = this.mTable[i];
        }
        return d;
    }

    public double getLowest() {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.mTable.length; ++i) {
            if (!((double)this.mTable[i] < d)) continue;
            d = this.mTable[i];
        }
        return d;
    }

    public double compare(char c, char c2) {
        int n = this.mSymbols.indexOf(c);
        int n2 = this.mSymbols.indexOf(c2);
        try {
            if (n > n2) {
                n = this.mSymbols.indexOf(c2);
                n2 = this.mSymbols.indexOf(c);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return Double.NEGATIVE_INFINITY;
        }
        int n3 = this.mRow[n] + (n2 - n);
        try {
            float f = this.mTable[n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)(f *= (float)this.mSign) + this.mOffset;
    }

    int[] rowIndex(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = n * i - ((i - 1) * i >> 1);
        }
        return nArray;
    }

    public static double identity(Sequence sequence, Sequence sequence2) {
        return ComparisonTable.identity(sequence.getSequence(), sequence2.getSequence());
    }

    public static double identity(String string, String string2) {
        char[] cArray = string.toUpperCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length && i < cArray2.length; ++i) {
            if (cArray[i] == '-' && cArray2[i] == '-') continue;
            ++n2;
            if (cArray[i] != cArray2[i]) continue;
            ++n;
        }
        return n2 == 0 ? 0.0 : (double)n / (double)n2 * 100.0;
    }

    public static double similarity(Sequence sequence, Sequence sequence2) {
        return ComparisonTable.similarity(sequence, sequence2, null);
    }

    public static double similarity(Sequence sequence, Sequence sequence2, ComparisonTable comparisonTable) {
        if (!sequence.isProtein() && !sequence2.isProtein()) {
            return ComparisonTable.identity(sequence, sequence2);
        }
        return ComparisonTable.similarity(sequence.getSequence(), sequence2.getSequence(), comparisonTable);
    }

    public static double similarity(String string, String string2, ComparisonTable comparisonTable) {
        ComparisonTable comparisonTable2 = comparisonTable;
        char[] cArray = string.toUpperCase().toCharArray();
        char[] cArray2 = string2.toUpperCase().toCharArray();
        if (comparisonTable2 == null) {
            comparisonTable2 = new SWProteinTable();
        }
        double d = comparisonTable2.getThreshold();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length && i < cArray2.length; ++i) {
            ++n2;
            if (cArray[i] == '-' || cArray2[i] == '-' || !(comparisonTable2.compare(cArray[i], cArray2[i]) >= d)) continue;
            ++n;
        }
        return n2 == 0 ? 0.0 : (double)n / (double)n2 * 100.0;
    }
}

