/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.Element;
import com.informagen.giv.ElementStyle;
import com.informagen.giv.GIVColors;
import com.informagen.giv.MapData;
import com.informagen.giv.MapPanel;
import com.informagen.giv.MapView;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class GIVFormat {
    private static final int kMap = 1;
    private static final int kMapView = 2;
    private static final int kMapPanel = 3;
    private static final int kElementType = 4;
    private static final int kPanelMember = 5;
    private static final int kElement = 6;
    private static MapData mMapData;
    private static String mLine;

    public static MapData create(BufferedReader bufferedReader) {
        mMapData = new MapData();
        int n = 0;
        try {
            String string;
            block6: while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0) continue;
                switch (string.charAt(0)) {
                    case '%': {
                        n = GIVFormat.dataSection(string);
                        continue block6;
                    }
                    case '#': {
                        continue block6;
                    }
                }
                GIVFormat.parse(n, string);
            }
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
        }
        return mMapData;
    }

    private static int dataSection(String string) {
        int n = 0;
        String string2 = string.toLowerCase();
        if (string2.startsWith("%elements")) {
            n = 6;
        } else if (string2.startsWith("%panel members")) {
            n = 5;
        } else if (string2.startsWith("%map panels")) {
            n = 3;
        } else if (string2.startsWith("%map views")) {
            n = 2;
        }
        return n;
    }

    private static void parse(int n, String string) {
        switch (n) {
            case 6: {
                GIVFormat.doElement(string);
                break;
            }
            case 5: {
                GIVFormat.doPanelMember(string);
                break;
            }
            case 3: {
                GIVFormat.doMapPanel(string);
                break;
            }
            case 2: {
                GIVFormat.doMapView(string);
            }
        }
    }

    private static void doMapView(String string) {
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        mMapData.addMapView(string2, string3, new MapView());
    }

    private static void doMapPanel(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        Double d3 = Double.valueOf(string7);
        d = d3;
        string7 = stringTokenizer.nextToken();
        d3 = Double.valueOf(string7);
        d2 = d3;
        string6 = stringTokenizer.nextToken();
        string5 = stringTokenizer.nextToken();
        string7 = stringTokenizer.nextToken();
        if (string7.equalsIgnoreCase("0")) {
            n = 0;
        } else if (string7.equalsIgnoreCase("Floating")) {
            n = 0;
        } else if (string7.equalsIgnoreCase("1")) {
            n = 1;
        } else if (string7.equalsIgnoreCase("Sinking")) {
            n = 1;
        } else if (string7.equalsIgnoreCase("2")) {
            n = 2;
        } else if (string7.equalsIgnoreCase("TopDown")) {
            n = 2;
        } else if (string7.equalsIgnoreCase("3")) {
            n = 3;
        } else if (string7.equalsIgnoreCase("BottomUp")) {
            n = 3;
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        string7 = stringTokenizer.nextToken();
        int n2 = Integer.parseInt(string7);
        string7 = stringTokenizer.nextToken();
        int n3 = Integer.parseInt(string7);
        MapPanel mapPanel = new MapPanel();
        mapPanel.setBuoyancy(n, n2, n3);
        mapPanel.setWallpaper(GIVColors.getColor(string6));
        mapPanel.setTitle(string5);
        mapPanel.setExtent(d, d2);
        mMapData.addMapPanel(string2, string3, mapPanel);
    }

    private static void doPanelMember(String string) {
        ElementStyle elementStyle = new ElementStyle();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        string2 = stringTokenizer.nextToken();
        string4 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        string5 = stringTokenizer.nextToken();
        elementStyle.setColor(GIVColors.getColor(string5));
        String string6 = stringTokenizer.nextToken();
        elementStyle.barHeight(Integer.parseInt(string6));
        string6 = stringTokenizer.nextToken();
        if (string6.equalsIgnoreCase("0")) {
            n = 0;
        } else if (string6.equalsIgnoreCase("Always")) {
            n = 0;
        } else if (string6.equalsIgnoreCase("1")) {
            n = 1;
        } else if (string6.equalsIgnoreCase("Bigger")) {
            n = 1;
        } else if (string6.equalsIgnoreCase("2")) {
            n = 2;
        } else if (string6.equalsIgnoreCase("Never")) {
            n = 2;
        }
        elementStyle.labelDisplay(n);
        string6 = stringTokenizer.nextToken();
        if (string6.equalsIgnoreCase("0")) {
            n2 = 0;
        } else if (string6.equalsIgnoreCase("Below")) {
            n2 = 0;
        } else if (string6.equalsIgnoreCase("1")) {
            n2 = 1;
        } else if (string6.equalsIgnoreCase("Above")) {
            n2 = 1;
        }
        elementStyle.labelPosition(n2);
        string6 = stringTokenizer.nextToken();
        elementStyle.labelContent(Integer.parseInt(string6));
        string6 = stringTokenizer.nextToken();
        elementStyle.labelSize(Integer.parseInt(string6));
        string6 = stringTokenizer.nextToken();
        elementStyle.descriptorContent(Integer.parseInt(string6));
        string6 = stringTokenizer.nextToken();
        elementStyle.border(Integer.parseInt(string6));
        mMapData.addPanelMember(string2, string3, string4, elementStyle);
    }

    private static void doElement(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        float f = 0.0f;
        float f2 = 0.0f;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        Float f3 = Float.valueOf(string5);
        f = f3.floatValue();
        if (f > (f2 = (f3 = Float.valueOf(string5 = stringTokenizer.nextToken())).floatValue())) {
            float f4 = f2;
            f2 = f;
            f = f4;
        }
        string4 = stringTokenizer.nextToken();
        Element element = new Element(string4, f, f2);
        mMapData.addElement(string2, string3, element);
    }
}

