/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.blat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.BlatTrack;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.blat.BlatQueryWindow;

public class BlatClient {
    private static Logger log = Logger.getLogger(BlatClient.class);
    public static final int MINIMUM_BLAT_LENGTH = 20;
    static int sleepTime = 15000;
    static String hgsid;
    static long lastQueryTime;

    static void Usage() {
        System.out.println("usage: BlatBot <organism> <db> <searchType> <sortOrder>");
        System.out.println(" <outputType> <querySequence>");
        System.out.println("\tSpecify organism using the common name with first letter");
        System.out.println("capitalized.");
        System.out.println("\te.g. Human, Mouse, Rat etc.");
        System.out.println("\tDb is database or assembly name e.g hg17, mm5, rn3 etc.");
        System.out.println("\tsearchType can be BLATGuess, DNA, RNA, transDNA or transRNA");
        System.out.println("\tsortOrder can be query,score; query,start; chrom,score");
        System.out.println("\tchrom,start; score.");
        System.out.println("\toutputType can be pslNoHeader, psl or hyperlink.");
        System.out.println("\tblats will be run in groups of $batchCount sequences, all");
    }

    public static List<String> blat(String org, String db, String userSeq) throws IOException {
        String result;
        String searchType = "DNA";
        String sortOrder = "query,score";
        String outputType = "psl";
        String $url = PreferencesManager.getPreferences().get("BLAT_URL").trim();
        String serverType = PreferencesManager.getPreferences().get("BLAT_SERVER_TYPE");
        if (serverType.equalsIgnoreCase("web_blat")) {
            String urlString = $url + "?&wb_qtype=" + searchType + "&wb_sort=" + sortOrder + "&wb_output=" + outputType + "&wb_seq=" + userSeq;
            result = HttpUtils.getInstance().getContentsAsString(new URL(urlString));
        } else {
            String urlString = $url + "?org=" + org + "&db=" + db + "&type=" + searchType + "&sort=" + sortOrder + "&output=" + outputType;
            if (hgsid != null) {
                urlString = urlString + "&hgsid=" + hgsid;
            }
            URL url = HttpUtils.createURL(urlString);
            long dt = System.currentTimeMillis() - lastQueryTime;
            if (dt < (long)sleepTime) {
                try {
                    Thread.sleep(dt);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            lastQueryTime = System.currentTimeMillis();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userSeq", userSeq);
            result = HttpUtils.getInstance().doPost(url, params);
        }
        return BlatClient.parseResult(result);
    }

    public static List<String> webBlat(String userSeq) throws IOException {
        String searchType = "DNA";
        String sortOrder = "query,score";
        String outputType = "psl";
        String $url = PreferencesManager.getPreferences().get("BLAT_URL").trim();
        String urlString = $url + "?&wb_qtype=" + searchType + "&wb_sort=" + sortOrder + "&wb_output=" + outputType + "&wb_seq=" + userSeq;
        log.info((Object)("BLAT: " + urlString));
        String result = HttpUtils.getInstance().getContentsAsString(new URL(urlString));
        List<String> records = BlatClient.parseResult(result);
        return BlatClient.fixWebBlat(records);
    }

    static List<String> fixWebBlat(List<String> records) {
        ArrayList<String> fixed = new ArrayList<String>(records.size());
        for (String line : records) {
            if (line.startsWith("#")) {
                fixed.add(line);
                continue;
            }
            Object fixedLine = "";
            String[] tokens = Globals.singleTabMultiSpacePattern.split(line);
            for (int i = 0; i < tokens.length; ++i) {
                int idx;
                if (i > 0) {
                    fixedLine = (String)fixedLine + "\t";
                }
                String t = tokens[i];
                if (i == 13 && (idx = t.indexOf(":")) > 0) {
                    t = t.substring(idx + 1);
                }
                fixedLine = (String)fixedLine + t;
            }
            fixed.add((String)fixedLine);
        }
        return fixed;
    }

    static List<String> parseResult(String result) throws IOException {
        String l;
        ArrayList<String> records = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(result));
        boolean pslSectionFound = false;
        boolean pslHeaderFound = false;
        while ((l = br.readLine()) != null) {
            String line = l.trim();
            String lowerCase = line.toLowerCase();
            if (pslHeaderFound) {
                if (lowerCase.contains("</tt>")) break;
                String[] tokens = Globals.whitespacePattern.split(line);
                if (tokens.length == 21) {
                    records.add(line);
                }
            }
            if (lowerCase.contains("<tt>") && lowerCase.contains("<pre>") && lowerCase.contains("pslayout")) {
                pslSectionFound = true;
                continue;
            }
            if (!pslSectionFound || !lowerCase.startsWith("-----------------------------")) continue;
            pslHeaderFound = true;
        }
        return records;
    }

    public static void doBlatQuery(String chr, int start, int end, Strand strand) {
        BlatClient.doBlatQuery(chr, start, end, strand, "Blat");
    }

    public static void doBlatQuery(String chr, int start, int end, Strand strand, String trackLabel) {
        if (end - start > 8000) {
            MessageUtils.showMessage("BLAT searches are limited to 8kb.  Please try a shorter sequence.");
            return;
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte[] seqBytes = genome.getSequence(chr, start, end);
        String userSeq = new String(seqBytes);
        if (strand == Strand.NEGATIVE) {
            userSeq = SequenceTrack.getReverseComplement(userSeq);
        }
        BlatClient.doBlatQuery(userSeq);
    }

    public static void doBlatQuery(String userSeq) {
        BlatClient.doBlatQuery(userSeq, "Blat");
    }

    public static void doBlatQuery(final String userSeq, final String trackLabel) {
        LongRunningTask.submit(new NamedRunnable(){

            @Override
            public String getName() {
                return "Blat sequence";
            }

            @Override
            public void run() {
                try {
                    List<String> tokensList;
                    String serverType = PreferencesManager.getPreferences().get("BLAT_SERVER_TYPE");
                    if (serverType.equalsIgnoreCase("web_blat")) {
                        tokensList = BlatClient.webBlat(userSeq);
                    } else {
                        Genome genome = IGV.hasInstance() ? GenomeManager.getInstance().getCurrentGenome() : null;
                        String db = genome.getId();
                        String species = genome.getSpecies();
                        if (species == null) {
                            MessageUtils.showMessage("Cannot determine species name for genome: " + genome.getDisplayName());
                            return;
                        }
                        tokensList = BlatClient.blat(species, db, userSeq);
                    }
                    if (tokensList.isEmpty()) {
                        MessageUtils.showMessage("No features found");
                    } else {
                        BlatTrack newTrack = new BlatTrack(userSeq, tokensList, trackLabel);
                        IGV.getInstance().getTrackPanel("FeaturePanel").addTrack(newTrack);
                        IGV.getInstance().repaint();
                        BlatQueryWindow win = new BlatQueryWindow(IGV.getMainFrame(), userSeq, newTrack.getFeatures());
                        win.setVisible(true);
                    }
                }
                catch (Exception e1) {
                    MessageUtils.showErrorMessage("Error running blat", e1);
                }
            }
        });
    }

    public static JMenuItem getMenuItem() {
        JMenuItem menuItem = new JMenuItem("BLAT ...");
        menuItem.addActionListener(e -> {
            String blatSequence = MessageUtils.showInputDialog("Enter sequence to blat:");
            if (blatSequence != null) {
                BlatClient.doBlatQuery(blatSequence);
            }
        });
        return menuItem;
    }

    static {
        lastQueryTime = 0L;
    }
}

