/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.Transform;

import FCSalyzer.FCS.FCS_data;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class Compensation {
    private String name;
    private int[][] comps100;
    private final int[][] spillover100;
    private boolean[][] needsComp;
    private boolean noComp = true;
    private int compCount = 0;
    private static final double shiftValue = 1.0E-7;
    public static final String XML_name = "Compensation";
    private static final String XML_comp_index = "index";
    private static final String XML_comp_name = "name";
    private static final String XML_comp_count = "parameter_count";
    private static final String XML_comp_param_base = "Parameter_";

    private Compensation(String Name, int[][] spilloverValues) {
        this.name = Name;
        this.spillover100 = spilloverValues;
        for (int i = 0; i < this.spillover100.length; ++i) {
            this.spillover100[i][i] = 10000;
        }
        this.calcCompensation();
        this.setNeedsComp();
    }

    private void calcCompensation() {
        this.comps100 = this.invertMatrix(this.spillover100, false);
        if (this.comps100 == null) {
            this.invertMatrix(this.spillover100, true);
        }
        if (this.comps100 == null) {
            this.comps100 = this.spillover100;
        }
    }

    private int[][] invertMatrix(int[][] originalMatrix, boolean shift) {
        int j;
        int i;
        int matrixSize = originalMatrix.length;
        double[][] startMatrix = new double[matrixSize][];
        for (i = 0; i < matrixSize; ++i) {
            startMatrix[i] = new double[matrixSize * 2];
            for (j = 0; j < matrixSize; ++j) {
                startMatrix[i][j] = originalMatrix[i][j];
                startMatrix[i][j] = startMatrix[i][j] / 10000.0;
                if (!shift) continue;
                startMatrix[i][j] = startMatrix[i][j] + 1.0E-7;
            }
        }
        for (i = 0; i < matrixSize; ++i) {
            for (j = 0; j < matrixSize; ++j) {
                startMatrix[i][j + matrixSize] = i == j ? 1.0 : 0.0;
            }
        }
        for (i = 0; i < matrixSize; ++i) {
            if (startMatrix[i][i] == 0.0) {
                return null;
            }
            for (j = 0; j < matrixSize; ++j) {
                if (j == i) continue;
                double ratio = startMatrix[j][i] / startMatrix[i][i];
                for (int k = 0; k < 2 * matrixSize; ++k) {
                    startMatrix[j][k] = startMatrix[j][k] - ratio * startMatrix[i][k];
                }
            }
        }
        for (i = 0; i < matrixSize; ++i) {
            for (j = matrixSize; j < matrixSize * 2; ++j) {
                startMatrix[i][j] = startMatrix[i][j] / startMatrix[i][i];
            }
        }
        int[][] toReturn = new int[matrixSize][matrixSize];
        for (int i2 = 0; i2 < matrixSize; ++i2) {
            for (int j2 = 0; j2 < matrixSize; ++j2) {
                toReturn[i2][j2] = (int)Math.round(startMatrix[i2][j2 + matrixSize] * 10000.0);
            }
        }
        return toReturn;
    }

    public static Compensation generateCompensation(String Name, int[][] compensationValues) {
        if (Name == null) {
            return null;
        }
        if (compensationValues == null) {
            return null;
        }
        if (compensationValues.length <= 0) {
            return null;
        }
        if (compensationValues.length != compensationValues[0].length) {
            return null;
        }
        Compensation toReturn = new Compensation(Name, compensationValues);
        return toReturn;
    }

    public static Compensation generateCompensation(String Name, int parameterCount) {
        int[][] comps;
        for (int[] comp : comps = new int[parameterCount][parameterCount]) {
            for (int j = 0; j < comp.length; ++j) {
                comp[j] = 0;
            }
        }
        return Compensation.generateCompensation(Name, comps);
    }

    public static Compensation generateCompensation(FCS_data theData) {
        if (theData == null) {
            return null;
        }
        return Compensation.generateCompensation("New comp, " + theData.getRawParameterCount() + " parameters", theData.getRawParameterCount());
    }

    public static Compensation fromXML(Node sourceNode, List<Compensation> documentComps) {
        if (sourceNode == null) {
            return null;
        }
        NodeList nL = sourceNode.getChildNodes();
        String name = "Comp";
        ArrayList<Node> params = new ArrayList<Node>();
        for (int i = 0; i < nL.getLength(); ++i) {
            Node current = nL.item(i);
            if (current.getNodeName().equals(XML_comp_name)) {
                name = staticMethods.getNodeText(current);
                continue;
            }
            if (!current.getNodeName().startsWith(XML_comp_param_base)) continue;
            params.add(current);
        }
        int count = params.size();
        if (count == 0) {
            return null;
        }
        int[][] compValues = new int[count][count];
        for (int i = 0; i < count; ++i) {
            Node current = (Node)params.get(i);
            int currentParam = Integer.valueOf(current.getNodeName().substring(XML_comp_param_base.length()));
            nL = current.getChildNodes();
            for (int j = 0; j < nL.getLength(); ++j) {
                int newValue;
                Node curr = nL.item(j);
                if (!curr.getNodeName().startsWith(XML_comp_param_base)) continue;
                int compParam = Integer.valueOf(curr.getNodeName().substring(XML_comp_param_base.length()));
                compValues[currentParam][compParam] = newValue = staticMethods.getNodeInteger(curr, 0).intValue();
            }
        }
        return Compensation.generateCompensation(name, compValues);
    }

    public boolean compareSpillover(int[][] toCompare) {
        if (toCompare.length != this.spillover100.length) {
            return false;
        }
        for (int i = 0; i < this.spillover100.length; ++i) {
            for (int k = 0; k < this.spillover100.length; ++k) {
                if (toCompare[i][k] == this.spillover100[i][k]) continue;
                return false;
            }
        }
        return true;
    }

    private void setNeedsComp() {
        this.needsComp = new boolean[this.comps100.length][this.comps100[0].length];
        this.noComp = true;
        for (int i = 0; i < this.comps100.length; ++i) {
            for (int j = 0; j < this.comps100[i].length; ++j) {
                if (this.comps100[i][j] > 0) {
                    this.needsComp[i][j] = true;
                    ++this.compCount;
                    this.noComp = false;
                    continue;
                }
                this.needsComp[i][j] = false;
            }
        }
    }

    public double[] compensate(double[] event) {
        if (this.noComp) {
            return event;
        }
        if (event.length != this.comps100.length) {
            return event;
        }
        double[] result = new double[event.length];
        for (int i = 0; i < event.length; ++i) {
            for (int j = 0; j < event.length; ++j) {
                double compFactor = this.comps100[i][j];
                double compValue = event[j] * compFactor;
                result[i] = result[i] + (compValue /= 10000.0);
            }
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public int getParamCount() {
        return this.comps100.length;
    }

    public int getSpillover(int paramToAdjust, int paramToSubtract) {
        return this.spillover100[paramToAdjust][paramToSubtract];
    }

    public int getCompensation(int paramToAdjust, int paramToSubtract) {
        return this.comps100[paramToAdjust][paramToSubtract];
    }

    public void setSpillover(int paramToAdjust, int paramToSubtract, int newSpillover) {
        int oldValue = this.spillover100[paramToAdjust][paramToSubtract];
        if (newSpillover != oldValue) {
            this.spillover100[paramToAdjust][paramToSubtract] = newSpillover;
            this.calcCompensation();
            this.setNeedsComp();
        }
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void toXML(Node parent, int index) {
        Node comp = staticMethods.addNode(parent, XML_name, null);
        staticMethods.addNode(comp, XML_comp_index, index);
        staticMethods.addNode(comp, XML_comp_name, this.name);
        staticMethods.addNode(comp, XML_comp_count, this.comps100.length);
        for (int i = 0; i < this.spillover100.length; ++i) {
            Node p = staticMethods.addNode(comp, XML_comp_param_base + i, null);
            for (int j = 0; j < this.spillover100.length; ++j) {
                staticMethods.addNode(p, XML_comp_param_base + j, this.spillover100[i][j]);
            }
        }
    }

    protected void addPrefix(String prefix, int count, StringBuilder addTo) {
        for (int i = 0; i < count; ++i) {
            addTo.append(prefix);
        }
    }
}

