/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som.training.clustercopy;

import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.neural.som.SOM;

public class SOMClusterCopyTraining
extends BasicTraining {
    private final SOM network;
    private boolean done;

    public SOMClusterCopyTraining(SOM network, MLDataSet training) {
        super(TrainingImplementationType.OnePass);
        this.network = network;
        if ((long)this.network.getOutputCount() < training.getRecordCount()) {
            throw new NeuralNetworkError("To use cluster copy training you must have at least as many output neurons as training elements.");
        }
        this.setTraining(training);
    }

    @Override
    public final boolean canContinue() {
        return false;
    }

    @Override
    public boolean isTrainingDone() {
        if (super.isTrainingDone()) {
            return true;
        }
        return this.done;
    }

    private void copyInputPattern(int outputNeuron, MLData input) {
        for (int inputNeuron = 0; inputNeuron < this.network.getInputCount(); ++inputNeuron) {
            this.network.getWeights().set(outputNeuron, inputNeuron, input.getData(inputNeuron));
        }
    }

    @Override
    public final MLMethod getMethod() {
        return this.network;
    }

    @Override
    public void iteration() {
        int outputNeuron = 0;
        for (MLDataPair pair : this.getTraining()) {
            this.copyInputPattern(outputNeuron++, pair.getInput());
        }
        this.done = true;
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }
}

