/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.bam;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.neural.bam.BAM;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;

public class PersistBAM
implements EncogPersistor {
    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return "BAM";
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        BAM result = new BAM();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("BAM") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (!section.getSectionName().equals("BAM") || !section.getSubSectionName().equals("NETWORK")) continue;
            params = section.parseParams();
            result.setF1Count(EncogFileSection.parseInt(params, "f1Count"));
            result.setF2Count(EncogFileSection.parseInt(params, "f2Count"));
            result.setWeightsF1toF2(EncogFileSection.parseMatrix(params, "weightsF1F2"));
            result.setWeightsF2toF1(EncogFileSection.parseMatrix(params, "weightsF2F1"));
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        BAM bam = (BAM)obj;
        out.addSection("BAM");
        out.addSubSection("PARAMS");
        out.addProperties(bam.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("f1Count", bam.getF1Count());
        out.writeProperty("f2Count", bam.getF2Count());
        out.writeProperty("weightsF1F2", bam.getWeightsF1toF2());
        out.writeProperty("weightsF2F1", bam.getWeightsF2toF1());
        out.flush();
    }
}

