/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.Email;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.NumberUtils;

public class IncomingREM
extends MsnIncomingMessage {
    public IncomingREM(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    public MsnList getList() {
        return MsnList.parseStr(this.getParam(0));
    }

    public Email getEmail() {
        if (this.getList() == MsnList.RL || this.protocol.after(MsnProtocol.MSNP10)) {
            if (this.protocol.before(MsnProtocol.MSNP10)) {
                return Email.parseStr(this.getParam(2));
            }
            return Email.parseStr(this.getParam(1));
        }
        return null;
    }

    public int getVersion() {
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return NumberUtils.stringToInt(this.getParam(1));
        }
        return -1;
    }

    public String getId() {
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return this.getParam(2);
        }
        return this.getParam(1);
    }

    public String getGroupId() {
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return this.getParam(3);
        }
        return this.getParam(2);
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnContactListImpl msnContactListImpl = (MsnContactListImpl)msnSession.getMessenger().getContactList();
        MsnList msnList = this.getList();
        if (msnList == MsnList.RL) {
            MsnContactImpl msnContactImpl = (MsnContactImpl)msnContactListImpl.getContactByEmail(this.getEmail());
            if (msnContactImpl != null) {
                msnContactImpl.setInList(MsnList.RL, false);
                ((AbstractMessenger)msnSession.getMessenger()).fireContactRemovedMe(msnContactImpl);
            }
        } else {
            MsnContactImpl msnContactImpl = msnList == MsnList.FL || this.protocol.before(MsnProtocol.MSNP10) ? (MsnContactImpl)msnContactListImpl.getContactById(this.getId()) : (MsnContactImpl)msnContactListImpl.getContactByEmail(this.getEmail());
            if (msnContactImpl != null) {
                msnContactImpl.setInList(msnList, false);
                if (msnContactImpl.getListNumber() == 0) {
                    msnContactListImpl.removeContactByEmail(msnContactImpl.getEmail());
                }
                if (msnList == MsnList.FL) {
                    MsnGroup msnGroup = msnContactListImpl.getGroup(this.getGroupId());
                    msnContactImpl.removeBelongGroup(this.getGroupId());
                    if (msnGroup == null) {
                        ((AbstractMessenger)msnSession.getMessenger()).fireContactRemoveCompleted(msnContactImpl, MsnList.FL);
                    } else {
                        ((AbstractMessenger)msnSession.getMessenger()).fireContactRemoveFromGroupCompleted(msnContactImpl, msnGroup);
                    }
                }
                ((AbstractMessenger)msnSession.getMessenger()).fireContactRemoveCompleted(msnContactImpl, msnList);
            }
        }
    }
}

