/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class CloseFlapCmd
extends FlapCommand {
    public static final int CHANNEL_CLOSE = 4;
    public static final int CODE_LOGGED_IN_ELSEWHERE = 1;
    private static final int TYPE_CODE = 9;
    private static final int TYPE_URL = 11;
    private final int code;
    private final String url;

    protected CloseFlapCmd(FlapPacket packet) {
        super(4);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock flapData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(flapData);
        this.code = chain.getUShort(9);
        this.url = chain.getString(11);
    }

    public CloseFlapCmd() {
        this(-1, null);
    }

    public CloseFlapCmd(int code) {
        this(code, null);
    }

    public CloseFlapCmd(int code, String url) {
        super(4);
        DefensiveTools.checkRange((int)code, (String)"code", (int)-1);
        this.code = code;
        this.url = url;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getUrl() {
        return this.url;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.code != -1) {
            Tlv.getUShortInstance(9, this.code).write(out);
        }
        if (this.url != null) {
            Tlv.getStringInstance(11, this.url).write(out);
        }
    }

    public String toString() {
        return "CloseFlapCmd: " + (this.code != -1 ? ": code=0x" + Integer.toHexString(this.code) : "") + " url=" + this.url;
    }
}

