/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.recording;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.datasink.DataSinkListener;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.recording.WebmWriter;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.service.neomedia.recording.RecorderEvent;
import org.jitsi.service.neomedia.recording.RecorderEventHandler;
import org.jitsi.util.Logger;

public class WebmDataSink
implements DataSink,
BufferTransferHandler {
    private static final Logger logger = Logger.getLogger(WebmDataSink.class);
    private static final boolean USE_RECORDING_ENDED_EVENTS = false;
    private WebmWriter writer = null;
    private RecorderEventHandler eventHandler;
    private long ssrc = -1L;
    private boolean open = false;
    private final Object openCloseSyncRoot = new Object();
    private boolean waitingForKeyframe = true;
    private int height = 0;
    private int width = 0;
    private Buffer buffer = new Buffer();
    private WebmWriter.FrameDescriptor fd = new WebmWriter.FrameDescriptor();
    private DataSource dataSource = null;
    private String filename;
    private long firstFrameRtpTimestamp = -1L;
    private long firstFrameTime = -1L;
    private long lastFramePts = -1L;
    private KeyFrameControl keyFrameControl = null;
    private boolean keyframeRequested = false;
    private int framesSinceLastKeyframeRequest = 0;
    private static int REREQUEST_KEYFRAME_INTERVAL = 100;

    public WebmDataSink(String filename, DataSource dataSource) {
        this.filename = filename;
        this.dataSource = dataSource;
    }

    public void addDataSinkListener(DataSinkListener dataSinkListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.openCloseSyncRoot;
        synchronized (object) {
            if (!this.open) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not closing WebmDataSink: already closed.");
                }
                return;
            }
            if (this.writer != null) {
                this.writer.close();
            }
            this.open = false;
        }
    }

    public String getContentType() {
        return null;
    }

    public MediaLocator getOutputLocator() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException, SecurityException {
        Object object = this.openCloseSyncRoot;
        synchronized (object) {
            if (this.dataSource instanceof PushBufferDataSource) {
                PushBufferStream[] streams;
                PushBufferDataSource pbds = (PushBufferDataSource)this.dataSource;
                for (PushBufferStream stream : streams = pbds.getStreams()) {
                    if (!stream.getFormat().matches((Format)new VideoFormat("VP8"))) {
                        throw new IOException("Unsupported stream format");
                    }
                    stream.setTransferHandler((BufferTransferHandler)this);
                }
            }
            this.dataSource.connect();
            this.open = true;
        }
    }

    public void removeDataSinkListener(DataSinkListener dataSinkListener) {
    }

    public void setOutputLocator(MediaLocator mediaLocator) {
    }

    public void start() throws IOException {
        this.writer = new WebmWriter(this.filename);
        this.dataSource.start();
        if (logger.isInfoEnabled()) {
            logger.info("Created WebmWriter on " + this.filename);
        }
    }

    public void stop() throws IOException {
    }

    public Object getControl(String s) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferData(PushBufferStream stream) {
        Object object = this.openCloseSyncRoot;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            try {
                stream.read(this.buffer);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            byte[] data = (byte[])this.buffer.getData();
            int offset = this.buffer.getOffset();
            int len = this.buffer.getLength();
            long rtpTimeStamp = this.buffer.getRtpTimeStamp();
            boolean key = this.isKeyFrame(data, offset);
            boolean valid = this.isKeyFrameValid(data, offset);
            if (this.waitingForKeyframe && key) {
                if (valid) {
                    this.waitingForKeyframe = false;
                    this.width = this.getWidth(data, offset);
                    this.height = this.getHeight(data, offset);
                    this.firstFrameRtpTimestamp = rtpTimeStamp;
                    this.firstFrameTime = System.currentTimeMillis();
                    this.writer.writeWebmFileHeader(this.width, this.height);
                    if (logger.isInfoEnabled()) {
                        logger.info("Received the first keyframe (width=" + this.width + "; height=" + this.height + ")" + " ssrc=" + this.ssrc);
                    }
                    if (this.eventHandler != null) {
                        RecorderEvent event = new RecorderEvent();
                        event.setType(RecorderEvent.Type.RECORDING_STARTED);
                        event.setSsrc(this.ssrc);
                        if (this.height * 4 == this.width * 3) {
                            event.setAspectRatio(RecorderEvent.AspectRatio.ASPECT_RATIO_4_3);
                        } else if (this.height * 16 == this.width * 9) {
                            event.setAspectRatio(RecorderEvent.AspectRatio.ASPECT_RATIO_16_9);
                        }
                        event.setFilename(this.filename);
                        event.setInstant(this.firstFrameTime);
                        event.setRtpTimestamp(rtpTimeStamp);
                        event.setMediaType(MediaType.VIDEO);
                        this.eventHandler.handleEvent(event);
                    }
                } else {
                    this.keyframeRequested = false;
                    if (logger.isInfoEnabled()) {
                        logger.info("Received an invalid first keyframe. Requesting a new one." + this.ssrc);
                    }
                }
            }
            ++this.framesSinceLastKeyframeRequest;
            if (this.framesSinceLastKeyframeRequest > REREQUEST_KEYFRAME_INTERVAL) {
                this.keyframeRequested = false;
            }
            if (this.waitingForKeyframe && !this.keyframeRequested) {
                if (logger.isInfoEnabled()) {
                    logger.info("Requesting keyframe. " + this.ssrc);
                }
                if (this.keyFrameControl != null) {
                    this.keyframeRequested = this.keyFrameControl.requestKeyFrame(false);
                }
                this.framesSinceLastKeyframeRequest = 0;
            }
            if (key && logger.isInfoEnabled()) {
                String s = "";
                for (int i = 0; i < 10 && i < len; ++i) {
                    s = s + String.format("%02x", data[offset + i]);
                }
                logger.info("Keyframe. First 10 bytes: " + s);
            }
            if (!this.waitingForKeyframe) {
                long diff;
                if (key) {
                    if (!valid) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Dropping an invalid VP8 keyframe.");
                        }
                        return;
                    }
                    int oldWidth = this.width;
                    this.width = this.getWidth(data, offset);
                    int oldHeight = this.height;
                    this.height = this.getHeight(data, offset);
                    if ((this.width != oldWidth || this.height != oldHeight) && logger.isInfoEnabled()) {
                        logger.info("VP8 stream width/height changed. Old: " + oldWidth + "/" + oldHeight + ". New: " + this.width + "/" + this.height + ".");
                    }
                }
                this.fd.buffer = data;
                this.fd.offset = offset;
                this.fd.length = len;
                int n = this.fd.flags = key ? WebmWriter.FLAG_FRAME_IS_KEY : 0;
                if (!this.isShowFrame(data, offset)) {
                    this.fd.flags |= WebmWriter.FLAG_FRAME_IS_INVISIBLE;
                }
                if ((diff = rtpTimeStamp - this.firstFrameRtpTimestamp) < Integer.MIN_VALUE) {
                    diff += 0x100000000L;
                }
                this.fd.pts = diff / 90L;
                this.writer.writeFrame(this.fd);
                this.lastFramePts = this.fd.pts;
            }
        }
    }

    private boolean isKeyFrame(byte[] buf, int offset) {
        return (buf[offset] & 1) == 0;
    }

    private boolean isKeyFrameValid(byte[] buf, int offset) {
        return buf[offset + 3] == -99 && buf[offset + 4] == 1 && buf[offset + 5] == 42;
    }

    private int getWidth(byte[] buf, int offset) {
        return ((buf[offset + 7] & 0xFF) << 8 | buf[offset + 6] & 0xFF) & 0x3FFF;
    }

    private int getHeight(byte[] buf, int offset) {
        return ((buf[offset + 9] & 0xFF) << 8 | buf[offset + 8] & 0xFF) & 0x3FFF;
    }

    private boolean isShowFrame(byte[] buf, int offset) {
        return (buf[offset] & 0x10) == 0;
    }

    public void setKeyFrameControl(KeyFrameControl keyFrameControl) {
        this.keyFrameControl = keyFrameControl;
    }

    public RecorderEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(RecorderEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }
}

