/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class AllocDiffPanel
extends JPanel {
    private TimeSeries totalSeries = new TimeSeries("Allocs/Sec", Millisecond.class);

    public AllocDiffPanel() {
        this(60000);
    }

    public AllocDiffPanel(int maxAgeMillis) {
        super(new BorderLayout());
        this.totalSeries.setMaximumItemAge((long)maxAgeMillis);
        TimeSeriesCollection seriesCollection = new TimeSeriesCollection();
        seriesCollection.addSeries(this.totalSeries);
        NumberAxis numberAxis = new NumberAxis("Allocs/Sec");
        numberAxis.setLabelFont(new Font("SansSerif", 0, 14));
        numberAxis.setTickLabelFont(new Font("SansSerif", 0, 12));
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        DateAxis dateAxis = new DateAxis("Time");
        dateAxis.setTickLabelFont(new Font("SansSerif", 0, 12));
        dateAxis.setLabelFont(new Font("SansSerif", 0, 14));
        dateAxis.setAutoRange(true);
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        dateAxis.setTickLabelsVisible(true);
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm:ss"));
        XYLineAndShapeRenderer lineRenderer = new XYLineAndShapeRenderer(true, false);
        lineRenderer.setSeriesPaint(0, (Paint)Color.RED);
        lineRenderer.setSeriesPaint(1, (Paint)Color.GREEN.darker());
        lineRenderer.setStroke((Stroke)new BasicStroke(2.0f, 1, 1));
        XYPlot xyplot = new XYPlot((XYDataset)seriesCollection, (ValueAxis)dateAxis, (ValueAxis)numberAxis, (XYItemRenderer)lineRenderer);
        xyplot.setBackgroundPaint((Paint)Color.WHITE);
        xyplot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        xyplot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        xyplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        JFreeChart chart = new JFreeChart("Object Allocactions in Remote JVM", new Font("SansSerif", 0, 18), (Plot)xyplot, true);
        chart.setBackgroundPaint((Paint)Color.white);
        ChartPanel panel = new ChartPanel(chart);
        panel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createLineBorder(Color.LIGHT_GRAY)));
        this.add((Component)panel);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
    }

    public void addSample(Millisecond m, double allocDiff) {
        this.totalSeries.add((RegularTimePeriod)m, allocDiff);
    }

    public void reset() {
        this.totalSeries.clear();
    }
}

