/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.profiler4j.agent.Profiler4JError;
import net.sf.profiler4j.agent.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private static final Pattern ruleRegex = Pattern.compile("^\\s*([a-zA-Z0-9_\\(\\)\\*\\.\\$]+)\\s*:\\s*(accept|reject)\\s*(.*)$");
    private static final OptionParser[] optionHandlers = new OptionParser[]{new OptionParser(Rule.Option.ACCESS, "access", "private|package|protected|public"), new OptionParser(Rule.Option.BEANPROPS, "beanprops", "on|off")};

    public static boolean parseBoolean(String v) {
        if ("yes".equalsIgnoreCase(v) || "on".equalsIgnoreCase(v) || "true".equalsIgnoreCase(v)) {
            return true;
        }
        if ("no".equalsIgnoreCase(v) || "off".equalsIgnoreCase(v) || "false".equalsIgnoreCase(v)) {
            return false;
        }
        throw new Profiler4JError("Invalid boolean value: '" + v + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern getRegex(String s) {
        Map<String, Pattern> map = patternCache;
        synchronized (map) {
            Pattern p = patternCache.get(s);
            if (p != null) {
                return p;
            }
            StringBuilder sb = new StringBuilder("^");
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '*') {
                    sb.append("[a-zA-Z0-9_\\$\\.\\[\\]\\,]*");
                    continue;
                }
                if (c == '.') {
                    sb.append("\\.");
                    continue;
                }
                if (c == '$') {
                    sb.append("\\$");
                    continue;
                }
                if (c == '(') {
                    sb.append("\\(");
                    continue;
                }
                if (c == ')') {
                    sb.append("\\)");
                    continue;
                }
                if (c == ']') {
                    sb.append("\\]");
                    continue;
                }
                if (c == '[') {
                    sb.append("\\[");
                    continue;
                }
                sb.append(c);
            }
            sb.append("$");
            p = Pattern.compile(sb.toString());
            patternCache.put(s, p);
            return p;
        }
    }

    public static List<Rule> parseRules(String rules) {
        ArrayList<Rule> list = new ArrayList<Rule>();
        if (rules != null && rules.trim().length() > 0) {
            for (String s : rules.split("\\s*;\\s*")) {
                list.add(Utils.parseRule(s));
            }
        }
        return list;
    }

    public static Rule parseRule(String s) throws Profiler4JError {
        Matcher m = ruleRegex.matcher(s);
        if (m.matches()) {
            String methodPattern = m.group(1);
            Rule.Action action = "accept".equals(m.group(2)) ? Rule.Action.ACCEPT : Rule.Action.REJECT;
            Map<Rule.Option, String> options = Utils.parseOptions(m.group(3));
            return new Rule(methodPattern, action, options);
        }
        throw new Profiler4JError("Invalid config line: '" + s + "'");
    }

    public static Map<Rule.Option, String> parseOptions(String optionLine) {
        HashMap<Rule.Option, String> options = new HashMap<Rule.Option, String>();
        for (String s : optionLine.split("\\s+")) {
            if (s.length() <= 0) continue;
            boolean valid = false;
            for (OptionParser h : optionHandlers) {
                if (!h.handle(options, s)) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            throw new Profiler4JError("Unknown rule option '" + s + "'");
        }
        return options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptionParser {
        private Rule.Option option;
        private Pattern regex;

        public OptionParser(Rule.Option option, String name, String valuesRegex) {
            this.option = option;
            this.regex = Pattern.compile("^\\-(" + name + "):(" + valuesRegex + ")$");
        }

        public boolean handle(Map<Rule.Option, String> options, String soption) {
            Matcher m = this.regex.matcher(soption);
            if (m.matches()) {
                options.put(this.option, m.group(2));
                return true;
            }
            return false;
        }
    }
}

