/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.message.ChannelData;
import org.ice4j.message.Message;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.ChannelDataEventHandler;
import org.ice4j.stack.Connector;
import org.ice4j.stack.ErrorHandler;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.MessageProcessor;
import org.ice4j.stack.MessageQueue;
import org.ice4j.stack.PeerUdpMessageEventHandler;
import org.ice4j.stack.StunStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NetAccessManager
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(NetAccessManager.class.getName());
    private final Object connectorsSyncRoot = new Object();
    private Map<TransportAddress, Connector> netUDPAccessPoints = new Hashtable<TransportAddress, Connector>();
    private Map<TransportAddress, List<Connector>> netTCPAccessPoints = new Hashtable<TransportAddress, List<Connector>>();
    private final MessageQueue messageQueue = new MessageQueue();
    private Vector<MessageProcessor> messageProcessors = new Vector();
    private final MessageEventHandler messageEventHandler;
    private final PeerUdpMessageEventHandler peerUdpMessageEventHandler;
    private final ChannelDataEventHandler channelDataEventHandler;
    private int initialThreadPoolSize = 3;
    private final StunStack stunStack;

    NetAccessManager(StunStack stunStack) {
        this(stunStack, null, null);
    }

    NetAccessManager(StunStack stunStack, PeerUdpMessageEventHandler peerUdpMessageEventHandler, ChannelDataEventHandler channelDataEventHandler) {
        this.stunStack = stunStack;
        this.messageEventHandler = stunStack;
        this.peerUdpMessageEventHandler = peerUdpMessageEventHandler;
        this.channelDataEventHandler = channelDataEventHandler;
        this.initThreadPool();
    }

    MessageEventHandler getMessageEventHandler() {
        return this.messageEventHandler;
    }

    public PeerUdpMessageEventHandler getUdpMessageEventHandler() {
        return this.peerUdpMessageEventHandler;
    }

    public ChannelDataEventHandler getChannelDataMessageEventHandler() {
        return this.channelDataEventHandler;
    }

    MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    StunStack getStunStack() {
        return this.stunStack;
    }

    @Override
    public void handleError(String message, Throwable error) {
        logger.log(Level.FINE, "The following error occurred with an incoming message:", error);
    }

    @Override
    public void handleFatalError(Runnable callingThread, String message, Throwable error) {
        if (callingThread instanceof Connector) {
            Connector ap = (Connector)callingThread;
            this.removeSocket(ap.getListenAddress(), ap.getRemoteAddress());
            logger.log(Level.WARNING, "Removing connector:" + ap, error);
        } else if (callingThread instanceof MessageProcessor) {
            MessageProcessor mp = (MessageProcessor)callingThread;
            logger.log(Level.WARNING, "A message processor has unexpectedly stopped. AP:" + mp, error);
            mp.stop();
            this.messageProcessors.remove(mp);
            mp = new MessageProcessor(this);
            mp.start();
            logger.fine("A message processor has been relaunched because of an error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSocket(IceSocketWrapper socket) {
        Transport transport = socket.getUDPSocket() != null ? Transport.UDP : Transport.TCP;
        TransportAddress localAddr = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), transport);
        Object object = this.connectorsSyncRoot;
        synchronized (object) {
            switch (transport) {
                case UDP: {
                    if (this.netUDPAccessPoints.containsKey(localAddr)) break;
                    Connector connector = new Connector(socket, this.messageQueue, this);
                    this.netUDPAccessPoints.put(localAddr, connector);
                    connector.start();
                    break;
                }
                case TCP: {
                    Socket tcpSocket;
                    Connector connector;
                    List<Connector> connectors = this.netTCPAccessPoints.get(localAddr);
                    if (connectors == null) {
                        connectors = new LinkedList<Connector>();
                        this.netTCPAccessPoints.put(localAddr, connectors);
                    }
                    if ((connector = this.findTCPConnectorByRemoteAddress(connectors, new TransportAddress((tcpSocket = socket.getTCPSocket()).getInetAddress(), tcpSocket.getPort(), Transport.TCP))) != null) break;
                    connector = new Connector(socket, this.messageQueue, this);
                    connectors.add(connector);
                    connector.start();
                }
            }
        }
    }

    private Connector findTCPConnectorByRemoteAddress(List<Connector> list, TransportAddress dst) {
        if (dst == null) {
            return null;
        }
        for (Connector connector : list) {
            if (!dst.equals(connector.getRemoteAddress())) continue;
            return connector;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocket(TransportAddress src, TransportAddress dst) {
        Connector connector = null;
        Object object = this.connectorsSyncRoot;
        synchronized (object) {
            switch (src.getTransport()) {
                case UDP: {
                    connector = this.netUDPAccessPoints.remove(src);
                    break;
                }
                case TCP: {
                    List<Connector> connectors = this.netTCPAccessPoints.remove(src);
                    if (connectors == null || (connector = this.findTCPConnectorByRemoteAddress(connectors, dst)) == null) break;
                    connectors.remove(connector);
                    if (!connectors.isEmpty()) break;
                    this.netTCPAccessPoints.remove(src);
                }
            }
        }
        if (connector != null) {
            connector.stop();
        }
    }

    public void stop() {
        for (MessageProcessor mp : this.messageProcessors) {
            mp.stop();
        }
    }

    void setThreadPoolSize(int threadPoolSize) throws IllegalArgumentException {
        if (threadPoolSize < 1) {
            throw new IllegalArgumentException(threadPoolSize + " is not a legal thread pool size value.");
        }
        if (this.messageProcessors.size() < threadPoolSize) {
            this.fillUpThreadPool(threadPoolSize);
        } else {
            this.shrinkThreadPool(threadPoolSize);
        }
    }

    private void initThreadPool() {
        this.fillUpThreadPool(this.initialThreadPoolSize);
    }

    private void fillUpThreadPool(int newSize) {
        this.messageProcessors.ensureCapacity(newSize);
        for (int i = this.messageProcessors.size(); i < newSize; ++i) {
            MessageProcessor mp = new MessageProcessor(this);
            this.messageProcessors.add(mp);
            mp.start();
        }
    }

    private void shrinkThreadPool(int newSize) {
        while (this.messageProcessors.size() > newSize) {
            MessageProcessor mp = this.messageProcessors.remove(0);
            mp.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connector getConnector(TransportAddress src, TransportAddress dst) {
        Object object = this.connectorsSyncRoot;
        synchronized (object) {
            switch (src.getTransport()) {
                case UDP: {
                    return this.netUDPAccessPoints.get(src);
                }
                case TCP: {
                    List<Connector> connectors = this.netTCPAccessPoints.get(src);
                    if (connectors == null) break;
                    return this.findTCPConnectorByRemoteAddress(connectors, dst);
                }
            }
        }
        return null;
    }

    void sendMessage(Message stunMessage, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException {
        byte[] bytes = stunMessage.encode(this.stunStack);
        Connector ap = this.getConnector(srcAddr, remoteAddr);
        if (ap == null) {
            throw new IllegalArgumentException("No socket has been added for: " + srcAddr + " <-> " + remoteAddr);
        }
        ap.sendMessage(bytes, remoteAddr);
    }

    void sendMessage(ChannelData channelData, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException, StunException {
        byte[] bytes = channelData.encode();
        Connector ap = this.getConnector(srcAddr, remoteAddr);
        if (ap == null) {
            throw new IllegalArgumentException("No socket has been added for source address: " + srcAddr);
        }
        ap.sendMessage(bytes, remoteAddr);
    }

    void sendMessage(byte[] bytes, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException, StunException {
        Connector ap = this.getConnector(srcAddr, remoteAddr);
        if (ap == null) {
            throw new IllegalArgumentException("No socket has been added for source address: " + srcAddr);
        }
        ap.sendMessage(bytes, remoteAddr);
    }
}

