/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public abstract class IceControlAttribute
extends Attribute {
    static final char DATA_LENGTH_ICE_CONTROL = '\b';
    long tieBreaker;
    boolean isControlling;

    IceControlAttribute(boolean isControlling) {
        super(isControlling ? (char)'\u802a' : '\u8029');
        this.isControlling = isControlling;
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        char c = offset;
        char c2 = offset = (char)(offset + '\u0001');
        char c3 = offset = (char)(offset + '\u0001');
        char c4 = offset = (char)(offset + '\u0001');
        char c5 = offset = (char)(offset + '\u0001');
        char c6 = offset = (char)(offset + '\u0001');
        char c7 = offset = (char)(offset + '\u0001');
        char c8 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        this.tieBreaker = ((long)attributeValue[c] & 0xFFL) << 56 | ((long)attributeValue[c2] & 0xFFL) << 48 | ((long)attributeValue[c3] & 0xFFL) << 40 | ((long)attributeValue[c4] & 0xFFL) << 32 | ((long)attributeValue[c5] & 0xFFL) << 24 | ((long)attributeValue[c6] & 0xFFL) << 16 | ((long)attributeValue[c7] & 0xFFL) << 8 | (long)attributeValue[c8] & 0xFFL;
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = (byte)((this.tieBreaker & 0xFF00000000000000L) >> 56);
        binValue[5] = (byte)((this.tieBreaker & 0xFF000000000000L) >> 48);
        binValue[6] = (byte)((this.tieBreaker & 0xFF0000000000L) >> 40);
        binValue[7] = (byte)((this.tieBreaker & 0xFF00000000L) >> 32);
        binValue[8] = (byte)((this.tieBreaker & 0xFF000000L) >> 24);
        binValue[9] = (byte)((this.tieBreaker & 0xFF0000L) >> 16);
        binValue[10] = (byte)((this.tieBreaker & 0xFF00L) >> 8);
        binValue[11] = (byte)(this.tieBreaker & 0xFFL);
        return binValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IceControlAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IceControlAttribute iceControlAtt = (IceControlAttribute)obj;
        return iceControlAtt.getAttributeType() == this.getAttributeType() && iceControlAtt.isControlling == this.isControlling && iceControlAtt.getDataLength() == '\b' && this.getTieBreaker() == iceControlAtt.getTieBreaker();
    }

    public char getDataLength() {
        return '\b';
    }

    public String getName() {
        return this.isControlling ? "ICE-CONTROLLING" : "ICE-CONTROLLED";
    }

    public void setTieBreaker(long tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    public long getTieBreaker() {
        return this.tieBreaker;
    }
}

