/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.util.ArrayList;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;
import org.apache.commons.lang3.StringEscapeUtils;

public class MediathekSwr
extends MediathekReader
implements Runnable {
    private static final int wartenKurz = 2000;
    private static final int wartenLang = 4000;
    public static final String SENDERNAME = "SWR";

    public MediathekSwr(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 4000, startPrio);
    }

    @Override
    public synchronized void addToList() {
        this.meldungStart();
        this.listeThemen.clear();
        this.addToList__();
        if (MSConfig.loadLongMax()) {
            this.addToList_verpasst();
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void addToList__() {
        String MUSTER_START = "<div class=\"mediaCon\">";
        String MUSTER_STOPP = "<h2 class=\"rasterHeadline\">OFT GESUCHT</h2>";
        String MUSTER_URL = "<a href=\"tvshow.htm?show=";
        String MUSTER_THEMA = "title=\"";
        MSStringBuilder strSeite = new MSStringBuilder(65536);
        strSeite = this.getUrlIo.getUri(SENDERNAME, "http://swrmediathek.de/tvlist.htm", "UTF-8", 2, strSeite, "");
        int pos = 0;
        int stop = strSeite.indexOf("<h2 class=\"rasterHeadline\">OFT GESUCHT</h2>");
        while (!(MSConfig.getStop() || (pos = strSeite.indexOf("<div class=\"mediaCon\">", pos)) == -1 || stop > 0 && pos > stop)) {
            String url = strSeite.extract("<a href=\"tvshow.htm?show=", "\"", pos += "<div class=\"mediaCon\">".length());
            String thema = strSeite.extract("title=\"", "\"", pos);
            if ((thema = StringEscapeUtils.unescapeHtml4(thema.trim())).isEmpty()) {
                MSLog.fehlerMeldung(915263078, "kein Thema");
            }
            if (url.isEmpty()) {
                MSLog.fehlerMeldung(163255009, "keine URL");
                continue;
            }
            String[] add = new String[]{"http://swrmediathek.de/tvshow.htm?show=" + url, thema};
            this.listeThemen.addUrl(add);
        }
    }

    private void addToList_verpasst() {
        MSStringBuilder strSeite = new MSStringBuilder(65536);
        strSeite = this.getUrlIo.getUri(SENDERNAME, "http://swrmediathek.de/sendungverpasst.htm", "UTF-8", 2, strSeite, "");
        ArrayList<String> list = new ArrayList<String>();
        strSeite.extractList("<ul class=\"progChannelList\" tabindex=\"-1\">", "<div class=\"box mediBoxBorder\"", "<a href=\"sendungverpasst.htm?show=&date=", "\"", "http://www.swrmediathek.de/sendungverpasst.htm?show=&date=", list);
        for (String s : list) {
            String[] add = new String[]{s, ""};
            this.listeThemen.addUrl(add);
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrlThemaLaden = new MSGetUrl(MSConfig.loadLongMax() ? 4000L : 2000L);
        private MSStringBuilder strSeite1 = new MSStringBuilder(65536);
        private MSStringBuilder strSeite2 = new MSStringBuilder(65536);
        ArrayList<String> gefunden = new ArrayList();
        static final String PATTERN_END = "\"";
        static final String HTTP = "http";

        @Override
        public void run() {
            try {
                String[] link;
                MediathekSwr.this.meldungAddThread();
                while (!MSConfig.getStop() && (link = MediathekSwr.this.listeThemen.getListeThemen()) != null) {
                    this.themenSeitenSuchen(link[0], link[1]);
                    MediathekSwr.this.meldungProgress(link[0]);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(739285690, ex);
            }
            MediathekSwr.this.meldungThreadUndFertig();
        }

        private void themenSeitenSuchen(String strUrlFeed, String thema) {
            String MUSTER_URL = "<a href=\"/player.htm?show=";
            this.strSeite1 = this.getUrlThemaLaden.getUri(MediathekSwr.SENDERNAME, strUrlFeed, "UTF-8", 2, this.strSeite1, thema);
            if (this.strSeite1.length() == 0) {
                MSLog.fehlerMeldung(945120365, "Seite leer: " + strUrlFeed);
                return;
            }
            MediathekSwr.this.meldung(strUrlFeed);
            int pos1 = 0;
            int max = 0;
            this.gefunden.clear();
            while (!MSConfig.getStop() && (pos1 = this.strSeite1.indexOf("<a href=\"/player.htm?show=", pos1)) != -1 && !(MSConfig.loadLongMax() ? ++max > 20 : ++max > 2)) {
                int pos2 = this.strSeite1.indexOf(PATTERN_END, pos1 += "<a href=\"/player.htm?show=".length());
                if (pos2 == -1) continue;
                String url = this.strSeite1.substring(pos1, pos2);
                if (this.gefunden.contains(url)) {
                    if (max <= 0) continue;
                    --max;
                    continue;
                }
                this.gefunden.add(url);
                if (url.equals("")) {
                    MSLog.fehlerMeldung(875012369, "keine URL, Thema: " + thema);
                    continue;
                }
                url = "http://swrmediathek.de/AjaxEntry?callback=jsonp1347979401564&ekey=" + url;
                this.json(strUrlFeed, thema, url);
            }
            this.gefunden.clear();
        }

        private void json(String strUrlFeed, String thema, String urlJson) {
            try {
                this.strSeite2 = this.getUrlThemaLaden.getUri_Utf(MediathekSwr.SENDERNAME, urlJson, this.strSeite2, "");
                if (this.strSeite2.length() == 0) {
                    MSLog.fehlerMeldung(912365478, "Seite leer: " + urlJson);
                    return;
                }
                String title = this.getTitle();
                String date = this.getDate();
                String time = this.getTime();
                String description = this.getDescription();
                long duration = this.getDuration();
                String urldHd = this.getHDUrl();
                String normalUrl = this.getNormalUrl();
                String smallUrl = this.getSmallUrl();
                String rtmpUrl = this.getRtmpUrl();
                String subtitle = this.strSeite2.extract("\"entry_capuri\":\"", PATTERN_END);
                if (thema.isEmpty()) {
                    thema = this.strSeite2.extract("\"group_title\":\"", PATTERN_END);
                }
                if (normalUrl.isEmpty() && smallUrl.isEmpty() && rtmpUrl.isEmpty()) {
                    MSLog.fehlerMeldung(203690478, thema + " NO normal and small url:  " + urlJson);
                } else {
                    if (normalUrl.isEmpty() && !smallUrl.isEmpty()) {
                        normalUrl = smallUrl;
                    } else if (normalUrl.isEmpty()) {
                        normalUrl = rtmpUrl;
                    }
                    if (smallUrl.isEmpty()) {
                        smallUrl = this.getSuperSmalUrl();
                    }
                    DatenFilm film = new DatenFilm(MediathekSwr.SENDERNAME, thema, strUrlFeed, title, normalUrl, "", date, time, duration, description);
                    if (!urldHd.isEmpty()) {
                        film.addUrlHd(urldHd, "");
                    }
                    if (!smallUrl.isEmpty()) {
                        film.addUrlKlein(smallUrl, "");
                    }
                    if (!subtitle.isEmpty()) {
                        film.addUrlSubtitle(subtitle);
                    }
                    MediathekSwr.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(939584720, thema + " " + urlJson);
            }
        }

        private String getTitle() {
            String PATTERN_TITLE_START = "\"entry_title\":\"";
            return this.strSeite2.extract("\"entry_title\":\"", PATTERN_END);
        }

        private String getDescription() {
            String PATTERN_DESCRIPTION_START = "\"entry_descl\":\"";
            return this.strSeite2.extract("\"entry_descl\":\"", PATTERN_END);
        }

        private String getDate() {
            String PATTERN_DATE_START = "\"entry_pdatehd\":\"";
            String datum = this.strSeite2.extract("\"entry_pdatehd\":\"", PATTERN_END);
            if (datum.length() < 10) {
                if (datum.contains(".") && datum.substring(0, datum.indexOf(".")).length() != 2) {
                    datum = "0" + datum;
                }
                if (datum.indexOf(".") != datum.lastIndexOf(".") && datum.substring(datum.indexOf(".") + 1, datum.lastIndexOf(".")).length() != 2) {
                    datum = datum.substring(0, datum.indexOf(".") + 1) + "0" + datum.substring(datum.indexOf(".") + 1);
                }
            }
            return datum;
        }

        private long getDuration() {
            String PATTERN_DURATION_START = "\"entry_durat\":\"";
            String dur = null;
            long duration = 0L;
            try {
                dur = this.strSeite2.extract("\"entry_durat\":\"", PATTERN_END);
                if (!dur.isEmpty()) {
                    String[] parts = dur.split(":");
                    long power = 1L;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        duration += Long.parseLong(parts[i]) * power;
                        power *= 60L;
                    }
                }
            }
            catch (NumberFormatException ex) {
                MSLog.fehlerMeldung(679012497, "duration: " + (dur == null ? " " : Long.valueOf(duration)));
            }
            return duration;
        }

        private String getTime() {
            String PATTERN_TIME_START = "\"entry_pdateht\":\"";
            String tmp = "";
            String time = this.strSeite2.extract("\"entry_pdateht\":\"", PATTERN_END);
            if (time.length() <= 5) {
                time = time.trim() + ":00";
            }
            if ((time = time.replace(".", ":")).length() < 8) {
                if (time.contains(":") && (tmp = time.substring(0, time.indexOf(":"))).length() != 2) {
                    time = "0" + time;
                }
                if (time.indexOf(":") != time.lastIndexOf(":") && (tmp = time.substring(time.indexOf(":") + 1, time.lastIndexOf(":"))).length() != 2) {
                    time = time.substring(0, time.indexOf(":") + 1) + "0" + time + time.substring(time.lastIndexOf(":"));
                }
            }
            return time;
        }

        private String getHDUrl() {
            String PATTTERN_PROT_HTTP_HD = "\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"4\",\"val2\":\"http";
            String urlWithOutprot = this.strSeite2.extract("\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"4\",\"val2\":\"http", PATTERN_END);
            if (urlWithOutprot.isEmpty()) {
                return "";
            }
            return HTTP + urlWithOutprot;
        }

        private String getNormalUrl() {
            String PATTTERN_PROT_HTTP_L = "\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"3\",\"val2\":\"http";
            String urlWithOutprot = this.strSeite2.extract("\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"3\",\"val2\":\"http", PATTERN_END);
            if (urlWithOutprot.isEmpty()) {
                return "";
            }
            return HTTP + urlWithOutprot;
        }

        private String getRtmpUrl() {
            String PATTERN_1 = "\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"3\",\"val2\":\"rtmp";
            String PATTERN_2 = "entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"2\",\"val2\":\"rtmp";
            String urlWithOutprot = this.strSeite2.extract("\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"3\",\"val2\":\"rtmp", PATTERN_END);
            if (urlWithOutprot.isEmpty() && (urlWithOutprot = this.strSeite2.extract("entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"2\",\"val2\":\"rtmp", PATTERN_END)).isEmpty()) {
                return "";
            }
            return "rtmp" + urlWithOutprot;
        }

        private String getSmallUrl() {
            String PATTTERN_PROT_HTTP_M = "\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"2\",\"val2\":\"http";
            String urlWithOutprot = this.strSeite2.extract("\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"2\",\"val2\":\"http", PATTERN_END);
            if (urlWithOutprot.isEmpty()) {
                return "";
            }
            return HTTP + urlWithOutprot;
        }

        private String getSuperSmalUrl() {
            String PATTTERN_PROT_HTTP_S = "\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"1\",\"val2\":\"http";
            String urlWithOutprot = this.strSeite2.extract("\"entry_media\",\"attr\":{\"val0\":\"h264\",\"val1\":\"1\",\"val2\":\"http", PATTERN_END);
            return HTTP + urlWithOutprot;
        }
    }
}

