/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.UrlHyperlinkAction;
import org.jdesktop.swingx.JXHyperlink;

public class PanelProgrammPfade
extends JPanel {
    public JDialog dialog = null;
    private final boolean vlc;
    private final boolean flvstreamer;
    private final boolean ffmpeg;
    private final JFrame parentComponent;
    private JButton jButtonFFmpegPfad;
    private JButton jButtonFFmpegSuchen;
    private JButton jButtonFlvPfad;
    private JButton jButtonFlvSuchen;
    private JButton jButtonHilfe;
    private JButton jButtonVlcPfad;
    private JButton jButtonVlcSuchen;
    private JLabel jLabel4;
    private JPanel jPanelFFmpeg;
    private JPanel jPanelFlv;
    private JPanel jPanelVlc;
    private JTextField jTextFieldFFmpeg;
    private JTextField jTextFieldFlv;
    private JTextField jTextFieldVlc;
    private JXHyperlink jXHyperlinkFFmpeg;
    private JXHyperlink jXHyperlinkVlc;
    private JXHyperlink jXHyperlinkflvstreamer;

    public PanelProgrammPfade(JFrame parentFrame, boolean vvlc, boolean fflvstreamer, boolean fffmpeg) {
        this.initComponents();
        this.vlc = vvlc;
        this.flvstreamer = fflvstreamer;
        this.ffmpeg = fffmpeg;
        this.parentComponent = parentFrame;
        this.init();
        this.initBeob();
    }

    private void init() {
        this.jButtonVlcPfad.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonFlvPfad.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonHilfe.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jPanelVlc.setVisible(this.vlc);
        this.jPanelFlv.setVisible(this.flvstreamer);
        this.jPanelFFmpeg.setVisible(this.ffmpeg);
        if (Daten.mVConfig.get("pfad-vlc").equals("")) {
            Daten.mVConfig.add("pfad-vlc", GuiFunktionenProgramme.getMusterPfadVlc());
        }
        if (Daten.mVConfig.get("pfad-flvstreamer").equals("")) {
            Daten.mVConfig.add("pfad-flvstreamer", GuiFunktionenProgramme.getMusterPfadFlv());
        }
        if (Daten.mVConfig.get("pfad-ffmpeg").equals("")) {
            Daten.mVConfig.add("pfad-ffmpeg", GuiFunktionenProgramme.getMusterPfadFFmpeg());
        }
        this.jTextFieldVlc.setText(Daten.mVConfig.get("pfad-vlc"));
        this.jTextFieldFlv.setText(Daten.mVConfig.get("pfad-flvstreamer"));
        this.jTextFieldFFmpeg.setText(Daten.mVConfig.get("pfad-ffmpeg"));
    }

    private void initBeob() {
        this.jTextFieldVlc.getDocument().addDocumentListener(new BeobDoc());
        this.jTextFieldFlv.getDocument().addDocumentListener(new BeobDoc());
        this.jTextFieldFFmpeg.getDocument().addDocumentListener(new BeobDoc());
        try {
            this.jXHyperlinkVlc.setText("http://www.videolan.org");
            this.jXHyperlinkVlc.setAction((Action)new UrlHyperlinkAction(this.parentComponent, "http://www.videolan.org"));
            this.jXHyperlinkflvstreamer.setText("https://savannah.nongnu.org/projects/flvstreamer");
            this.jXHyperlinkflvstreamer.setAction((Action)new UrlHyperlinkAction(this.parentComponent, "https://savannah.nongnu.org/projects/flvstreamer"));
            this.jXHyperlinkFFmpeg.setText("http://ffmpeg.org");
            this.jXHyperlinkFFmpeg.setAction((Action)new UrlHyperlinkAction(this.parentComponent, "http://ffmpeg.org"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.jButtonVlcPfad.addActionListener(new BeobPfad(this.jTextFieldVlc));
        this.jButtonFlvPfad.addActionListener(new BeobPfad(this.jTextFieldFlv));
        this.jButtonFFmpegPfad.addActionListener(new BeobPfad(this.jTextFieldFFmpeg));
        this.jButtonVlcSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("pfad-vlc", "");
                PanelProgrammPfade.this.jTextFieldVlc.setText(GuiFunktionenProgramme.getMusterPfadVlc());
            }
        });
        this.jButtonFlvSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("pfad-flvstreamer", "");
                PanelProgrammPfade.this.jTextFieldFlv.setText(GuiFunktionenProgramme.getMusterPfadFlv());
            }
        });
        this.jButtonFFmpegSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("pfad-ffmpeg", "");
                PanelProgrammPfade.this.jTextFieldFFmpeg.setText(GuiFunktionenProgramme.getMusterPfadFFmpeg());
            }
        });
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelProgrammPfade.this.parentComponent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_STANDARD_PSET)).setVisible(true);
            }
        });
    }

    private void check() {
        Daten.mVConfig.add("pfad-vlc", this.jTextFieldVlc.getText());
        Daten.mVConfig.add("pfad-flvstreamer", this.jTextFieldFlv.getText());
        Daten.mVConfig.add("pfad-ffmpeg", this.jTextFieldFFmpeg.getText());
        try {
            if (this.jTextFieldVlc.getText().equals("")) {
                this.jTextFieldVlc.setBackground(new Color(255, 200, 200));
            } else if (!new File(Daten.mVConfig.get("pfad-vlc")).exists()) {
                this.jTextFieldVlc.setBackground(new Color(255, 200, 200));
            } else {
                this.jTextFieldVlc.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        }
        catch (Exception ex) {
            this.jTextFieldVlc.setBackground(new Color(255, 200, 200));
        }
        try {
            if (this.jTextFieldFlv.getText().equals("")) {
                this.jTextFieldFlv.setBackground(new Color(255, 200, 200));
            } else if (!new File(Daten.mVConfig.get("pfad-flvstreamer")).exists()) {
                this.jTextFieldFlv.setBackground(new Color(255, 200, 200));
            } else {
                this.jTextFieldFlv.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        }
        catch (Exception ex) {
            this.jTextFieldFlv.setBackground(new Color(255, 200, 200));
        }
        try {
            if (this.jTextFieldFFmpeg.getText().equals("")) {
                this.jTextFieldFFmpeg.setBackground(new Color(255, 200, 200));
            } else if (!new File(Daten.mVConfig.get("pfad-ffmpeg")).exists()) {
                this.jTextFieldFFmpeg.setBackground(new Color(255, 200, 200));
            } else {
                this.jTextFieldFFmpeg.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        }
        catch (Exception ex) {
            this.jTextFieldFFmpeg.setBackground(new Color(255, 200, 200));
        }
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel1 = new JPanel();
        this.jPanelVlc = new JPanel();
        this.jTextFieldVlc = new JTextField();
        this.jButtonVlcPfad = new JButton();
        this.jButtonVlcSuchen = new JButton();
        JLabel jLabel1 = new JLabel();
        this.jXHyperlinkVlc = new JXHyperlink();
        this.jPanelFlv = new JPanel();
        this.jTextFieldFlv = new JTextField();
        this.jButtonFlvPfad = new JButton();
        this.jButtonFlvSuchen = new JButton();
        JLabel jLabel2 = new JLabel();
        this.jXHyperlinkflvstreamer = new JXHyperlink();
        this.jButtonHilfe = new JButton();
        this.jPanelFFmpeg = new JPanel();
        this.jTextFieldFFmpeg = new JTextField();
        this.jButtonFFmpegSuchen = new JButton();
        this.jButtonFFmpegPfad = new JButton();
        this.jLabel4 = new JLabel();
        this.jXHyperlinkFFmpeg = new JXHyperlink();
        this.jPanelVlc.setBorder(BorderFactory.createTitledBorder("Pfad zum VLC-Player ausw\u00e4hlen"));
        this.jButtonVlcPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonVlcSuchen.setText("suchen");
        jLabel1.setText("Website:");
        this.jXHyperlinkVlc.setText("http://www.videolan.org/");
        GroupLayout jPanelVlcLayout = new GroupLayout(this.jPanelVlc);
        this.jPanelVlc.setLayout(jPanelVlcLayout);
        jPanelVlcLayout.setHorizontalGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelVlcLayout.createSequentialGroup().addContainerGap().addGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelVlcLayout.createSequentialGroup().addComponent(this.jTextFieldVlc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonVlcPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonVlcSuchen)).addGroup(jPanelVlcLayout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jXHyperlinkVlc, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelVlcLayout.setVerticalGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelVlcLayout.createSequentialGroup().addContainerGap().addGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldVlc, -2, -1, -2).addComponent(this.jButtonVlcPfad).addComponent(this.jButtonVlcSuchen)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent((Component)this.jXHyperlinkVlc, -2, -1, -2)).addContainerGap()));
        jPanelVlcLayout.linkSize(1, this.jButtonVlcPfad, this.jTextFieldVlc);
        this.jPanelFlv.setBorder(BorderFactory.createTitledBorder("Pfad zum flvstreamer ausw\u00e4hlen"));
        this.jButtonFlvPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonFlvSuchen.setText("suchen");
        jLabel2.setText("Website:");
        this.jXHyperlinkflvstreamer.setText("https://savannah.nongnu.org/projects/flvstreamer");
        GroupLayout jPanelFlvLayout = new GroupLayout(this.jPanelFlv);
        this.jPanelFlv.setLayout(jPanelFlvLayout);
        jPanelFlvLayout.setHorizontalGroup(jPanelFlvLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFlvLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFlvLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFlvLayout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jXHyperlinkflvstreamer, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanelFlvLayout.createSequentialGroup().addComponent(this.jTextFieldFlv).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFlvPfad))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFlvSuchen).addContainerGap()));
        jPanelFlvLayout.setVerticalGroup(jPanelFlvLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFlvLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanelFlvLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldFlv, -2, -1, -2).addComponent(this.jButtonFlvPfad).addComponent(this.jButtonFlvSuchen)).addGap(18, 18, 18).addGroup(jPanelFlvLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent((Component)this.jXHyperlinkflvstreamer, -2, -1, -2)).addContainerGap()));
        jPanelFlvLayout.linkSize(1, this.jButtonFlvPfad, this.jTextFieldFlv);
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jPanelFFmpeg.setBorder(BorderFactory.createTitledBorder("Pfad zu ffmpeg ausw\u00e4hlen"));
        this.jButtonFFmpegSuchen.setText("suchen");
        this.jButtonFFmpegPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jLabel4.setText("Website:");
        this.jXHyperlinkFFmpeg.setText("http://ffmpeg.org");
        GroupLayout jPanelFFmpegLayout = new GroupLayout(this.jPanelFFmpeg);
        this.jPanelFFmpeg.setLayout(jPanelFFmpegLayout);
        jPanelFFmpegLayout.setHorizontalGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFFmpegLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFFmpegLayout.createSequentialGroup().addComponent(this.jTextFieldFFmpeg).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFFmpegPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFFmpegSuchen)).addGroup(jPanelFFmpegLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jXHyperlinkFFmpeg, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelFFmpegLayout.setVerticalGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFFmpegLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldFFmpeg, -2, -1, -2).addComponent(this.jButtonFFmpegPfad).addComponent(this.jButtonFFmpegSuchen)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.jXHyperlinkFFmpeg, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelFFmpegLayout.linkSize(1, this.jButtonFFmpegPfad, this.jButtonFFmpegSuchen, this.jTextFieldFFmpeg);
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelFlv, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelVlc, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHilfe)).addComponent(this.jPanelFFmpeg, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelVlc, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFlv, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFFmpeg, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addComponent(this.jButtonHilfe).addContainerGap()));
        jScrollPane1.setViewportView(jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1).addContainerGap()));
    }

    private class BeobPfad
    implements ActionListener {
        private final JTextField textField;

        public BeobPfad(JTextField ttextField) {
            this.textField = ttextField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog((Frame)PanelProgrammPfade.this.parentComponent, "Programmdatei ausw\u00e4hlen");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        this.textField.setText(new File(chooser.getDirectory() + chooser.getFile()).getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(306087945, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                if (this.textField.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(GuiFunktionen.getHomePath()));
                } else {
                    chooser.setCurrentDirectory(new File(this.textField.getText()));
                }
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(643289561, ex);
                    }
                }
            }
        }
    }

    private class BeobDoc
    implements DocumentListener {
        private BeobDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelProgrammPfade.this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelProgrammPfade.this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelProgrammPfade.this.check();
        }
    }
}

