/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenPset;
import mediathek.res.GetIcon;
import mediathek.tool.EscBeenden;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVColor;
import mediathek.tool.MVFunction;
import mediathek.tool.MVMessageDialog;
import msearch.daten.DatenFilm;

public class DialogAddDownload
extends JDialog {
    private DatenPset pSet = null;
    private boolean ok = false;
    private DatenDownload datenDownload = null;
    private final Daten daten;
    private final DatenFilm datenFilm;
    private String orgPfad = "";
    private String aufloesung = "";
    private String dateiGroesse_HD = "";
    private String dateiGroesse_Hoch = "";
    private String dateiGroesse_Klein = "";
    private boolean nameGeaendert = false;
    private boolean stopBeob = false;
    private JTextComponent cbPathTextComponent = null;
    private final TitledBorder filmBorder;
    private static final String TITLED_BORDER_STRING = "Film laden";
    private JButton jButtonAbbrechen;
    private JButton jButtonDelHistory;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JCheckBox jCheckBoxInfodatei;
    private JCheckBox jCheckBoxPfadSpeichern;
    private JCheckBox jCheckBoxStarten;
    private JCheckBox jCheckBoxSubtitle;
    private JComboBox<String> jComboBoxPfad;
    private JComboBox<String> jComboBoxPset;
    private JLabel jLabelSet;
    private JPanel jPanelSize;
    private JRadioButton jRadioButtonAufloesungHd;
    private JRadioButton jRadioButtonAufloesungHoch;
    private JRadioButton jRadioButtonAufloesungKlein;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSender;

    public DialogAddDownload(Frame parent, Daten daten, DatenFilm film, DatenPset pSet, String aufloesung) {
        super(parent, true);
        this.initComponents();
        this.filmBorder = (TitledBorder)this.jPanelSize.getBorder();
        this.cbPathTextComponent = (JTextComponent)this.jComboBoxPfad.getEditor().getEditorComponent();
        this.aufloesung = aufloesung;
        this.daten = daten;
        this.datenFilm = film;
        this.pSet = pSet;
        this.init();
        this.packIt();
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
    }

    private void packIt() {
        int w = this.getWidth();
        this.pack();
        this.setSize(w, this.getHeight());
    }

    private void init() {
        this.jComboBoxPset.setModel(new DefaultComboBoxModel<String>(Daten.listePset.getListeSpeichern().getObjectDataCombo()));
        this.jCheckBoxStarten.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Dialog-Download-D-Starten")));
        this.jCheckBoxStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Dialog-Download-D-Starten", String.valueOf(DialogAddDownload.this.jCheckBoxStarten.isSelected()));
            }
        });
        this.jButtonZiel.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        if (Daten.listePset.getListeSpeichern().size() == 0) {
            this.ok = false;
            this.beenden();
        }
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogAddDownload.this.check()) {
                    DialogAddDownload.this.beenden();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonOk);
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogAddDownload.this.ok = false;
                DialogAddDownload.this.beenden();
            }
        };
        this.jButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogAddDownload.this.ok = false;
                DialogAddDownload.this.beenden();
            }
        });
        if (this.pSet != null) {
            this.jComboBoxPset.setSelectedItem(this.pSet.arr[0]);
        } else {
            this.pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(this.jComboBoxPset.getSelectedIndex());
        }
        if (Daten.listePset.getListeSpeichern().size() == 1) {
            this.jLabelSet.setVisible(false);
            this.jComboBoxPset.setVisible(false);
            this.jComboBoxPset.setEnabled(false);
        } else {
            this.jComboBoxPset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogAddDownload.this.setupResolutionButtons();
                }
            });
        }
        this.jTextFieldSender.setText(" " + this.datenFilm.arr[1] + ":   " + this.datenFilm.arr[3]);
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    if (!DialogAddDownload.this.jTextFieldName.getText().equals(FilenameUtils.checkDateiname(DialogAddDownload.this.jTextFieldName.getText(), false))) {
                        DialogAddDownload.this.jTextFieldName.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                    } else {
                        DialogAddDownload.this.jTextFieldName.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                    }
                }
            }
        });
        this.cbPathTextComponent.setOpaque(true);
        this.cbPathTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    String s = DialogAddDownload.this.cbPathTextComponent.getText();
                    if (!s.equals(FilenameUtils.checkDateiname(s, true))) {
                        DialogAddDownload.this.jComboBoxPfad.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
                    } else {
                        DialogAddDownload.this.jComboBoxPfad.getEditor().getEditorComponent().setBackground(Color.WHITE);
                    }
                    DialogAddDownload.this.calculateAndCheckDiskSpace();
                }
            }
        });
        this.jRadioButtonAufloesungHd.addActionListener(new BeobRadio());
        this.jRadioButtonAufloesungKlein.addActionListener(new BeobRadio());
        this.jRadioButtonAufloesungHoch.addActionListener(new BeobRadio());
        this.jRadioButtonAufloesungHd.setEnabled(!this.datenFilm.arr[20].isEmpty());
        this.jRadioButtonAufloesungKlein.setEnabled(!this.datenFilm.arr[18].isEmpty());
        this.jRadioButtonAufloesungHoch.setSelected(true);
        if (this.jRadioButtonAufloesungHd.isEnabled()) {
            this.dateiGroesse_HD = this.datenFilm.getDateigroesse(this.datenFilm.getUrlFuerAufloesung("hd"));
            if (!this.dateiGroesse_HD.isEmpty()) {
                this.jRadioButtonAufloesungHd.setText(this.jRadioButtonAufloesungHd.getText() + "   [ " + this.dateiGroesse_HD + " MB ]");
            }
        }
        this.dateiGroesse_Hoch = this.datenFilm.getDateigroesse(this.datenFilm.arr[12]);
        if (!this.dateiGroesse_Hoch.isEmpty()) {
            this.jRadioButtonAufloesungHoch.setText(this.jRadioButtonAufloesungHoch.getText() + "   [ " + this.dateiGroesse_Hoch + " MB ]");
        }
        if (this.jRadioButtonAufloesungKlein.isEnabled()) {
            this.dateiGroesse_Klein = this.datenFilm.getDateigroesse(this.datenFilm.getUrlFuerAufloesung("klein"));
            if (!this.dateiGroesse_Klein.isEmpty()) {
                this.jRadioButtonAufloesungKlein.setText(this.jRadioButtonAufloesungKlein.getText() + "   [ " + this.dateiGroesse_Klein + " MB ]");
            }
        }
        this.jButtonDelHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Pfade-zum-Speichern", "");
                DialogAddDownload.this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{DialogAddDownload.this.orgPfad}));
            }
        });
        this.jCheckBoxPfadSpeichern.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Letzen-Pfad-anzeigen")));
        this.jCheckBoxPfadSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Letzen-Pfad-anzeigen", Boolean.toString(DialogAddDownload.this.jCheckBoxPfadSpeichern.isSelected()));
            }
        });
        this.setupResolutionButtons();
        this.calculateAndCheckDiskSpace();
        this.nameGeaendert = false;
    }

    private void setNameFilm() {
        if (!this.nameGeaendert) {
            this.stopBeob = true;
            this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, "", "", this.getFilmResolution());
            if (this.datenDownload.arr[27].equals("")) {
                this.jTextFieldName.setEnabled(false);
                this.jComboBoxPfad.setEnabled(false);
                this.jButtonZiel.setEnabled(false);
                this.jTextFieldName.setText("");
                this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            } else {
                this.jTextFieldName.setEnabled(true);
                this.jComboBoxPfad.setEnabled(true);
                this.jButtonZiel.setEnabled(true);
                this.jTextFieldName.setText(this.datenDownload.arr[27]);
                this.setModelPfad(this.datenDownload.arr[28]);
                this.orgPfad = this.datenDownload.arr[28];
            }
            this.stopBeob = false;
        }
    }

    private long getFreeDiskSpace(String strPath) {
        long usableSpace = 0L;
        if (!strPath.isEmpty()) {
            try {
                Path path = Paths.get(strPath, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = path.getParent();
                }
                FileStore fileStore = Files.getFileStore(path);
                usableSpace = fileStore.getUsableSpace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return usableSpace;
    }

    private void calculateAndCheckDiskSpace() {
        this.jRadioButtonAufloesungHd.setForeground(Color.black);
        this.jRadioButtonAufloesungHoch.setForeground(Color.black);
        this.jRadioButtonAufloesungKlein.setForeground(Color.black);
        try {
            long usableSpace = this.getFreeDiskSpace(this.cbPathTextComponent.getText());
            if (usableSpace > 0L) {
                this.filmBorder.setTitle("Film laden [ noch frei: " + MVFunction.humanReadableByteCount(usableSpace, true) + " ]");
            } else {
                this.filmBorder.setTitle(TITLED_BORDER_STRING);
            }
            this.jPanelSize.repaint();
            if ((usableSpace /= 1000000L) > 0L) {
                int size;
                if (!this.dateiGroesse_HD.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_HD)) > usableSpace) {
                    this.jRadioButtonAufloesungHd.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Hoch.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Hoch)) > usableSpace) {
                    this.jRadioButtonAufloesungHoch.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Klein.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Klein)) > usableSpace) {
                    this.jRadioButtonAufloesungKlein.setForeground(Color.red);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setModelPfad(String pfad) {
        ArrayList<String> pfade = new ArrayList<String>();
        if (!Boolean.parseBoolean(Daten.mVConfig.get("Letzen-Pfad-anzeigen")) && !pfad.isEmpty()) {
            pfade.add(pfad);
        }
        if (!Daten.mVConfig.get("Pfade-zum-Speichern").isEmpty()) {
            String[] p;
            for (String s : p = Daten.mVConfig.get("Pfade-zum-Speichern").split("<>")) {
                if (pfade.contains(s)) continue;
                pfade.add(s);
            }
        }
        if (Boolean.parseBoolean(Daten.mVConfig.get("Letzen-Pfad-anzeigen")) && !pfad.isEmpty() && !pfade.contains(pfad)) {
            pfade.add(pfad);
        }
        this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[pfade.size()])));
    }

    private void saveComboPfad() {
        int i;
        ArrayList<String> pfade = new ArrayList<String>();
        String s = this.jComboBoxPfad.getSelectedItem().toString();
        if (!s.equals(this.orgPfad) || this.jCheckBoxPfadSpeichern.isSelected()) {
            pfade.add(s);
        }
        for (i = 0; i < this.jComboBoxPfad.getItemCount(); ++i) {
            s = this.jComboBoxPfad.getItemAt(i);
            if (s.equals(this.orgPfad) || pfade.contains(s)) continue;
            pfade.add(s);
        }
        if (pfade.size() > 0) {
            s = (String)pfade.get(0);
            for (i = 1; i < 15 && i < pfade.size(); ++i) {
                if (((String)pfade.get(i)).isEmpty()) continue;
                s = s + "<>" + (String)pfade.get(i);
            }
        }
        Daten.mVConfig.add("Pfade-zum-Speichern", s);
    }

    private void setupResolutionButtons() {
        this.pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(this.jComboBoxPset.getSelectedIndex());
        if (this.aufloesung.equals("hd") || this.pSet.arr[15].equals("hd") && !this.datenFilm.arr[20].isEmpty()) {
            this.jRadioButtonAufloesungHd.setSelected(true);
        } else if (this.pSet.arr[15].equals("klein") && !this.datenFilm.arr[18].isEmpty()) {
            this.jRadioButtonAufloesungKlein.setSelected(true);
        } else {
            this.jRadioButtonAufloesungHoch.setSelected(true);
        }
        this.jCheckBoxInfodatei.setSelected(Boolean.parseBoolean(this.pSet.arr[19]));
        if (this.datenFilm.arr[15].isEmpty()) {
            this.jCheckBoxSubtitle.setEnabled(false);
        } else {
            this.jCheckBoxSubtitle.setSelected(Boolean.parseBoolean(this.pSet.arr[21]));
        }
        this.setNameFilm();
    }

    private String getFilmResolution() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return "hd";
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return "klein";
        }
        return "normal";
    }

    private String getFilmSize() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return this.dateiGroesse_HD;
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return this.dateiGroesse_Klein;
        }
        return this.dateiGroesse_Hoch;
    }

    private boolean check() {
        this.ok = false;
        String pfad = this.jComboBoxPfad.getSelectedItem().toString();
        String name = this.jTextFieldName.getText();
        if (this.datenDownload != null) {
            if (pfad.isEmpty() || name.isEmpty()) {
                MVMessageDialog.showMessageDialog(this, "Pfad oder Name ist leer", "Fehlerhafter Pfad/Name!", 0);
            } else {
                if (!pfad.substring(pfad.length() - 1).equals(File.separator)) {
                    pfad = pfad + File.separator;
                }
                if (GuiFunktionenProgramme.checkPfadBeschreibbar(pfad)) {
                    this.ok = true;
                } else {
                    MVMessageDialog.showMessageDialog(this, "Pfad ist nicht beschreibbar", "Fehlerhafter Pfad!", 0);
                }
            }
        }
        return this.ok;
    }

    private void beenden() {
        if (this.ok) {
            this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, this.jTextFieldName.getText(), this.jComboBoxPfad.getSelectedItem().toString(), this.getFilmResolution());
            this.datenDownload.setGroesse(this.getFilmSize());
            this.datenDownload.arr[33] = Boolean.toString(this.jCheckBoxInfodatei.isSelected());
            this.datenDownload.arr[35] = Boolean.toString(this.jCheckBoxSubtitle.isSelected());
            Daten.listeDownloads.addMitNummer(this.datenDownload);
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
            if (this.jCheckBoxStarten.isSelected()) {
                this.datenDownload.startDownload(this.daten);
            }
        }
        this.saveComboPfad();
        this.dispose();
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jCheckBoxStarten = new JCheckBox();
        JPanel jPanel1 = new JPanel();
        this.jTextFieldName = new JTextField();
        this.jButtonZiel = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.jComboBoxPfad = new JComboBox();
        this.jButtonDelHistory = new JButton();
        this.jCheckBoxPfadSpeichern = new JCheckBox();
        this.jCheckBoxInfodatei = new JCheckBox();
        this.jLabelSet = new JLabel();
        this.jComboBoxPset = new JComboBox();
        this.jCheckBoxSubtitle = new JCheckBox();
        this.jPanelSize = new JPanel();
        this.jRadioButtonAufloesungHd = new JRadioButton();
        this.jRadioButtonAufloesungHoch = new JRadioButton();
        this.jRadioButtonAufloesungKlein = new JRadioButton();
        this.jTextFieldSender = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Film speichern");
        this.jButtonOk.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jCheckBoxStarten.setSelected(true);
        this.jCheckBoxStarten.setText("Download sofort starten");
        jPanel1.setBorder(BorderFactory.createTitledBorder("Film speichen"));
        this.jButtonZiel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonZiel.setToolTipText("Zielpfad ausw\u00e4hlen");
        jLabel1.setText("Zielpfad:");
        jLabel4.setText("Dateiname:");
        this.jComboBoxPfad.setEditable(true);
        this.jComboBoxPfad.setMaximumRowCount(15);
        this.jButtonDelHistory.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/del_16.png")));
        this.jButtonDelHistory.setToolTipText("History l\u00f6schen");
        this.jCheckBoxPfadSpeichern.setText("Zielpfad speichern");
        this.jCheckBoxInfodatei.setText("Infodatei anlegen: \"Filmname.txt\"");
        this.jLabelSet.setText("Set:");
        this.jCheckBoxSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSet).addComponent(jLabel1)).addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxPfad, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelHistory)).addComponent(this.jComboBoxPset, 0, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxSubtitle).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxInfodatei).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 143, Short.MAX_VALUE).addComponent(this.jCheckBoxPfadSpeichern)).addComponent(this.jTextFieldName)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSet).addComponent(this.jComboBoxPset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jButtonZiel).addComponent(this.jComboBoxPfad, -2, -1, -2).addComponent(this.jButtonDelHistory)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxPfadSpeichern).addComponent(this.jCheckBoxInfodatei)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSubtitle).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldName);
        this.jPanelSize.setBorder(BorderFactory.createTitledBorder("Film laden in"));
        buttonGroup1.add(this.jRadioButtonAufloesungHd);
        this.jRadioButtonAufloesungHd.setText("HD");
        buttonGroup1.add(this.jRadioButtonAufloesungHoch);
        this.jRadioButtonAufloesungHoch.setText("hoher Aufl\u00f6sung");
        buttonGroup1.add(this.jRadioButtonAufloesungKlein);
        this.jRadioButtonAufloesungKlein.setText("niedriger Aufl\u00f6sung");
        GroupLayout jPanelSizeLayout = new GroupLayout(this.jPanelSize);
        this.jPanelSize.setLayout(jPanelSizeLayout);
        jPanelSizeLayout.setHorizontalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAufloesungHd).addGap(18, 18, 18).addComponent(this.jRadioButtonAufloesungHoch).addGap(18, 18, 18).addComponent(this.jRadioButtonAufloesungKlein).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSizeLayout.setVerticalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAufloesungHd).addComponent(this.jRadioButtonAufloesungHoch).addComponent(this.jRadioButtonAufloesungKlein)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldSender.setEditable(false);
        this.jTextFieldSender.setFont(new Font("Dialog", 1, 12));
        this.jTextFieldSender.setText(" ARD: Tatort, ...");
        this.jTextFieldSender.setBorder(BorderFactory.createTitledBorder("Film"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelSize, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxStarten).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen)).addComponent(this.jTextFieldSender)).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonAbbrechen)).addComponent(this.jCheckBoxStarten)).addContainerGap()));
        this.pack();
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog chooser = new FileDialog((Frame)((DialogAddDownload)DialogAddDownload.this).daten.mediathekGui, "Film speichern");
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        DialogAddDownload.this.jComboBoxPfad.addItem(chooser.getDirectory() + chooser.getFile());
                        DialogAddDownload.this.jComboBoxPfad.setSelectedItem(chooser.getDirectory() + chooser.getFile());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(356871087, ex);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!DialogAddDownload.this.jComboBoxPfad.getSelectedItem().toString().equals("")) {
                    chooser.setCurrentDirectory(new File(DialogAddDownload.this.jComboBoxPfad.getSelectedItem().toString()));
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        DialogAddDownload.this.jComboBoxPfad.addItem(chooser.getSelectedFile().getAbsolutePath());
                        DialogAddDownload.this.jComboBoxPfad.setSelectedItem(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(356871087, ex);
                    }
                }
            }
        }
    }

    private class BeobRadio
    implements ActionListener {
        private BeobRadio() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogAddDownload.this.setNameFilm();
        }
    }
}

