/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.util.ListIterator;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenProg;
import mediathek.daten.ListeProg;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.MVMessageDialog;

public class DatenPset {
    public static final String PROGRAMMSET = "Programmset";
    public static final String PROGRAMMSET_NAME = "Name";
    public static final int PROGRAMMSET_NAME_NR = 0;
    public static final String PROGRAMMSET_PRAEFIX_DIREKT = "Praefix";
    public static final int PROGRAMMSET_PRAEFIX_DIREKT_NR = 1;
    public static final String PROGRAMMSET_SUFFIX_DIREKT = "Suffix";
    public static final int PROGRAMMSET_SUFFIX_DIREKT_NR = 2;
    public static final String PROGRAMMSET_FARBE = "Farbe";
    public static final int PROGRAMMSET_FARBE_NR = 3;
    public static final String PROGRAMMSET_ZIEL_PFAD = "Zielpfad";
    public static final int PROGRAMMSET_ZIEL_PFAD_NR = 4;
    public static final String PROGRAMMSET_ZIEL_DATEINAME = "Zieldateiname";
    public static final int PROGRAMMSET_ZIEL_DATEINAME_NR = 5;
    public static final String PROGRAMMSET_THEMA_ANLEGEN = "Thema-anlegen";
    public static final int PROGRAMMSET_THEMA_ANLEGEN_NR = 6;
    public static final String PROGRAMMSET_IST_ABSPIELEN = "Abspielen";
    public static final int PROGRAMMSET_IST_ABSPIELEN_NR = 7;
    public static final String PROGRAMMSET_IST_SPEICHERN = "Speichern";
    public static final int PROGRAMMSET_IST_SPEICHERN_NR = 8;
    public static final String PROGRAMMSET_IST_BUTTON = "Button";
    public static final int PROGRAMMSET_IST_BUTTON_NR = 9;
    public static final String PROGRAMMSET_IST_ABO = "Abo";
    public static final int PROGRAMMSET_IST_ABO_NR = 10;
    public static final String PROGRAMMSET_LAENGE_BESCHRAENKEN = "Laenge";
    public static final int PROGRAMMSET_LAENGE_BESCHRAENKEN_NR = 11;
    public static final String PROGRAMMSET_LAENGE_FIELD_BESCHRAENKEN = "Laenge-Feld";
    public static final int PROGRAMMSET_LAENGE_FIELD_BESCHRAENKEN_NR = 12;
    public static final String PROGRAMMSET_MAX_LAENGE = "max-Laenge";
    public static final int PROGRAMMSET_MAX_LAENGE_NR = 13;
    public static final String PROGRAMMSET_MAX_LAENGE_FIELD = "max-Laenge-Feld";
    public static final int PROGRAMMSET_MAX_LAENGE_FIELD_NR = 14;
    public static final String PROGRAMMSET_AUFLOESUNG = "Aufloesung";
    public static final int PROGRAMMSET_AUFLOESUNG_NR = 15;
    public static final String PROGRAMMSET_ADD_ON = "AddOn";
    public static final int PROGRAMMSET_ADD_ON_NR = 16;
    public static final String PROGRAMMSET_BESCHREIBUNG = "Beschreibung";
    public static final int PROGRAMMSET_BESCHREIBUNG_NR = 17;
    public static final String PROGRAMMSET_INFO_URL = "Info-URL";
    public static final int PROGRAMMSET_INFO_URL_NR = 18;
    public static final String PROGRAMMSET_INFODATEI = "Infodatei";
    public static final int PROGRAMMSET_INFODATEI_NR = 19;
    public static final String PROGRAMMSET_SPOTLIGHT = "Spotlight";
    public static final int PROGRAMMSET_SPOTLIGHT_NR = 20;
    public static final String PROGRAMMSET_SUBTITLE = "Untertitel";
    public static final int PROGRAMMSET_SUBTITLE_NR = 21;
    public static final int MAX_ELEM = 22;
    public static final String[] COLUMN_NAMES = new String[]{"Setname", "Pr\u00e4fix", "Suffix", "Farbe", "Zielpfad", "Zieldateiname", "Thema-anlegen", "Abspielen", "Speichern", "Button", "Abo", "Laenge", "Laenge-Feld", "max-Laenge", "max-Laenge-Feld", "Aufl\u00f6sung", "AddOn", "Beschreibung", "Info-URL", "Infodatei", "Spotlight", "Untertitel"};
    public static final String[] COLUMN_NAMES_ = new String[]{"Name", "Praefix", "Suffix", "Farbe", "Zielpfad", "Zieldateiname", "Thema-anlegen", "Abspielen", "Speichern", "Button", "Abo", "Laenge", "Laenge-Feld", "max-Laenge", "max-Laenge-Feld", "Aufloesung", "AddOn", "Beschreibung", "Info-URL", "Infodatei", "Spotlight", "Untertitel"};
    private ListeProg listeProg = new ListeProg();
    public static boolean[] spaltenAnzeigen = new boolean[22];
    public String[] arr;

    public DatenPset() {
        this.makeArray();
    }

    public DatenPset(String name) {
        this.makeArray();
        this.arr[0] = name;
        this.arr[9] = Boolean.TRUE.toString();
    }

    public boolean addProg(DatenProg prog) {
        return this.listeProg.add(prog);
    }

    public ListeProg getListeProg() {
        return this.listeProg;
    }

    public DatenProg getProg(int i) {
        return (DatenProg)this.listeProg.get(i);
    }

    public boolean progsContainPath() {
        boolean ret = false;
        for (DatenProg prog : this.listeProg) {
            if (!prog.arr[3].contains("**") && !prog.arr[3].contains("%a") && !prog.arr[3].contains("%b")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean isEmpty() {
        boolean ret = true;
        for (int i = 0; i < this.arr.length; ++i) {
            if (this.arr[i].isEmpty()) continue;
            ret = false;
        }
        if (!this.listeProg.isEmpty()) {
            ret = false;
        }
        return ret;
    }

    public boolean istAbspielen() {
        return Boolean.parseBoolean(this.arr[7]);
    }

    public boolean istSpeichern() {
        return Boolean.parseBoolean(this.arr[8]);
    }

    public boolean istButton() {
        return Boolean.parseBoolean(this.arr[9]);
    }

    public boolean istAbo() {
        return Boolean.parseBoolean(this.arr[10]);
    }

    public boolean isLable() {
        return this.listeProg.isEmpty() && !this.arr[0].equals("");
    }

    public boolean isFreeLine() {
        return this.arr[0].equals("");
    }

    public void setAbspielen(Daten daten) {
        for (DatenPset datenPset : Daten.listePset) {
            datenPset.arr[7] = Boolean.FALSE.toString();
        }
        this.arr[7] = Boolean.TRUE.toString();
    }

    public void setSpeichern(boolean set) {
        this.arr[8] = Boolean.toString(set);
    }

    public void setButton(boolean set) {
        this.arr[9] = Boolean.toString(set);
    }

    public void setAbo(boolean set) {
        this.arr[10] = Boolean.toString(set);
    }

    public DatenProg getProgUrl(String url) {
        DatenProg ret = null;
        if (this.listeProg.isEmpty()) {
            MVMessageDialog.showMessageDialog(null, "Programme einrichten!", "Kein Programm", 1);
        } else if (this.listeProg.size() == 1) {
            ret = (DatenProg)this.listeProg.getFirst();
        } else {
            for (DatenProg prog : this.listeProg) {
                if (!prog.urlTesten(url)) continue;
                ret = prog;
                break;
            }
            if (!this.listeProg.isEmpty() && ret == null) {
                ret = (DatenProg)this.listeProg.getLast();
            }
        }
        return ret;
    }

    public String getZielDateiname(String url) {
        DatenProg prog = this.getProgUrl(url);
        String ret = this.arr[5];
        if (!this.checkDownloadDirekt(url) && prog != null && !prog.arr[1].equals("")) {
            ret = prog.arr[1];
        }
        return ret;
    }

    public String getZielPfad() {
        return this.arr[4];
    }

    public DatenPset copy() {
        DatenPset ret = new DatenPset();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.arr[0] = "Kopie-" + this.arr[0];
        ret.arr[7] = Boolean.toString(false);
        ListIterator it = this.getListeProg().listIterator(0);
        while (it.hasNext()) {
            ret.addProg(((DatenProg)it.next()).copy());
        }
        return ret;
    }

    public Color getFarbe() {
        Color ret = null;
        if (!this.arr[3].equals("")) {
            String r = this.arr[3].substring(0, this.arr[3].indexOf(44));
            String g = this.arr[3].substring(this.arr[3].indexOf(44) + 1, this.arr[3].lastIndexOf(44));
            String b = this.arr[3].substring(this.arr[3].lastIndexOf(44) + 1);
            try {
                ret = new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
            }
            catch (Exception ex) {
                Log.fehlerMeldung(669254033, ex);
            }
        }
        return ret;
    }

    public void setFarbe(Color farbe) {
        this.arr[3] = farbe.getRed() + "," + farbe.getGreen() + "," + farbe.getBlue();
    }

    public boolean checkDownloadDirekt(String url) {
        return (!this.arr[1].equals("") || !this.arr[2].equals("")) && GuiFunktionenProgramme.praefixTesten(this.arr[1], url, true) && GuiFunktionenProgramme.praefixTesten(this.arr[2], url, false);
    }

    public String toString() {
        String ret = "";
        ret = ret + "================================================" + Daten.LINE_SEPARATOR;
        ret = ret + "| Programmset" + Daten.LINE_SEPARATOR;
        for (int i = 0; i < 22; ++i) {
            ret = ret + "| " + COLUMN_NAMES[i] + ": " + this.arr[i] + Daten.LINE_SEPARATOR;
        }
        for (Object aListeProg : this.listeProg) {
            ret = ret + "|" + Daten.LINE_SEPARATOR;
            ret = ret + aListeProg.toString();
        }
        ret = ret + "|_______________________________________________" + Daten.LINE_SEPARATOR;
        return ret;
    }

    private void makeArray() {
        this.arr = new String[22];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
        this.arr[6] = Boolean.toString(true);
        this.arr[7] = Boolean.toString(false);
        this.arr[8] = Boolean.toString(false);
        this.arr[9] = Boolean.toString(false);
        this.arr[10] = Boolean.toString(false);
        this.arr[11] = Boolean.toString(false);
        this.arr[12] = Boolean.toString(false);
        this.arr[19] = Boolean.toString(false);
        this.arr[20] = Boolean.toString(SystemInfo.isMacOSX());
        this.arr[21] = Boolean.toString(false);
        this.arr[15] = "normal";
    }
}

