/*
 * Decompiled with CFR 0.152.
 */
package app.authkit.envoy;

import app.util.BasicAlert;
import app.util.FileDialogger;
import glguerin.authkit.Authorization;
import glguerin.authkit.imp.plain.DenyAllAuthorization;
import glguerin.util.CaptureOutputStream;
import glguerin.util.SinkOutputStream;
import glguerin.util.Streamer;
import glguerin.util.VectorUtil;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Tool {
    public void tell(String string) {
        System.out.println(string);
    }

    public void explain(String string) {
        System.out.flush();
        System.err.println(string);
        System.err.flush();
    }

    public void explain(Throwable throwable) {
        System.out.flush();
        throwable.printStackTrace(System.err);
        System.err.flush();
    }

    protected Tool() {
    }

    public abstract void perform(String[] var1);

    public void depart(int n) {
        if (Boolean.getBoolean("no-exit")) {
            System.err.println("depart: " + n);
            throw new ThreadDeath();
        }
        System.exit(n);
    }

    protected void presupposeProperty(String string, String string2) {
        if (System.getProperty(string) == null) {
            ((Hashtable)System.getProperties()).put(string, string2);
        }
    }

    protected Authorization newAuth() {
        String string = "glguerin.authkit.imp.plain.DenyAllAuthorization";
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            string = "glguerin.authkit.imp.macosx.MacOSXAuthorization";
        }
        try {
            return (Authorization)Class.forName(string).newInstance();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.explain(throwable);
            return new DenyAllAuthorization();
        }
    }

    protected String[] stripPrefixed(String[] stringArray, String string) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2 != null && !string2.startsWith(string)) {
                vector.addElement(string2);
            }
            ++n;
        }
        if (vector.size() != stringArray.length) {
            stringArray = new String[vector.size()];
            vector.copyInto(stringArray);
        }
        return stringArray;
    }

    protected Frame nonceFrame() {
        Frame frame = new Frame();
        frame.setResizable(false);
        return frame;
    }

    protected String[] chooseTarget(String string, int n) {
        File file = FileDialogger.runFileDialog(this.nonceFrame(), string, n);
        if (file == null) {
            return null;
        }
        return new String[]{file.getAbsolutePath()};
    }

    public String mustBeAppBundle(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("No such file or directory: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IOException("Not a bundle directory: " + file.getAbsolutePath());
        }
        File file2 = new File(file, "Contents" + File.separator + "PkgInfo");
        if (!file2.isFile() || file2.length() < 8L) {
            throw new IOException("Missing or truncated Contents/PkgInfo file: " + file.getAbsolutePath());
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
        try {
            if (randomAccessFile.readInt() != 1095782476) {
                throw new IOException("Not an app-bundle: " + file.getAbsolutePath());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
        return file.getCanonicalPath();
    }

    protected String[] makeEnvoyCommand(String string, String[] stringArray, String string2, String string3, String string4, String[] stringArray2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Needs non-null envoyClass");
        }
        Vector<String> vector = new Vector<String>(7);
        this.addJavaCommand(vector, string, stringArray);
        this.addPrefixedProperties(vector, string3);
        vector.addElement(string2);
        this.addEnvoyTask(vector, string4, stringArray2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected String getJavaPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("java.home"));
        stringBuffer.append(File.separator);
        if (string != null && string.length() != 0) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("bin").append(File.separator).append("java");
        }
        return stringBuffer.toString();
    }

    protected void addJavaCommand(Vector vector, String string, String[] stringArray) {
        vector.addElement(this.getJavaPath(string));
        vector.addElement("-cp");
        vector.addElement(System.getProperty("java.class.path"));
        this.addOneProperty(vector, "file.encoding");
        VectorUtil.addToVector(vector, stringArray, false);
    }

    protected void addPrefixedProperties(Vector vector, String string) {
        if (string != null) {
            Enumeration<?> enumeration = System.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                if (!string2.startsWith(string)) continue;
                this.addOneProperty(vector, string2);
            }
        }
    }

    protected void addOneProperty(Vector vector, String string) {
        String string2;
        if (string != null && (string2 = System.getProperty(string)) != null) {
            vector.addElement("-D" + string + "=" + string2);
        }
    }

    protected void addEnvoyTask(Vector vector, String string, String[] stringArray) {
        vector.addElement(System.getProperty("envoy.tasks.between", ":-"));
        if (string != null) {
            vector.addElement(string);
        }
        VectorUtil.addToVector(vector, stringArray, false);
    }

    protected byte[] captureUntilEOF(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        if (outputStream == null) {
            outputStream = new SinkOutputStream();
        }
        CaptureOutputStream captureOutputStream = new CaptureOutputStream(outputStream, n);
        this.schlepUntilEOF(inputStream, captureOutputStream);
        return captureOutputStream.getCaptured();
    }

    protected long schlepUntilEOF(InputStream inputStream, OutputStream outputStream) throws IOException {
        return new Streamer(new byte[4096], inputStream, false, outputStream, false, true).pump();
    }

    protected String translateEnvoyMessage(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] < 0) {
                byArray[n] = 63;
            }
            ++n;
        }
        return new String(byArray);
    }

    protected Object[] getEnvoyMessageParts(String string, int n, String string2) {
        int n2 = n < 0 ? string.lastIndexOf(string2, string.length() + n) : string.indexOf(string2, n);
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf("\n", n2);
        if (n3 < 0) {
            return null;
        }
        String string3 = string.substring(n2, n3);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
        Object[] objectArray = new Object[stringTokenizer.countTokens()];
        int n4 = 0;
        while (n4 < objectArray.length) {
            objectArray[n4] = stringTokenizer.nextToken();
            try {
                objectArray[n4] = new Integer(Integer.parseInt(objectArray[n4].toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n4;
        }
        return objectArray;
    }

    protected int waitForEnvoy(InputStream inputStream, OutputStream outputStream) throws IOException {
        String string = this.translateEnvoyMessage(this.captureUntilEOF(inputStream, outputStream, 40));
        Object[] objectArray = this.getEnvoyMessageParts(string, -1, "stop");
        if (objectArray == null) {
            throw new IOException("Envoy protocol failure: no STOP message");
        }
        if (objectArray.length < 3) {
            throw new IOException("Envoy protocol failure: short parts: " + objectArray.length);
        }
        if (((Number)objectArray[1]).intValue() != 0) {
            throw new IOException("Envoy protocol failure: bad indicator: " + objectArray[1]);
        }
        return ((Number)objectArray[2]).intValue();
    }

    protected void failed(Throwable throwable, boolean bl, String string) {
        String string2 = throwable.getMessage();
        if (string2 == null || string2.length() == 0) {
            string2 = "Caught: " + throwable.getClass().getName();
        }
        if (bl) {
            this.explain(throwable);
        } else {
            this.explain(string2);
        }
        this.alert(string, new Object[]{string2});
    }

    protected void alert(String string, Object[] objectArray) {
        if (Boolean.getBoolean("alert")) {
            int n = objectArray.length;
            int n2 = 0;
            if (n < 5) {
                n = 5;
            }
            if (n > 12) {
                n = 12;
                n2 = 2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < objectArray.length) {
                Object object = objectArray[n3];
                if (object != null) {
                    stringBuffer.append(object.toString()).append("\n");
                }
                ++n3;
            }
            new BasicAlert(this.nonceFrame(), string, true, stringBuffer.toString(), n, 50, n2, 0.25f, 0.5f).show();
        }
    }
}

