/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.PriceSource;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.trading.CreateOrderDlg;
import org.yccheok.jstock.portfolio.BrokingFirm;
import org.yccheok.jstock.portfolio.DecimalPlace;
import org.yccheok.jstock.trading.api.OrderManager;

public class JStockOptions {
    public static final Color DEFAULT_NORMAL_TEXT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR = new Color(50, 150, 0);
    public static final Color DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR = new Color(200, 0, 50);
    public static final Color DEFAULT_FIRST_ROW_BACKGROUND_COLOR = Color.WHITE;
    public static final Color DEFAULT_SECOND_ROW_BACKGROUND_COLOR = new Color(255, 255, 204);
    public static final Color DEFAULT_AUTO_UPDATE_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_AUTO_UPDATE_BACKGROUND_COLOR = Color.RED;
    public static final Color DEFAULT_FALL_BELOW_ALERT_FOREGROUND_COLOR = Color.YELLOW;
    public static final Color DEFAULT_FALL_BELOW_ALERT_BACKGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_RISE_ABOVE_ALERT_FOREGROUND_COLOR = Color.YELLOW;
    public static final Color DEFAULT_RISE_ABOVE_ALERT_BACKGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_CHAT_SYSTEM_MESSAGE_COLOR = Color.RED;
    public static final Color DEFAULT_CHAT_OWN_MESSAGE_COLOR = new Color(169, 169, 169);
    public static final Color DEFAULT_CHAT_OTHER_MESSAGE_COLOR = new Color(100, 149, 237);
    private static final YellowInformationBoxOption DEFAULT_YELLOW_INFORMATION_BOX_OPTION = YellowInformationBoxOption.Follow;
    private static final StockInputSuggestionListOption DEFAULT_STOCK_INPUT_SUGGESTION_LIST_OPTION = StockInputSuggestionListOption.TwoColumns;
    private static final int DEFAULT_HISTORY_DURATION = 10;
    private static final int DEFAULT_RECENT_COUNTRY_SIZE = 5;
    private boolean soundEnabled = false;
    private boolean singleIndicatorAlert = true;
    private boolean popupMessage = true;
    private boolean sendEmail = false;
    @Deprecated
    private transient String email;
    @Deprecated
    private transient String emailPassword;
    private String CCEmail = "";
    @Deprecated
    private transient String googleCalendarUsername;
    @Deprecated
    private transient String googleCalendarPassword;
    @Deprecated
    private transient boolean SMSEnabled;
    @Deprecated
    private transient boolean passwordProtectedIndicator;
    @Deprecated
    private transient String indicatorPassword;
    private String proxyServer = "";
    private int proxyPort = -1;
    private int scanningSpeed = 60000;
    private int indicatorScanningSpeed = 30000;
    private int alertSpeed = 5;
    private String looknFeel = null;
    private boolean alwaysOnTop = false;
    private Color normalTextForegroundColor;
    private Color lowerNumericalValueForegroundColor;
    private Color higherNumericalValueForegroundColor;
    private Color firstRowBackgroundColor;
    private Color secondRowBackgroundColor;
    private Color autoUpdateForegroundColor;
    private Color autoUpdateBackgroundColor;
    @Deprecated
    private transient Color alertForegroundColor;
    @Deprecated
    private transient Color alertBackgroundColor;
    private Color fallBelowAlertForegroundColor;
    private Color fallBelowAlertBackgroundColor;
    private Color riseAboveAlertForegroundColor;
    private Color riseAboveAlertBackgroundColor;
    private boolean enableColorChange = false;
    private boolean enableColorAlert = false;
    private List<BrokingFirm> brokingFirms = new ArrayList<BrokingFirm>();
    private int selectedBrokingFirmIndex = -1;
    @Deprecated
    private transient boolean isAutoBrokerFeeCalculationEnabled = false;
    private double expectedProfitPercentage = 10.0;
    private Country country;
    private boolean isAutoUpdateNewsEnabled = true;
    @Deprecated
    private transient long newsVersion;
    private String newsID = "";
    private int historyDuration = 10;
    private boolean isChatEnabled = false;
    private String chatUsername = "";
    private String chatPassword = "";
    private boolean isChatSoundNotificationEnabled = true;
    private boolean isChatFlashNotificationEnabled = true;
    private Color chatSystemMessageColor;
    private Color chatOwnMessageColor;
    private Color chatOtherMessageColor;
    private transient Credentials credentials = null;
    private String proxyAuthPassword = "";
    private String proxyAuthUserName = "";
    private boolean isProxyAuthEnabled = false;
    private boolean driveWealthRememberLogin = false;
    private String driveWealthSessionKey = null;
    private Map<String, Long> driveWealthLastTxnTimestamp = new HashMap<String, Long>();
    private DriveWealthBuySellOption driveWealthBuyOption = null;
    private DriveWealthBuySellOption driveWealthSellOption = null;
    @Deprecated
    private transient boolean rememberGoogleAccountEnabled = false;
    @Deprecated
    private transient String googleUsername = "";
    @Deprecated
    private transient String googlePassword = "";
    private String lastFileIODirectory = System.getProperty("user.home");
    private String lastFileNameExtensionDescription = "CSV Documents (*.csv)";
    @Deprecated
    private transient Map<Country, Class> primaryStockServerFactoryClasses = new EnumMap<Country, Class>(Country.class);
    @Deprecated
    private transient Boolean primaryStockServerFactoryClassesIsValidForMalaysia = true;
    private int lastSelectedPageIndex = 0;
    private int lastSelectedSellPortfolioChartIndex = 0;
    private int lastSelectedBuyPortfolioChartIndex = 0;
    @Deprecated
    private transient int maxSMSPerDay = -1;
    @Deprecated
    private transient String portfolioName = org.yccheok.jstock.portfolio.Utils.getDefaultPortfolioName();
    private Map<Country, String> portfolioNames = new EnumMap<Country, String>(Country.class);
    @Deprecated
    private transient String watchlistName = org.yccheok.jstock.watchlist.Utils.getDefaultWatchlistName();
    private Map<Country, String> watchlistNames = new EnumMap<Country, String>(Country.class);
    private YellowInformationBoxOption yellowInformationBoxOption = YellowInformationBoxOption.Follow;
    private StockInputSuggestionListOption stockInputSuggestionListOption = StockInputSuggestionListOption.OneColumn;
    private Locale locale = Locale.getDefault();
    private BoundsEx boundsEx = null;
    private Map<Country, Long> googleCodeDatabaseMeta = new EnumMap<Country, Long>(Country.class);
    private Map<Country, PriceSource> priceSources = new EnumMap<Country, PriceSource>(Country.class);
    private Map<Country, String> currencies = new EnumMap<Country, String>(Country.class);
    private Map<Country, Boolean> currencyExchangeEnable = new EnumMap<Country, Boolean>(Country.class);
    private Map<Country, Country> localCurrencyCountries = new EnumMap<Country, Country>(Country.class);
    private Map<Country, Boolean> preferLongNames = new EnumMap<Country, Boolean>(Country.class);
    @Deprecated
    private transient Map<Country, Boolean> penceToPoundConversionEnabled = new EnumMap<Country, Boolean>(Country.class);
    @Deprecated
    private transient Map<Country, Boolean> fourDecimalPlacesEnabled = new EnumMap<Country, Boolean>(Country.class);
    private Map<Country, DecimalPlace> decimalPlaces = new EnumMap<Country, DecimalPlace>(Country.class);
    private int applicationVersionID = Utils.getApplicationVersionID();
    private ChartTheme chartTheme = ChartTheme.Light;
    private boolean isFeeCalculationEnabled = false;
    private boolean useLargeFont = false;
    private boolean isDynamicChartVisible = false;
    private List<Country> recentCountries = new ArrayList<Country>();
    private long iexStockInfoDBMeta = 0L;

    public JStockOptions() {
        this.country = Country.UnitedState;
        this.normalTextForegroundColor = DEFAULT_NORMAL_TEXT_FOREGROUND_COLOR;
        this.higherNumericalValueForegroundColor = DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        this.lowerNumericalValueForegroundColor = DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        this.firstRowBackgroundColor = DEFAULT_FIRST_ROW_BACKGROUND_COLOR;
        this.secondRowBackgroundColor = DEFAULT_SECOND_ROW_BACKGROUND_COLOR;
        this.autoUpdateForegroundColor = DEFAULT_AUTO_UPDATE_FOREGROUND_COLOR;
        this.autoUpdateBackgroundColor = DEFAULT_AUTO_UPDATE_BACKGROUND_COLOR;
        this.fallBelowAlertForegroundColor = DEFAULT_FALL_BELOW_ALERT_FOREGROUND_COLOR;
        this.fallBelowAlertBackgroundColor = DEFAULT_FALL_BELOW_ALERT_BACKGROUND_COLOR;
        this.riseAboveAlertForegroundColor = DEFAULT_RISE_ABOVE_ALERT_FOREGROUND_COLOR;
        this.riseAboveAlertBackgroundColor = DEFAULT_RISE_ABOVE_ALERT_BACKGROUND_COLOR;
        this.chatSystemMessageColor = DEFAULT_CHAT_SYSTEM_MESSAGE_COLOR;
        this.chatOwnMessageColor = DEFAULT_CHAT_OWN_MESSAGE_COLOR;
        this.chatOtherMessageColor = DEFAULT_CHAT_OTHER_MESSAGE_COLOR;
        this.yellowInformationBoxOption = DEFAULT_YELLOW_INFORMATION_BOX_OPTION;
        this.stockInputSuggestionListOption = DEFAULT_STOCK_INPUT_SUGGESTION_LIST_OPTION;
        this.locale = Locale.getDefault();
        this.initRecentCountries();
    }

    public void insensitiveCopy(JStockOptions jStockOptions) {
        this.singleIndicatorAlert = jStockOptions.singleIndicatorAlert;
        this.popupMessage = jStockOptions.popupMessage;
        this.scanningSpeed = jStockOptions.scanningSpeed;
        this.indicatorScanningSpeed = jStockOptions.indicatorScanningSpeed;
        this.alertSpeed = jStockOptions.alertSpeed;
        this.looknFeel = jStockOptions.looknFeel;
        this.alwaysOnTop = jStockOptions.alwaysOnTop;
        this.normalTextForegroundColor = jStockOptions.normalTextForegroundColor;
        this.lowerNumericalValueForegroundColor = jStockOptions.lowerNumericalValueForegroundColor;
        this.higherNumericalValueForegroundColor = jStockOptions.higherNumericalValueForegroundColor;
        this.firstRowBackgroundColor = jStockOptions.firstRowBackgroundColor;
        this.secondRowBackgroundColor = jStockOptions.secondRowBackgroundColor;
        this.autoUpdateForegroundColor = jStockOptions.autoUpdateForegroundColor;
        this.autoUpdateBackgroundColor = jStockOptions.autoUpdateBackgroundColor;
        this.fallBelowAlertForegroundColor = jStockOptions.fallBelowAlertForegroundColor;
        this.fallBelowAlertBackgroundColor = jStockOptions.fallBelowAlertBackgroundColor;
        this.riseAboveAlertForegroundColor = jStockOptions.riseAboveAlertForegroundColor;
        this.riseAboveAlertBackgroundColor = jStockOptions.riseAboveAlertBackgroundColor;
        this.enableColorChange = jStockOptions.enableColorChange;
        this.enableColorAlert = jStockOptions.enableColorAlert;
        this.brokingFirms = jStockOptions.brokingFirms;
        this.selectedBrokingFirmIndex = jStockOptions.selectedBrokingFirmIndex;
        this.expectedProfitPercentage = jStockOptions.expectedProfitPercentage;
        this.country = jStockOptions.country;
        this.isAutoUpdateNewsEnabled = jStockOptions.isAutoUpdateNewsEnabled;
        this.historyDuration = jStockOptions.historyDuration;
        this.isChatSoundNotificationEnabled = jStockOptions.isChatSoundNotificationEnabled;
        this.isChatFlashNotificationEnabled = jStockOptions.isChatFlashNotificationEnabled;
        this.chatSystemMessageColor = jStockOptions.chatSystemMessageColor;
        this.chatOwnMessageColor = jStockOptions.chatOwnMessageColor;
        this.chatOtherMessageColor = jStockOptions.chatOtherMessageColor;
        this.driveWealthRememberLogin = jStockOptions.driveWealthRememberLogin;
        this.driveWealthLastTxnTimestamp = jStockOptions.driveWealthLastTxnTimestamp;
        this.driveWealthBuyOption = jStockOptions.driveWealthBuyOption;
        this.driveWealthSellOption = jStockOptions.driveWealthSellOption;
        this.decimalPlaces = jStockOptions.decimalPlaces;
        this.lastSelectedPageIndex = jStockOptions.lastSelectedPageIndex;
        this.lastSelectedSellPortfolioChartIndex = jStockOptions.lastSelectedSellPortfolioChartIndex;
        this.lastSelectedBuyPortfolioChartIndex = jStockOptions.lastSelectedBuyPortfolioChartIndex;
        this.portfolioNames = new EnumMap<Country, String>(jStockOptions.portfolioNames);
        this.watchlistNames = new EnumMap<Country, String>(jStockOptions.watchlistNames);
        this.yellowInformationBoxOption = jStockOptions.yellowInformationBoxOption;
        this.stockInputSuggestionListOption = jStockOptions.stockInputSuggestionListOption;
        this.priceSources = new EnumMap<Country, PriceSource>(jStockOptions.priceSources);
        this.currencies = new EnumMap<Country, String>(jStockOptions.currencies);
        this.currencyExchangeEnable = new EnumMap<Country, Boolean>(jStockOptions.currencyExchangeEnable);
        this.localCurrencyCountries = new EnumMap<Country, Country>(jStockOptions.localCurrencyCountries);
        this.preferLongNames = new EnumMap<Country, Boolean>(this.preferLongNames);
        this.decimalPlaces = new EnumMap<Country, DecimalPlace>(jStockOptions.decimalPlaces);
        this.chartTheme = jStockOptions.getChartTheme();
        this.isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled;
        this.useLargeFont = jStockOptions.useLargeFont;
        this.isDynamicChartVisible = jStockOptions.isDynamicChartVisible;
    }

    public JStockOptions insensitiveClone() {
        JStockOptions jStockOptions = new JStockOptions();
        jStockOptions.insensitiveCopy(this);
        return jStockOptions;
    }

    private void initRecentCountries() {
        if (this.recentCountries == null) {
            this.recentCountries = new ArrayList<Country>();
        }
        Country[] countries = new Country[]{Country.UnitedState, Country.Canada, Country.Malaysia, Country.UnitedKingdom, Country.Singapore};
        if (this.recentCountries.size() != 5) {
            if (this.recentCountries.size() < 5) {
                for (Country country : countries) {
                    this.recentCountries.add(country);
                }
            }
            HashSet<Country> c = new HashSet<Country>(this.recentCountries);
            this.recentCountries = new ArrayList<Country>(c);
            int k = this.recentCountries.size();
            if (k > 5) {
                this.recentCountries.subList(5, k).clear();
            }
        }
    }

    private Object readResolve() {
        if (this.lastSelectedPageIndex < 0) {
            this.lastSelectedPageIndex = 0;
        }
        if (this.lastSelectedSellPortfolioChartIndex < 0) {
            this.lastSelectedSellPortfolioChartIndex = 0;
        }
        if (this.lastSelectedBuyPortfolioChartIndex < 0) {
            this.lastSelectedBuyPortfolioChartIndex = 0;
        }
        if (this.brokingFirms == null) {
            this.brokingFirms = new ArrayList<BrokingFirm>();
        }
        if (this.country == null) {
            this.country = Country.UnitedState;
        } else {
            List<Country> countries = Utils.getSupportedStockMarketCountries();
            if (!countries.contains((Object)this.country)) {
                this.country = Country.UnitedState;
            }
        }
        this.initRecentCountries();
        if (this.historyDuration <= 0) {
            this.historyDuration = 10;
        }
        if (this.getChatUsername() == null) {
            this.setChatUsername("");
        }
        if (this.getChatPassword() == null) {
            this.setChatPassword("");
        }
        if (this.getChatSystemMessageColor() == null) {
            this.setChatSystemMessageColor(DEFAULT_CHAT_SYSTEM_MESSAGE_COLOR);
        }
        if (this.getChatOwnMessageColor() == null) {
            this.setChatOwnMessageColor(DEFAULT_CHAT_OWN_MESSAGE_COLOR);
        }
        if (this.getChatOtherMessageColor() == null) {
            this.setChatOtherMessageColor(DEFAULT_CHAT_OTHER_MESSAGE_COLOR);
        }
        if (this.getFallBelowAlertForegroundColor() == null) {
            this.setFallBelowAlertForegroundColor(DEFAULT_FALL_BELOW_ALERT_FOREGROUND_COLOR);
        }
        if (this.getFallBelowAlertBackgroundColor() == null) {
            this.setFallBelowAlertBackgroundColor(DEFAULT_FALL_BELOW_ALERT_BACKGROUND_COLOR);
        }
        if (this.getRiseAboveAlertForegroundColor() == null) {
            this.setRiseAboveAlertForegroundColor(DEFAULT_RISE_ABOVE_ALERT_FOREGROUND_COLOR);
        }
        if (this.getRiseAboveAlertBackgroundColor() == null) {
            this.setRiseAboveAlertBackgroundColor(DEFAULT_RISE_ABOVE_ALERT_BACKGROUND_COLOR);
        }
        if (this.proxyAuthUserName == null) {
            this.proxyAuthUserName = "";
        }
        if (this.proxyAuthPassword == null) {
            this.proxyAuthPassword = "";
        }
        this.setCredentials((Credentials)new NTCredentials(this.proxyAuthUserName, Utils.decrypt(this.proxyAuthPassword), "", ""));
        if (this.getLastFileIODirectory() == null) {
            this.setLastFileIODirectory("");
        }
        if (this.getLastSavedFileNameExtensionDescription() == null) {
            this.setLastFileNameExtensionDescription("CSV Documents (*.csv)");
        }
        if (this.portfolioNames == null) {
            this.portfolioNames = new EnumMap<Country, String>(Country.class);
        }
        if (this.watchlistNames == null) {
            this.watchlistNames = new EnumMap<Country, String>(Country.class);
        }
        if (this.getNewsID() == null) {
            this.setNewsID("");
        }
        if (this.yellowInformationBoxOption == null) {
            this.yellowInformationBoxOption = YellowInformationBoxOption.Follow;
        }
        if (this.stockInputSuggestionListOption == null) {
            this.stockInputSuggestionListOption = StockInputSuggestionListOption.OneColumn;
        }
        if (this.getCCEmail() == null) {
            this.setCCEmail("");
        }
        if (this.getLocale() == null) {
            this.setLocale(Locale.getDefault());
        }
        if (this.googleCodeDatabaseMeta == null) {
            this.googleCodeDatabaseMeta = new EnumMap<Country, Long>(Country.class);
        }
        if (this.priceSources == null) {
            this.priceSources = new EnumMap<Country, PriceSource>(Country.class);
        } else if (this.priceSources.get((Object)Country.Malaysia) == PriceSource.KLSEInfo) {
            this.priceSources.put(Country.Malaysia, PriceSource.Yahoo);
        }
        if (this.currencies == null) {
            this.currencies = new EnumMap<Country, String>(Country.class);
        }
        if (this.currencyExchangeEnable == null) {
            this.currencyExchangeEnable = new EnumMap<Country, Boolean>(Country.class);
        }
        if (this.localCurrencyCountries == null) {
            this.localCurrencyCountries = new EnumMap<Country, Country>(Country.class);
        }
        if (this.preferLongNames == null) {
            this.preferLongNames = new EnumMap<Country, Boolean>(Country.class);
        }
        if (this.decimalPlaces == null) {
            this.decimalPlaces = new EnumMap<Country, DecimalPlace>(Country.class);
        }
        if (this.locale.getCountry().equals(Locale.FRANCE.getCountry()) && this.locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            this.locale = Locale.FRANCE;
        }
        if (this.chartTheme == null) {
            this.chartTheme = ChartTheme.Light;
        }
        if (this.scanningSpeed <= 1000) {
            this.scanningSpeed = 10000;
        }
        if (this.indicatorScanningSpeed <= 0) {
            this.indicatorScanningSpeed = 30000;
        }
        if (this.driveWealthLastTxnTimestamp == null) {
            this.driveWealthLastTxnTimestamp = new HashMap<String, Long>();
        }
        return this;
    }

    public int getBrokingFirmSize() {
        return this.brokingFirms.size();
    }

    public List<BrokingFirm> getBrokingFirms() {
        return Collections.unmodifiableList(this.brokingFirms);
    }

    public BrokingFirm getBrokingFirm(int index) {
        return this.brokingFirms.get(index);
    }

    public int getSelectedBrokingFirmIndex() {
        return this.selectedBrokingFirmIndex;
    }

    public void setSelectedBrokingFirmIndex(int selectedBrokingFirmIndex) {
        this.selectedBrokingFirmIndex = selectedBrokingFirmIndex;
    }

    public void clearBrokingFirms() {
        this.brokingFirms.clear();
    }

    public void addBrokingFirm(BrokingFirm brokingFirm) {
        this.brokingFirms.add(brokingFirm);
    }

    public BrokingFirm getSelectedBrokingFirm() {
        if (this.selectedBrokingFirmIndex < 0 || this.selectedBrokingFirmIndex >= this.getBrokingFirmSize()) {
            return null;
        }
        return this.brokingFirms.get(this.selectedBrokingFirmIndex);
    }

    public String getLooknFeel() {
        return this.looknFeel;
    }

    public void setLooknFeel(String looknFeel) {
        this.looknFeel = looknFeel;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
    }

    public boolean isSingleIndicatorAlert() {
        return this.singleIndicatorAlert;
    }

    public void setSingleIndicatorAlert(boolean singleIndicatorAlert) {
        this.singleIndicatorAlert = singleIndicatorAlert;
    }

    public boolean isPopupMessage() {
        return this.popupMessage;
    }

    public void setPopupMessage(boolean popupMessage) {
        this.popupMessage = popupMessage;
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getScanningSpeed() {
        return this.scanningSpeed;
    }

    public int getIndicatorScanningSpeed() {
        return this.indicatorScanningSpeed;
    }

    public int getAlertSpeed() {
        return this.alertSpeed;
    }

    public void setIndicatorScanningSpeed(int indicatorScanningSpeed) {
        this.indicatorScanningSpeed = indicatorScanningSpeed;
    }

    public void setScanningSpeed(int scanningSpeed) {
        this.scanningSpeed = scanningSpeed;
    }

    public void setAlertSpeed(int alertSpeed) {
        this.alertSpeed = alertSpeed;
    }

    public Color getNormalTextForegroundColor() {
        return this.normalTextForegroundColor;
    }

    public void setNormalTextForegroundColor(Color normalTextForegroundColor) {
        this.normalTextForegroundColor = normalTextForegroundColor;
    }

    public Color getLowerNumericalValueForegroundColor() {
        return this.lowerNumericalValueForegroundColor;
    }

    public void setLowerNumericalValueForegroundColor(Color lowerNumericalValueForegroundColor) {
        this.lowerNumericalValueForegroundColor = lowerNumericalValueForegroundColor;
    }

    public Color getHigherNumericalValueForegroundColor() {
        return this.higherNumericalValueForegroundColor;
    }

    public void setHigherNumericalValueForegroundColor(Color higherNumericalValueForegroundColor) {
        this.higherNumericalValueForegroundColor = higherNumericalValueForegroundColor;
    }

    public Color getFirstRowBackgroundColor() {
        return this.firstRowBackgroundColor;
    }

    public void setFirstRowBackgroundColor(Color firstRowBackgroundColor) {
        this.firstRowBackgroundColor = firstRowBackgroundColor;
    }

    public Color getSecondRowBackgroundColor() {
        return this.secondRowBackgroundColor;
    }

    public void setSecondRowBackgroundColor(Color secondRowBackgroundColor) {
        this.secondRowBackgroundColor = secondRowBackgroundColor;
    }

    public Color getAutoUpdateForegroundColor() {
        return this.autoUpdateForegroundColor;
    }

    public void setAutoUpdateForegroundColor(Color autoUpdateForegroundColor) {
        this.autoUpdateForegroundColor = autoUpdateForegroundColor;
    }

    public Color getAutoUpdateBackgroundColor() {
        return this.autoUpdateBackgroundColor;
    }

    public void setAutoUpdateBackgroundColor(Color autoUpdateBackgroundColor) {
        this.autoUpdateBackgroundColor = autoUpdateBackgroundColor;
    }

    public boolean isEnableColorChange() {
        return this.enableColorChange;
    }

    public void setEnableColorChange(boolean enableColorChange) {
        this.enableColorChange = enableColorChange;
    }

    public boolean isAutoUpdateNewsEnabled() {
        return this.isAutoUpdateNewsEnabled;
    }

    public boolean isChatEnabled() {
        return this.isChatEnabled;
    }

    public boolean isChatSoundNotificationEnabled() {
        return this.isChatSoundNotificationEnabled;
    }

    public boolean isChatFlashNotificationEnabled() {
        return this.isChatFlashNotificationEnabled;
    }

    public void setAutoUpdateNewsEnabled(boolean isAutoUpdateNewsEnabled) {
        this.isAutoUpdateNewsEnabled = isAutoUpdateNewsEnabled;
    }

    public void setChatEnabled(boolean isChatEnabled) {
        this.isChatEnabled = isChatEnabled;
    }

    public void setChatFlashNotificationEnabled(boolean isChatFlashNotificationEnabled) {
        this.isChatFlashNotificationEnabled = isChatFlashNotificationEnabled;
    }

    public void setChatSoundNotificationEnabled(boolean isChatSoundNotificationEnabled) {
        this.isChatSoundNotificationEnabled = isChatSoundNotificationEnabled;
    }

    public double getExpectedProfitPercentage() {
        return this.expectedProfitPercentage;
    }

    public void setExpectedProfitPercentage(double expectedProfitPercentage) {
        this.expectedProfitPercentage = expectedProfitPercentage;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public int getHistoryDuration() {
        return this.historyDuration;
    }

    public void setHistoryDuration(int historyDuration) {
        this.historyDuration = historyDuration;
    }

    public String getChatUsername() {
        return this.chatUsername;
    }

    public void setChatUsername(String chatUsername) {
        this.chatUsername = chatUsername;
    }

    public Color getChatSystemMessageColor() {
        return this.chatSystemMessageColor;
    }

    public void setChatSystemMessageColor(Color chatSystemMessageColor) {
        this.chatSystemMessageColor = chatSystemMessageColor;
    }

    public Color getChatOwnMessageColor() {
        return this.chatOwnMessageColor;
    }

    public void setChatOwnMessageColor(Color chatOwnMessageColor) {
        this.chatOwnMessageColor = chatOwnMessageColor;
    }

    public Color getChatOtherMessageColor() {
        return this.chatOtherMessageColor;
    }

    public void setChatOtherMessageColor(Color chatOtherMessageColor) {
        this.chatOtherMessageColor = chatOtherMessageColor;
    }

    public String getChatPassword() {
        return this.chatPassword;
    }

    public void setChatPassword(String chatPassword) {
        this.chatPassword = chatPassword;
    }

    public boolean isEnableColorAlert() {
        return this.enableColorAlert;
    }

    public void setEnableColorAlert(boolean enableColorAlert) {
        this.enableColorAlert = enableColorAlert;
    }

    public String getDriveWealthSessionKey() {
        return this.driveWealthSessionKey;
    }

    public void setDriveWealthSessionKey(String driveWealthSessionKey) {
        this.driveWealthSessionKey = driveWealthSessionKey;
    }

    public boolean isDriveWealthRememberLogin() {
        return this.driveWealthRememberLogin;
    }

    public void setDriveWealthRememberLogin(boolean driveWealthRememberLogin) {
        this.driveWealthRememberLogin = driveWealthRememberLogin;
    }

    public Long getDriveWealthLastTxnTimestamp(String accountID) {
        return this.driveWealthLastTxnTimestamp.get(accountID);
    }

    public void setDriveWealthLastTxnTimestamp(String accountID, long timestamp) {
        this.driveWealthLastTxnTimestamp.put(accountID, timestamp);
    }

    public DriveWealthBuySellOption getDriveWealthBuyOption() {
        return this.driveWealthBuyOption;
    }

    public void setDriveWealthBuyOption(OrderManager.OrderType ordType, CreateOrderDlg.AmountQty amtQty) {
        this.driveWealthBuyOption = new DriveWealthBuySellOption(ordType, amtQty);
    }

    public DriveWealthBuySellOption getDriveWealthSellOption() {
        return this.driveWealthSellOption;
    }

    public void setDriveWealthSellOption(OrderManager.OrderType ordType, CreateOrderDlg.AmountQty amtQty) {
        this.driveWealthSellOption = new DriveWealthBuySellOption(ordType, amtQty);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = proxyAuthPassword;
        this.setCredentials((Credentials)new NTCredentials(this.proxyAuthUserName, Utils.decrypt(this.proxyAuthPassword), "", ""));
    }

    public String getProxyAuthUserName() {
        return this.proxyAuthUserName;
    }

    public void setProxyAuthUserName(String proxyAuthUserName) {
        this.proxyAuthUserName = proxyAuthUserName;
        this.setCredentials((Credentials)new NTCredentials(this.proxyAuthUserName, Utils.decrypt(this.proxyAuthPassword), "", ""));
    }

    public boolean isProxyAuthEnabled() {
        return this.isProxyAuthEnabled;
    }

    public void setIsProxyAuthEnabled(boolean isProxyAuthEnabled) {
        this.isProxyAuthEnabled = isProxyAuthEnabled;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getLastFileIODirectory() {
        return this.lastFileIODirectory;
    }

    public void setLastFileIODirectory(String lastFileIODirectory) {
        this.lastFileIODirectory = lastFileIODirectory;
    }

    public String getLastSavedFileNameExtensionDescription() {
        return this.lastFileNameExtensionDescription;
    }

    public void setLastFileNameExtensionDescription(String lastFileNameExtensionDescription) {
        this.lastFileNameExtensionDescription = lastFileNameExtensionDescription;
    }

    public int getLastSelectedPageIndex() {
        return this.lastSelectedPageIndex;
    }

    public void setLastSelectedPageIndex(int lastSelectedPageIndex) {
        this.lastSelectedPageIndex = lastSelectedPageIndex;
    }

    public int getLastSelectedBuyPortfolioChartIndex() {
        return this.lastSelectedBuyPortfolioChartIndex;
    }

    public void setLastSelectedBuyPortfolioChartIndex(int lastSelectedBuyPortfolioChartIndex) {
        this.lastSelectedBuyPortfolioChartIndex = lastSelectedBuyPortfolioChartIndex;
    }

    public int getLastSelectedSellPortfolioChartIndex() {
        return this.lastSelectedSellPortfolioChartIndex;
    }

    public void setLastSelectedSellPortfolioChartIndex(int lastSelectedSellPortfolioChartIndex) {
        this.lastSelectedSellPortfolioChartIndex = lastSelectedSellPortfolioChartIndex;
    }

    public String getWatchlistName() {
        String p = this.watchlistNames.get((Object)this.country);
        if (p == null) {
            return org.yccheok.jstock.watchlist.Utils.getDefaultWatchlistName();
        }
        return p;
    }

    public String getPortfolioName() {
        String p = this.portfolioNames.get((Object)this.country);
        if (p == null) {
            return org.yccheok.jstock.portfolio.Utils.getDefaultPortfolioName();
        }
        return p;
    }

    public void setPortfolioName(String p) {
        this.portfolioNames.put(this.country, p);
    }

    public void setWatchlistName(String watchlistName) {
        this.watchlistNames.put(this.country, watchlistName);
    }

    public String getNewsID() {
        return this.newsID;
    }

    public void setNewsID(String newsID) {
        this.newsID = newsID;
    }

    public DecimalPlace getDecimalPlace() {
        DecimalPlace decimalPlace = this.decimalPlaces.get((Object)this.country);
        if (decimalPlace == null) {
            return DecimalPlace.Two;
        }
        return decimalPlace;
    }

    public void setDecimalPlace(DecimalPlace decimalPlace) {
        this.decimalPlaces.put(this.country, decimalPlace);
    }

    public Long getGoogleCodeDatabaseMetaTimestamp(Country country) {
        return this.googleCodeDatabaseMeta.get((Object)country);
    }

    public void setGoogleCodeDatabaseMetaTimestamp(Country country, long timestamp) {
        this.googleCodeDatabaseMeta.put(country, timestamp);
    }

    public PriceSource getPriceSource(Country country) {
        PriceSource priceSource = this.priceSources.get((Object)country);
        if (priceSource == null) {
            return org.yccheok.jstock.engine.Utils.getDefaultPriceSource(country);
        }
        return priceSource;
    }

    public void setPriceSource(Country country, PriceSource priceSource) {
        this.priceSources.put(country, priceSource);
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public void setSoundEnabled(boolean soundEnabled) {
        this.soundEnabled = soundEnabled;
    }

    public String getCurrencySymbol(Country c) {
        String currecySymbol = this.currencies.get((Object)c);
        if (currecySymbol == null) {
            return Utils.getDefaultCurrencySymbol();
        }
        return currecySymbol;
    }

    public void setCurrencySymbol(Country c, String s) {
        this.currencies.put(c, s);
    }

    public boolean isCurrencyExchangeEnable(Country c) {
        Boolean flag = this.currencyExchangeEnable.get((Object)c);
        if (flag != null) {
            return flag;
        }
        return false;
    }

    public void setCurrencyExchangeEnable(Country country, boolean enable) {
        this.currencyExchangeEnable.put(country, enable);
    }

    public Country getLocalCurrencyCountry(Country country) {
        Country localCountry = this.localCurrencyCountries.get((Object)country);
        if (localCountry != null) {
            return localCountry;
        }
        return country;
    }

    public void setLocalCurrencyCountry(Country country, Country localCurrencyCountry) {
        this.localCurrencyCountries.put(country, localCurrencyCountry);
    }

    public boolean isPreferLongName(Country country) {
        Boolean prefer = this.preferLongNames.get((Object)country);
        if (prefer != null) {
            return prefer;
        }
        return true;
    }

    public void setPreferLongName(Country country, boolean prefer) {
        this.preferLongNames.put(country, prefer);
    }

    public YellowInformationBoxOption getYellowInformationBoxOption() {
        return this.yellowInformationBoxOption;
    }

    public void setYellowInformationBoxOption(YellowInformationBoxOption yellowInformationBoxOption) {
        this.yellowInformationBoxOption = yellowInformationBoxOption;
    }

    public String getCCEmail() {
        return this.CCEmail;
    }

    public void setCCEmail(String CCEmail) {
        this.CCEmail = CCEmail;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public BoundsEx getBoundsEx() {
        return this.boundsEx;
    }

    public void setBoundsEx(BoundsEx boundsEx) {
        this.boundsEx = boundsEx;
    }

    public Color getFallBelowAlertForegroundColor() {
        return this.fallBelowAlertForegroundColor;
    }

    public void setFallBelowAlertForegroundColor(Color fallBelowAlertForegroundColor) {
        this.fallBelowAlertForegroundColor = fallBelowAlertForegroundColor;
    }

    public Color getFallBelowAlertBackgroundColor() {
        return this.fallBelowAlertBackgroundColor;
    }

    public void setFallBelowAlertBackgroundColor(Color fallBelowAlertBackgroundColor) {
        this.fallBelowAlertBackgroundColor = fallBelowAlertBackgroundColor;
    }

    public Color getRiseAboveAlertForegroundColor() {
        return this.riseAboveAlertForegroundColor;
    }

    public void setRiseAboveAlertForegroundColor(Color riseAboveAlertForegroundColor) {
        this.riseAboveAlertForegroundColor = riseAboveAlertForegroundColor;
    }

    public Color getRiseAboveAlertBackgroundColor() {
        return this.riseAboveAlertBackgroundColor;
    }

    public void setRiseAboveAlertBackgroundColor(Color riseAboveAlertBackgroundColor) {
        this.riseAboveAlertBackgroundColor = riseAboveAlertBackgroundColor;
    }

    public StockInputSuggestionListOption getStockInputSuggestionListOption() {
        return this.stockInputSuggestionListOption;
    }

    public void setStockInputSuggestionListOption(StockInputSuggestionListOption stockInputSuggestionListOption) {
        this.stockInputSuggestionListOption = stockInputSuggestionListOption;
    }

    public int getApplicationVersionID() {
        return this.applicationVersionID;
    }

    public void setApplicationVersionID(int applicationVersionID) {
        this.applicationVersionID = applicationVersionID;
    }

    public ChartTheme getChartTheme() {
        return this.chartTheme;
    }

    public void setChartTheme(ChartTheme chartTheme) {
        this.chartTheme = chartTheme;
    }

    public boolean isFeeCalculationEnabled() {
        return this.isFeeCalculationEnabled;
    }

    public boolean useLargeFont() {
        return this.useLargeFont;
    }

    public boolean isDynamicChartVisible() {
        return this.isDynamicChartVisible;
    }

    public void setFeeCalculationEnabled(boolean isFeeCalculationEnabled) {
        this.isFeeCalculationEnabled = isFeeCalculationEnabled;
    }

    public void setUseLargeFont(boolean useLargeFont) {
        this.useLargeFont = useLargeFont;
    }

    public void setDynamicChartVisible(boolean isDynamicChartVisible) {
        this.isDynamicChartVisible = isDynamicChartVisible;
    }

    public List<Country> getRecentCountries() {
        ArrayList<Country> countries = new ArrayList<Country>(this.recentCountries);
        Collections.sort(countries);
        return countries;
    }

    public void addRecentCountry(Country country) {
        if (this.recentCountries.contains((Object)country)) {
            return;
        }
        if (this.recentCountries.size() >= 5) {
            this.recentCountries.remove(0);
        }
        this.recentCountries.add(country);
    }

    public long getIEXStockInfoDBMeta() {
        return this.iexStockInfoDBMeta;
    }

    public void setIEXStockInfoDBMeta(long iexStockInfoDBMeta) {
        this.iexStockInfoDBMeta = iexStockInfoDBMeta;
    }

    public static enum ChartTheme {
        Light,
        Dark;

    }

    public static enum YellowInformationBoxOption {
        Stay,
        Follow,
        Hide;

    }

    public static enum StockInputSuggestionListOption {
        OneColumn,
        TwoColumns;

    }

    public static class BoundsEx {
        public final Rectangle bounds;
        public final int extendedState;

        public BoundsEx(Rectangle bounds, int extendedState) {
            this.bounds = bounds;
            this.extendedState = extendedState;
        }
    }

    public static class DriveWealthBuySellOption {
        public final OrderManager.OrderType orderType;
        public final CreateOrderDlg.AmountQty amountQty;

        public DriveWealthBuySellOption(OrderManager.OrderType orderType, CreateOrderDlg.AmountQty amountQty) {
            this.orderType = orderType;
            this.amountQty = amountQty;
        }
    }
}

